/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.exception.KeyException;
import org.pgpainless.exception.MissingDecryptionMethodException;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.KeyRingUtils;

public class CertificateWithMissingSecretKeyTest {
    private static final String MISSING_SIGNING_SECKEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: E97B 15E6 52FA 8BAE 2311  DDCB A5BD 9DC4 4415 C987\nComment: Missing Signing Subkey <missing@signing.subkey>\n\nlFgEYjCuERYJKwYBBAHaRw8BAQdAaqeTdbyb/D+UXd2aXsP58+k+tvt22DnL6bC0\n7p2tJacAAP0fEmwUY7rSPugQakzsA8nV4Nv3PYlKa6meqEePT+8s8BFitC9NaXNz\naW5nIFNpZ25pbmcgU3Via2V5IDxtaXNzaW5nQHNpZ25pbmcuc3Via2V5PoiPBBMW\nCgBBBQJiMK4RCRClvZ3ERBXJhxYhBOl7FeZS+ouuIxHdy6W9ncREFcmHAp4BApsB\nBRYCAwEABAsJCAcFFQoJCAsCmQEAAN0HAPkB7IphgTM94s/VpyV5+hvYbxesnji5\nRNzqs3nRhS8DBgEA/+gCpAkgznB3T/uNtWIoTf7Kuib5mIJ+SW0l+htuEgacXQRi\nMK4REgorBgEEAZdVAQUBAQdAlaQH44c7PdKkjaVVXvg86i+thKV121C/nH75Krhh\nQxYDAQgHAAD/aWJt9M85Al+57lPqS5ppzrIoCoTZ6JCwuJUSNEAg4BgQ6Ih1BBgW\nCgAdBQJiMK4RAp4BApsMBRYCAwEABAsJCAcFFQoJCAsACgkQpb2dxEQVyYdzuAD9\nGEkU7NfugHw8alQT7IJbUobVyZzeXQyzPqSKUw/Vp54BAJXZj8NzQrrM4Q5C3+Mf\nuznN+ryRovDXhf8T5PUXHloDuDMEYjCuERYJKwYBBAHaRw8BAQdAVeBpPurrwAU3\nns+1C2c6wJ8iTZ1eWEP2qgBAlokx5N+I1QQYFgoAfQUCYjCuEQKeAQKbAgUWAgMB\nAAQLCQgHBRUKCQgLXyAEGRYKAAYFAmIwrhEACgkQld4KwYO6xR4YEwEA942iduoW\n1ANEmwCwnYwMAa3HlXsMs5bdIUGnxuo7MBEA/1YYeAu45O2Z8kTdrDZM/1emoxt1\nj6EzybnaJ+2XGX4AAAoJEKW9ncREFcmHLXsBAITCIwGtaCvZdWCQlJeYak1NTuBp\nbmOEFga0sLmRI/zYAP97U2oc8dqV55S1b4yNkfENK2MD6Ow0nv8CL6+S0UaCBw==\n=eTh7\n-----END PGP PRIVATE KEY BLOCK-----";
    private static final long signingSubkeyId = -7647663290973502178L;
    private static PGPSecretKeyRing missingSigningSecKey;
    private static long encryptionSubkeyId;
    private static PGPSecretKeyRing missingDecryptionSecKey;
    private static final SecretKeyRingProtector protector;

    @BeforeAll
    public static void prepare() throws IOException, PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        missingSigningSecKey = PGPainless.readKeyRing().secretKeyRing(MISSING_SIGNING_SECKEY);
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Missing Decryption Key <missing@decryption.key>");
        encryptionSubkeyId = ((PGPPublicKey)PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getEncryptionSubkeys(EncryptionPurpose.ANY).get(0)).getKeyID();
        missingDecryptionSecKey = KeyRingUtils.stripSecretKey((PGPSecretKeyRing)secretKeys, (long)encryptionSubkeyId);
    }

    @Test
    public void assureMissingSigningSecKeyOnlyContainSigningPubKey() {
        Assertions.assertNotNull((Object)missingSigningSecKey.getPublicKey(-7647663290973502178L));
        Assertions.assertNull((Object)missingSigningSecKey.getSecretKey(-7647663290973502178L));
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)missingSigningSecKey);
        Assertions.assertFalse((boolean)info.getSigningSubkeys().isEmpty());
    }

    @Test
    public void assureMissingDecryptionSecKeyOnlyContainsEncryptionPubKey() {
        Assertions.assertNotNull((Object)missingDecryptionSecKey.getPublicKey(encryptionSubkeyId));
        Assertions.assertNull((Object)missingDecryptionSecKey.getSecretKey(encryptionSubkeyId));
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)missingDecryptionSecKey);
        Assertions.assertFalse((boolean)info.getEncryptionSubkeys(EncryptionPurpose.ANY).isEmpty());
    }

    @Test
    public void testSignWithMissingSigningSecKey() {
        SigningOptions signingOptions = SigningOptions.get();
        Assertions.assertThrows(KeyException.MissingSecretKeyException.class, () -> signingOptions.addInlineSignature(protector, missingSigningSecKey, DocumentSignatureType.CANONICAL_TEXT_DOCUMENT));
        Assertions.assertThrows(KeyException.MissingSecretKeyException.class, () -> signingOptions.addDetachedSignature(protector, missingSigningSecKey, DocumentSignatureType.CANONICAL_TEXT_DOCUMENT));
    }

    @Test
    public void testEncryptDecryptWithMissingDecryptionKey() throws PGPException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream("Hello, World!\n".getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PGPPublicKeyRing certificate = PGPainless.extractCertificate((PGPSecretKeyRing)missingDecryptionSecKey);
        ProducerOptions producerOptions = ProducerOptions.encrypt((EncryptionOptions)EncryptionOptions.encryptCommunications().addRecipient(certificate));
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(producerOptions);
        Streams.pipeAll((InputStream)in, (OutputStream)encryptionStream);
        encryptionStream.close();
        Assertions.assertTrue((boolean)encryptionStream.getResult().isEncryptedFor(certificate));
        ByteArrayInputStream cipherIn = new ByteArrayInputStream(out.toByteArray());
        ConsumerOptions consumerOptions = new ConsumerOptions().addDecryptionKey(missingDecryptionSecKey);
        Assertions.assertThrows(MissingDecryptionMethodException.class, () -> PGPainless.decryptAndOrVerify().onInputStream((InputStream)cipherIn).withOptions(consumerOptions));
    }

    static {
        protector = SecretKeyRingProtector.unprotectedKeys();
    }
}

