/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPV3SignatureGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MessageMetadata;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;

class VerifyVersion3SignaturePacketTest {
    protected static final byte[] DATA = "hello".getBytes(StandardCharsets.UTF_8);

    VerifyVersion3SignaturePacketTest() {
    }

    @Test
    void verifyDetachedVersion3Signature() throws PGPException, IOException {
        PGPSignature version3Signature = VerifyVersion3SignaturePacketTest.generateV3Signature();
        ConsumerOptions options = new ConsumerOptions().addVerificationCert(TestKeys.getEmilPublicKeyRing()).addVerificationOfDetachedSignatures((InputStream)new ByteArrayInputStream(version3Signature.getEncoded()));
        DecryptionStream verifier = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(DATA)).withOptions(options);
        MessageMetadata metadata = this.processSignedData(verifier);
        Assertions.assertTrue((boolean)metadata.isVerifiedSignedBy((PGPKeyRing)TestKeys.getEmilPublicKeyRing()));
    }

    private static PGPSignature generateV3Signature() throws IOException, PGPException {
        PGPContentSignerBuilder builder = ImplementationFactory.getInstance().getPGPContentSignerBuilder(PublicKeyAlgorithm.ECDSA, HashAlgorithm.SHA512);
        PGPV3SignatureGenerator signatureGenerator = new PGPV3SignatureGenerator(builder);
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        UnprotectedKeysProtector protector = SecretKeyRingProtector.unprotectedKeys();
        PGPPrivateKey privateKey = secretKeys.getSecretKey().extractPrivateKey(protector.getDecryptor(secretKeys.getSecretKey().getKeyID()));
        signatureGenerator.init(SignatureType.CANONICAL_TEXT_DOCUMENT.getCode(), privateKey);
        signatureGenerator.update(DATA);
        return signatureGenerator.generate();
    }

    private MessageMetadata processSignedData(DecryptionStream verifier) throws IOException {
        Streams.drain((InputStream)verifier);
        verifier.close();
        return verifier.getMetadata();
    }
}

