/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification.syntax_check;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.decryption_verification.syntax_check.InputSymbol;
import org.pgpainless.decryption_verification.syntax_check.PDA;
import org.pgpainless.exception.MalformedOpenPgpMessageException;

public class PDATest {
    @Test
    public void testSimpleLiteralMessageIsValid() throws MalformedOpenPgpMessageException {
        PDA check = new PDA();
        check.next(InputSymbol.LITERAL_DATA);
        check.next(InputSymbol.END_OF_SEQUENCE);
        Assertions.assertTrue((boolean)check.isValid());
    }

    @Test
    public void testSimpleOpsSignedMesssageIsValid() throws MalformedOpenPgpMessageException {
        PDA check = new PDA();
        check.next(InputSymbol.ONE_PASS_SIGNATURE);
        check.next(InputSymbol.LITERAL_DATA);
        check.next(InputSymbol.SIGNATURE);
        check.next(InputSymbol.END_OF_SEQUENCE);
        Assertions.assertTrue((boolean)check.isValid());
    }

    @Test
    public void testSimplePrependSignedMessageIsValid() throws MalformedOpenPgpMessageException {
        PDA check = new PDA();
        check.next(InputSymbol.SIGNATURE);
        check.next(InputSymbol.LITERAL_DATA);
        check.next(InputSymbol.END_OF_SEQUENCE);
        Assertions.assertTrue((boolean)check.isValid());
    }

    @Test
    public void testOPSSignedCompressedMessageIsValid() throws MalformedOpenPgpMessageException {
        PDA check = new PDA();
        check.next(InputSymbol.ONE_PASS_SIGNATURE);
        check.next(InputSymbol.COMPRESSED_DATA);
        check.next(InputSymbol.SIGNATURE);
        check.next(InputSymbol.END_OF_SEQUENCE);
        Assertions.assertTrue((boolean)check.isValid());
    }

    @Test
    public void testOPSSignedEncryptedMessageIsValid() {
        PDA check = new PDA();
        check.next(InputSymbol.ONE_PASS_SIGNATURE);
        check.next(InputSymbol.ENCRYPTED_DATA);
        check.next(InputSymbol.SIGNATURE);
        check.next(InputSymbol.END_OF_SEQUENCE);
        Assertions.assertTrue((boolean)check.isValid());
    }

    @Test
    public void anyInputAfterEOSIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.LITERAL_DATA);
        check.next(InputSymbol.END_OF_SEQUENCE);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.SIGNATURE));
    }

    @Test
    public void testEncryptedMessageWithAppendedStandaloneSigIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.ENCRYPTED_DATA);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.SIGNATURE));
    }

    @Test
    public void testOPSSignedEncryptedMessageWithMissingSigIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.ONE_PASS_SIGNATURE);
        check.next(InputSymbol.ENCRYPTED_DATA);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.END_OF_SEQUENCE));
    }

    @Test
    public void testTwoLiteralDataIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.LITERAL_DATA);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.LITERAL_DATA));
    }

    @Test
    public void testTrailingSigIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.LITERAL_DATA);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.SIGNATURE));
    }

    @Test
    public void testOPSAloneIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.ONE_PASS_SIGNATURE);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.END_OF_SEQUENCE));
    }

    @Test
    public void testOPSLitWithMissingSigIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.ONE_PASS_SIGNATURE);
        check.next(InputSymbol.LITERAL_DATA);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.END_OF_SEQUENCE));
    }

    @Test
    public void testCompressedMessageWithStandalongAppendedSigIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.COMPRESSED_DATA);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.SIGNATURE));
    }

    @Test
    public void testOPSCompressedDataWithMissingSigIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.ONE_PASS_SIGNATURE);
        check.next(InputSymbol.COMPRESSED_DATA);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.END_OF_SEQUENCE));
    }

    @Test
    public void testCompressedMessageFollowedByTrailingLiteralDataIsNotValid() {
        PDA check = new PDA();
        check.next(InputSymbol.COMPRESSED_DATA);
        Assertions.assertThrows(MalformedOpenPgpMessageException.class, () -> check.next(InputSymbol.LITERAL_DATA));
    }

    @Test
    public void testOPSWithPrependedSigIsValid() {
        PDA check = new PDA();
        check.next(InputSymbol.SIGNATURE);
        check.next(InputSymbol.ONE_PASS_SIGNATURE);
        check.next(InputSymbol.LITERAL_DATA);
        check.next(InputSymbol.SIGNATURE);
        check.next(InputSymbol.END_OF_SEQUENCE);
        Assertions.assertTrue((boolean)check.isValid());
    }

    @Test
    public void testPrependedSigInsideOPSSignedMessageIsValid() {
        PDA check = new PDA();
        check.next(InputSymbol.ONE_PASS_SIGNATURE);
        check.next(InputSymbol.SIGNATURE);
        check.next(InputSymbol.LITERAL_DATA);
        check.next(InputSymbol.SIGNATURE);
        check.next(InputSymbol.END_OF_SEQUENCE);
        Assertions.assertTrue((boolean)check.isValid());
    }
}

