/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.util.Passphrase;

public class HideArmorHeadersTest {
    @Test
    public void testVersionHeaderIsOmitted() throws PGPException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.encrypt((EncryptionOptions)EncryptionOptions.get().addMessagePassphrase(Passphrase.fromPassword((CharSequence)"sw0rdf1sh"))).setHideArmorHeaders(true));
        encryptionStream.write("Hello, World!\n".getBytes());
        encryptionStream.close();
        Assertions.assertTrue((boolean)out.toString().startsWith("-----BEGIN PGP MESSAGE-----\n\n"));
    }
}

