/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.example;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.util.DateUtil;
import org.pgpainless.util.Passphrase;

public class ModifyKeys {
    private final String userId = "alice@pgpainless.org";
    private final String originalPassphrase = "p4ssw0rd";
    private PGPSecretKeyRing secretKey;
    private long primaryKeyId;
    private long encryptionSubkeyId;
    private long signingSubkeyId;

    @BeforeEach
    public void generateKey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        this.secretKey = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"alice@pgpainless.org", "p4ssw0rd");
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)this.secretKey);
        this.primaryKeyId = info.getKeyId();
        this.encryptionSubkeyId = ((PGPPublicKey)info.getEncryptionSubkeys(EncryptionPurpose.ANY).get(0)).getKeyID();
        this.signingSubkeyId = ((PGPPublicKey)info.getSigningSubkeys().get(0)).getKeyID();
    }

    @Test
    public void extractPublicKey() {
        PGPPublicKeyRing certificate = PGPainless.extractCertificate((PGPSecretKeyRing)this.secretKey);
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)certificate);
        Assertions.assertFalse((boolean)info.isSecretKey());
    }

    @Test
    public void toAsciiArmoredString() throws IOException {
        PGPPublicKeyRing certificate = PGPainless.extractCertificate((PGPSecretKeyRing)this.secretKey);
        String asciiArmoredSecretKey = PGPainless.asciiArmor((PGPKeyRing)this.secretKey);
        String asciiArmoredCertificate = PGPainless.asciiArmor((PGPKeyRing)certificate);
        Assertions.assertTrue((boolean)asciiArmoredSecretKey.startsWith("-----BEGIN PGP PRIVATE KEY BLOCK-----"));
        Assertions.assertTrue((boolean)asciiArmoredCertificate.startsWith("-----BEGIN PGP PUBLIC KEY BLOCK-----"));
    }

    @Test
    public void changePassphrase() throws PGPException {
        this.secretKey = PGPainless.modifyKeyRing((PGPSecretKeyRing)this.secretKey).changePassphraseFromOldPassphrase(Passphrase.fromPassword((CharSequence)"p4ssw0rd")).withSecureDefaultSettings().toNewPassphrase(Passphrase.fromPassword((CharSequence)"n3wP4ssW0rD")).done();
        Assertions.assertThrows(WrongPassphraseException.class, () -> UnlockSecretKey.unlockSecretKey((PGPSecretKey)this.secretKey.getSecretKey(), (Passphrase)Passphrase.fromPassword((CharSequence)"p4ssw0rd")));
        UnlockSecretKey.unlockSecretKey((PGPSecretKey)this.secretKey.getSecretKey(), (Passphrase)Passphrase.fromPassword((CharSequence)"n3wP4ssW0rD"));
    }

    @Test
    public void changeSingleSubkeyPassphrase() throws PGPException {
        this.secretKey = PGPainless.modifyKeyRing((PGPSecretKeyRing)this.secretKey).changeSubKeyPassphraseFromOldPassphrase(this.encryptionSubkeyId, Passphrase.fromPassword((CharSequence)"p4ssw0rd")).withSecureDefaultSettings().toNewPassphrase(Passphrase.fromPassword((CharSequence)"cryptP4ssphr4s3")).done();
        Assertions.assertThrows(WrongPassphraseException.class, () -> UnlockSecretKey.unlockSecretKey((PGPSecretKey)this.secretKey.getSecretKey(this.encryptionSubkeyId), (Passphrase)Passphrase.fromPassword((CharSequence)"p4ssw0rd")));
        UnlockSecretKey.unlockSecretKey((PGPSecretKey)this.secretKey.getSecretKey(this.encryptionSubkeyId), (Passphrase)Passphrase.fromPassword((CharSequence)"cryptP4ssphr4s3"));
        UnlockSecretKey.unlockSecretKey((PGPSecretKey)this.secretKey.getSecretKey(this.primaryKeyId), (Passphrase)Passphrase.fromPassword((CharSequence)"p4ssw0rd"));
    }

    @Test
    public void addUserId() throws PGPException {
        SecretKeyRingProtector protector = SecretKeyRingProtector.unlockEachKeyWith((Passphrase)Passphrase.fromPassword((CharSequence)"p4ssw0rd"), (PGPSecretKeyRing)this.secretKey);
        this.secretKey = PGPainless.modifyKeyRing((PGPSecretKeyRing)this.secretKey).addUserId((CharSequence)"additional@user.id", protector).done();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)this.secretKey);
        Assertions.assertTrue((boolean)info.isUserIdValid((CharSequence)"additional@user.id"));
        Assertions.assertFalse((boolean)info.isUserIdValid((CharSequence)"another@user.id"));
    }

    @Test
    public void addSubkey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        SecretKeyRingProtector protector = SecretKeyRingProtector.unlockEachKeyWith((Passphrase)Passphrase.fromPassword((CharSequence)"p4ssw0rd"), (PGPSecretKeyRing)this.secretKey);
        Passphrase subkeyPassphrase = Passphrase.fromPassword((CharSequence)"subk3yP4ssphr4s3");
        this.secretKey = PGPainless.modifyKeyRing((PGPSecretKeyRing)this.secretKey).addSubKey(KeySpec.getBuilder((KeyType)KeyType.ECDH((EllipticCurve)EllipticCurve._BRAINPOOLP512R1), (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_COMMS}).build(), subkeyPassphrase, protector).done();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)this.secretKey);
        Assertions.assertEquals((int)4, (int)info.getSecretKeys().size());
        Assertions.assertEquals((int)4, (int)info.getPublicKeys().size());
        List encryptionSubkeys = info.getEncryptionSubkeys(EncryptionPurpose.COMMUNICATIONS);
        Assertions.assertEquals((int)2, (int)encryptionSubkeys.size());
        UnlockSecretKey.unlockSecretKey((PGPSecretKey)this.secretKey.getSecretKey(((PGPPublicKey)encryptionSubkeys.get(1)).getKeyID()), (Passphrase)subkeyPassphrase);
    }

    @Test
    public void setKeyExpirationDate() throws PGPException {
        Date expirationDate = DateUtil.parseUTCDate((String)"2030-06-24 12:44:56 UTC");
        SecretKeyRingProtector protector = SecretKeyRingProtector.unlockEachKeyWith((Passphrase)Passphrase.fromPassword((CharSequence)"p4ssw0rd"), (PGPSecretKeyRing)this.secretKey);
        this.secretKey = PGPainless.modifyKeyRing((PGPSecretKeyRing)this.secretKey).setExpirationDate(expirationDate, protector).done();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)this.secretKey);
        Assertions.assertEquals((Object)DateUtil.formatUTCDate((Date)expirationDate), (Object)DateUtil.formatUTCDate((Date)info.getPrimaryKeyExpirationDate()));
        Assertions.assertEquals((Object)DateUtil.formatUTCDate((Date)expirationDate), (Object)DateUtil.formatUTCDate((Date)info.getExpirationDateForUse(KeyFlag.ENCRYPT_COMMS)));
        Assertions.assertEquals((Object)DateUtil.formatUTCDate((Date)expirationDate), (Object)DateUtil.formatUTCDate((Date)info.getExpirationDateForUse(KeyFlag.SIGN_DATA)));
    }

    @Test
    public void revokeUserId() throws PGPException {
        SecretKeyRingProtector protector = SecretKeyRingProtector.unlockEachKeyWith((Passphrase)Passphrase.fromPassword((CharSequence)"p4ssw0rd"), (PGPSecretKeyRing)this.secretKey);
        this.secretKey = PGPainless.modifyKeyRing((PGPSecretKeyRing)this.secretKey).addUserId((CharSequence)"alcie@pgpainless.org", protector).done();
        Assertions.assertTrue((boolean)PGPainless.inspectKeyRing((PGPKeyRing)this.secretKey).isUserIdValid((CharSequence)"alcie@pgpainless.org"));
        this.secretKey = PGPainless.modifyKeyRing((PGPSecretKeyRing)this.secretKey).revokeUserId((CharSequence)"alcie@pgpainless.org", protector).done();
        Assertions.assertFalse((boolean)PGPainless.inspectKeyRing((PGPKeyRing)this.secretKey).isUserIdValid((CharSequence)"alcie@pgpainless.org"));
    }
}

