/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa_legacy.EdDSALegacyCurve;
import org.pgpainless.key.generation.type.xdh_legacy.XDHLegacySpec;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.key.util.UserId;
import org.pgpainless.util.TestAllImplementations;

public class GenerateEllipticCurveKeyTest {
    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void generateEllipticCurveKeys() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        PGPSecretKeyRing keyRing = ((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA_LEGACY((EdDSALegacyCurve)EdDSALegacyCurve._Ed25519), (KeyFlag[])new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA}))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.XDH_LEGACY((XDHLegacySpec)XDHLegacySpec._X25519), (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_COMMS}))).addUserId((CharSequence)UserId.onlyEmail((String)"alice@wonderland.lit").toString()).build();
        Assertions.assertEquals((int)PublicKeyAlgorithm.EDDSA_LEGACY.getAlgorithmId(), (int)keyRing.getPublicKey().getAlgorithm());
        UnlockSecretKey.unlockSecretKey((PGPSecretKey)keyRing.getSecretKey(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys());
    }
}

