/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa_legacy.EdDSALegacyCurve;
import org.pgpainless.key.generation.type.xdh_legacy.XDHLegacySpec;
import org.pgpainless.util.TestAllImplementations;

public class IllegalKeyFlagsTest {
    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void testKeyCannotCarryFlagsTest() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeySpec.getBuilder((KeyType)KeyType.XDH_LEGACY((XDHLegacySpec)XDHLegacySpec._X25519), (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeySpec.getBuilder((KeyType)KeyType.XDH_LEGACY((XDHLegacySpec)XDHLegacySpec._X25519), (KeyFlag[])new KeyFlag[]{KeyFlag.CERTIFY_OTHER}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeySpec.getBuilder((KeyType)KeyType.XDH_LEGACY((XDHLegacySpec)XDHLegacySpec._X25519), (KeyFlag[])new KeyFlag[]{KeyFlag.AUTHENTICATION}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeySpec.getBuilder((KeyType)KeyType.EDDSA_LEGACY((EdDSALegacyCurve)EdDSALegacyCurve._Ed25519), (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_COMMS}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeySpec.getBuilder((KeyType)KeyType.EDDSA_LEGACY((EdDSALegacyCurve)EdDSALegacyCurve._Ed25519), (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE}));
    }
}

