/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.info;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa_legacy.EdDSALegacyCurve;
import org.pgpainless.key.generation.type.xdh_legacy.XDHLegacySpec;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.util.Passphrase;

public class UserIdRevocationTest {
    @Test
    public void testRevocationWithoutRevocationAttributes() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = ((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA_LEGACY((EdDSALegacyCurve)EdDSALegacyCurve._Ed25519), (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA, KeyFlag.CERTIFY_OTHER}))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.XDH_LEGACY((XDHLegacySpec)XDHLegacySpec._X25519), (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_COMMS}))).addUserId((CharSequence)"primary@key.id").addUserId((CharSequence)"secondary@key.id").build();
        PGPSecretKeyRing revoked = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revokeUserId((CharSequence)"secondary@key.id", (SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)revoked);
        List userIds = info.getUserIds();
        Assertions.assertEquals(Arrays.asList("primary@key.id", "secondary@key.id"), (Object)userIds);
        Assertions.assertTrue((boolean)info.isUserIdValid((CharSequence)"primary@key.id"));
        Assertions.assertFalse((boolean)info.isUserIdValid((CharSequence)"sedondary@key.id"));
        Assertions.assertFalse((boolean)info.isUserIdValid((CharSequence)"tertiary@key.id"));
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertTrue((boolean)info.isUserIdValid((CharSequence)"secondary@key.id"));
        revoked = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revokeUserId((CharSequence)"secondary@key.id", (SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)revoked);
        userIds = info.getUserIds();
        Assertions.assertEquals(Arrays.asList("primary@key.id", "secondary@key.id"), (Object)userIds);
        Assertions.assertTrue((boolean)info.isUserIdValid((CharSequence)"primary@key.id"));
        Assertions.assertFalse((boolean)info.isUserIdValid((CharSequence)"sedondary@key.id"));
        Assertions.assertFalse((boolean)info.isUserIdValid((CharSequence)"tertiary@key.id"));
    }

    @Test
    public void testRevocationWithRevocationReason() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        PGPSecretKeyRing secretKeys = ((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA_LEGACY((EdDSALegacyCurve)EdDSALegacyCurve._Ed25519), (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA, KeyFlag.CERTIFY_OTHER}))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.XDH_LEGACY((XDHLegacySpec)XDHLegacySpec._X25519), (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_COMMS}))).addUserId((CharSequence)"primary@key.id").addUserId((CharSequence)"secondary@key.id").build();
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revokeUserId((CharSequence)"secondary@key.id", (SecretKeyRingProtector)new UnprotectedKeysProtector(), RevocationAttributes.createCertificateRevocation().withReason(RevocationAttributes.Reason.USER_ID_NO_LONGER_VALID).withDescription("I lost my mail password")).done();
        KeyRingInfo info = new KeyRingInfo((PGPKeyRing)secretKeys);
        PGPSignature signature = info.getUserIdRevocation((CharSequence)"secondary@key.id");
        Assertions.assertNotNull((Object)signature);
        RevocationReason reason = (RevocationReason)signature.getHashedSubPackets().getSubpacket(29);
        Assertions.assertNotNull((Object)reason);
        Assertions.assertEquals((Object)"I lost my mail password", (Object)reason.getRevocationDescription());
    }

    @Test
    public void unknownKeyThrowsIllegalArgumentException() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        PasswordBasedSecretKeyRingProtector protector = PasswordBasedSecretKeyRingProtector.forKey((PGPSecretKey)secretKeys.getSecretKey(), (Passphrase)TestKeys.CRYPTIE_PASSPHRASE);
        Assertions.assertThrows(NoSuchElementException.class, () -> UserIdRevocationTest.lambda$unknownKeyThrowsIllegalArgumentException$0(secretKeys, (SecretKeyRingProtector)protector));
    }

    @Test
    public void unknownUserIdThrowsNoSuchElementException() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        PasswordBasedSecretKeyRingProtector protector = PasswordBasedSecretKeyRingProtector.forKey((PGPSecretKey)secretKeys.getSecretKey(), (Passphrase)TestKeys.CRYPTIE_PASSPHRASE);
        Assertions.assertThrows(NoSuchElementException.class, () -> UserIdRevocationTest.lambda$unknownUserIdThrowsNoSuchElementException$1(secretKeys, (SecretKeyRingProtector)protector));
    }

    @Test
    public void invalidRevocationReasonThrowsIllegalArgumentException() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        PasswordBasedSecretKeyRingProtector protector = PasswordBasedSecretKeyRingProtector.forKey((PGPSecretKey)secretKeys.getSecretKey(), (Passphrase)TestKeys.CRYPTIE_PASSPHRASE);
        Assertions.assertThrows(IllegalArgumentException.class, () -> UserIdRevocationTest.lambda$invalidRevocationReasonThrowsIllegalArgumentException$2(secretKeys, (SecretKeyRingProtector)protector));
    }

    private static /* synthetic */ void lambda$invalidRevocationReasonThrowsIllegalArgumentException$2(PGPSecretKeyRing secretKeys, SecretKeyRingProtector protector) throws Throwable {
        PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revokeUserId((CharSequence)"cryptie@encrypted.key", protector, RevocationAttributes.createKeyRevocation().withReason(RevocationAttributes.Reason.KEY_RETIRED).withDescription("This is not a valid certification revocation reason."));
    }

    private static /* synthetic */ void lambda$unknownUserIdThrowsNoSuchElementException$1(PGPSecretKeyRing secretKeys, SecretKeyRingProtector protector) throws Throwable {
        PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revokeUserId((CharSequence)"invalid@user.id", protector);
    }

    private static /* synthetic */ void lambda$unknownKeyThrowsIllegalArgumentException$0(PGPSecretKeyRing secretKeys, SecretKeyRingProtector protector) throws Throwable {
        PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revokeSubKey(1L, protector);
    }
}

