/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.IOException;
import java.util.Date;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.JUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.util.DateUtil;

public class ChangeSubkeyExpirationTimeTest {
    @Test
    public void changeExpirationTimeOfSubkey() {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice");
        Date now = secretKeys.getPublicKey().getCreationTime();
        Date inAnHour = new Date(now.getTime() + 3600000L);
        PGPPublicKey encryptionKey = (PGPPublicKey)PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getEncryptionSubkeys(EncryptionPurpose.ANY).get(0);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDateOfSubkey(inAnHour, encryptionKey.getKeyID(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()).done();
        JUtils.assertDateEquals(inAnHour, PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getSubkeyExpirationDate(OpenPgpFingerprint.of((PGPPublicKey)encryptionKey)));
    }

    @Test
    public void changeExpirationTimeOfExpiredSubkey() throws IOException {
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing("-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: CA52 4D5D E3D8 9CD9 105B  BA45 3761 076B C6B5 3000\nComment: Alice <alice@pgpainless.org>\n\nlFgEZXHykRYJKwYBBAHaRw8BAQdATArrVxPEpuA/wcayAxRl/v1tIYJSe4MCA/fO\n84CFgpcAAP9uZkLjoBIQAjUTEiS8Wk3sui3u4mJ4WVQEpNhQSpq37g8gtBxBbGlj\nZSA8YWxpY2VAcGdwYWlubGVzcy5vcmc+iJUEExYKAEcFAmVx8pIJEDdhB2vGtTAA\nFiEEylJNXePYnNkQW7pFN2EHa8a1MAACngECmwEFFgIDAQAECwkIBwUVCgkICwWJ\nCWYBgAKZAQAAG3oA/0iJbwyjGOTa2RlgBKdmFjlBG5uwMGheKge/aZBbdUd8AQCB\n8NFWmyLlne4hDMM2g8RFf/W156wnyTH7jTQLx2sZDJxYBGVx8pIWCSsGAQQB2kcP\nAQEHQLQt6ns7yTxLvIWXqFCekh6QEvUumhHvCTjZPXa/UxCNAAEA+FHhZ1uik6PN\nPwli9Tp9QGddf3pwQw+OL/K7gpZO3sgQHYjVBBgWCgB9BQJlcfKSAp4BApsCBRYC\nAwEABAsJCAcFFQoJCAtfIAQZFgoABgUCZXHykgAKCRCRKlHdDPaYKjyZAQD10Km4\nQs37yF9bntS+z9Va7AMUuBlzYF5H/nXCRuqQTAEA60q++7Xwj94yLfoAfxH0V6Wd\nL2rDJCDZ3FFMlycToQMACgkQN2EHa8a1MADmDgD9EGzH6pPYRW5vWQGXNsr7PMWK\nLlBnevc0DaVWEHTu9tcA/iezQ9R+A90qcE1+HeNIJbSB89yIoJje2vePRV/JakAI\nnF0EZXHykhIKKwYBBAGXVQEFAQEHQOiLc02OQJD9qdpsyR6bJ52Cu8rUMlEJOELz\n1858OoQyAwEIBwAA/3YkHGmnVaQvUpSwlCInOvHvjLNLH9b9Lh/OxiuSoMgIEASI\ndQQYFgoAHQUCZXHykgKeAQKbDAUWAgMBAAQLCQgHBRUKCQgLAAoJEDdhB2vGtTAA\n1nkBAPAUcHxI1O+fE/QzuLANLHDeWc3Mc09KKnWoTkt/kk5VAQCIPlKQAcmmKdYE\nTiz8woSKLQKswKr/jVMqnUiGPsU/DoiSBBgWCgBECRA3YQdrxrUwABYhBMpSTV3j\n2JzZEFu6RTdhB2vGtTAABYJlcfL6Ap4BApsMBRYCAwEABAsJCAcFFQoJCAsFiQAA\nAGgAAMNmAQDN/TML2zdgBNkfh7TIqbI4Flx54Yi7qEjSXg0Z+tszHgD/e1Bf+xEs\nBC9ewVsyQsnj3B0FliGYaPiQeoY/FGBmYQs=\n=5Ur6\n-----END PGP PRIVATE KEY BLOCK-----");
        Assertions.assertNotNull((Object)secretKeys);
        OpenPgpV4Fingerprint encryptionSubkey = new OpenPgpV4Fingerprint("2E541354A23C9943375EC27A3EF133ED8720D636");
        JUtils.assertDateEquals(DateUtil.parseUTCDate((String)"2023-12-07 16:29:46 UTC"), PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getSubkeyExpirationDate((OpenPgpFingerprint)encryptionSubkey));
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDateOfSubkey(null, encryptionSubkey.getKeyId(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()).done();
        Assertions.assertNull((Object)PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getSubkeyExpirationDate((OpenPgpFingerprint)encryptionSubkey));
    }
}

