/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.util.Passphrase;

public class PassphraseProtectedKeyTest {
    private final PasswordBasedSecretKeyRingProtector protector = new PasswordBasedSecretKeyRingProtector(KeyRingProtectionSettings.secureDefaultSettings(), new SecretKeyPassphraseProvider(){

        @Nullable
        public Passphrase getPassphraseFor(Long keyId) {
            if (keyId == -821156605394703576L) {
                return new Passphrase("password123".toCharArray());
            }
            return null;
        }

        public boolean hasPassphrase(Long keyId) {
            return keyId == -821156605394703576L;
        }
    });

    @Test
    public void testReturnsNonNullDecryptorEncryptorForPassword() throws PGPException {
        Assertions.assertNotNull((Object)this.protector.getEncryptor(-821156605394703576L));
        Assertions.assertNotNull((Object)this.protector.getDecryptor(-821156605394703576L));
    }

    @Test
    public void testReturnsNullDecryptorEncryptorForNoPassword() throws PGPException {
        Assertions.assertNull((Object)this.protector.getEncryptor(-5425419407118114754L));
        Assertions.assertNull((Object)this.protector.getDecryptor(-5425419407118114754L));
    }

    @Test
    public void testReturnsNonNullDecryptorForSubkeys() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"alice", "passphrase");
        PasswordBasedSecretKeyRingProtector protector = PasswordBasedSecretKeyRingProtector.forKey((PGPKeyRing)secretKeys, (Passphrase)Passphrase.fromPassword((CharSequence)"passphrase"));
        Iterator it = secretKeys.getPublicKeys();
        while (it.hasNext()) {
            PGPPublicKey subkey = (PGPPublicKey)it.next();
            Assertions.assertNotNull((Object)protector.getEncryptor(subkey.getKeyID()));
            Assertions.assertNotNull((Object)protector.getDecryptor(subkey.getKeyID()));
        }
    }
}

