/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.symmetric_encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MissingKeyPassphraseStrategy;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.exception.MissingDecryptionMethodException;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.key.protection.passphrase_provider.SolitaryPassphraseProvider;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.TestAllImplementations;

public class SymmetricEncryptionTest {
    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void encryptWithKeyAndPassphrase_DecryptWithKey() throws IOException, PGPException {
        byte[] plaintext = "This is a secret message".getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream plaintextIn = new ByteArrayInputStream(plaintext);
        PGPPublicKeyRing encryptionKey = TestKeys.getCryptiePublicKeyRing();
        Passphrase encryptionPassphrase = Passphrase.fromPassword((CharSequence)"greenBeans");
        ByteArrayOutputStream ciphertextOut = new ByteArrayOutputStream();
        EncryptionStream encryptor = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)ciphertextOut).withOptions(ProducerOptions.encrypt((EncryptionOptions)EncryptionOptions.encryptCommunications().addMessagePassphrase(encryptionPassphrase).addRecipient(encryptionKey)));
        Streams.pipeAll((InputStream)plaintextIn, (OutputStream)encryptor);
        encryptor.close();
        byte[] ciphertext = ciphertextOut.toByteArray();
        DecryptionStream decryptor = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(ciphertext)).withOptions(new ConsumerOptions().addMessagePassphrase(encryptionPassphrase));
        ByteArrayOutputStream decrypted = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptor, (OutputStream)decrypted);
        decryptor.close();
        Assertions.assertArrayEquals((byte[])plaintext, (byte[])decrypted.toByteArray());
        PGPSecretKeyRingCollection decryptionKeys = TestKeys.getCryptieSecretKeyRingCollection();
        PasswordBasedSecretKeyRingProtector protector = new PasswordBasedSecretKeyRingProtector(KeyRingProtectionSettings.secureDefaultSettings(), (SecretKeyPassphraseProvider)new SolitaryPassphraseProvider(Passphrase.fromPassword((CharSequence)"password123")));
        decryptor = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(ciphertext)).withOptions(new ConsumerOptions().addDecryptionKeys(decryptionKeys, (SecretKeyRingProtector)protector));
        decrypted = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptor, (OutputStream)decrypted);
        decryptor.close();
        Assertions.assertArrayEquals((byte[])plaintext, (byte[])decrypted.toByteArray());
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void testMismatchPassphraseFails() throws IOException, PGPException {
        byte[] bytes = new byte[5000];
        new Random().nextBytes(bytes);
        ByteArrayOutputStream ciphertextOut = new ByteArrayOutputStream();
        EncryptionStream encryptor = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)ciphertextOut).withOptions(ProducerOptions.encrypt((EncryptionOptions)EncryptionOptions.encryptCommunications().addMessagePassphrase(Passphrase.fromPassword((CharSequence)"mellon"))));
        Streams.pipeAll((InputStream)new ByteArrayInputStream(bytes), (OutputStream)encryptor);
        encryptor.close();
        Assertions.assertThrows(MissingDecryptionMethodException.class, () -> PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(ciphertextOut.toByteArray())).withOptions(new ConsumerOptions().setMissingKeyPassphraseStrategy(MissingKeyPassphraseStrategy.THROW_EXCEPTION).addMessagePassphrase(Passphrase.fromPassword((CharSequence)"meldir"))));
    }
}

