/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.bouncycastle.extensions;

import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.generation.type.eddsa_legacy.EdDSALegacyCurve;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"openPgpFingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "getOpenPgpFingerprint", "(Lorg/bouncycastle/openpgp/PGPPublicKey;)Lorg/pgpainless/key/OpenPgpFingerprint;", "publicKeyAlgorithm", "Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "getPublicKeyAlgorithm", "(Lorg/bouncycastle/openpgp/PGPPublicKey;)Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "getCurveName", "", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nPGPPublicKeyExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PGPPublicKeyExtensions.kt\norg/pgpainless/bouncycastle/extensions/PGPPublicKeyExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public final class PGPPublicKeyExtensionsKt {
    @NotNull
    public static final String getCurveName(@NotNull PGPPublicKey $this$getCurveName) {
        ECPublicBCPGKey eCPublicBCPGKey;
        Intrinsics.checkNotNullParameter((Object)$this$getCurveName, (String)"<this>");
        PublicKeyAlgorithm it = PublicKeyAlgorithm.Companion.requireFromId($this$getCurveName.getAlgorithm());
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
            case 1: {
                BCPGKey bCPGKey = $this$getCurveName.getPublicKeyPacket().getKey();
                Intrinsics.checkNotNull((Object)bCPGKey, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.ECDSAPublicBCPGKey");
                eCPublicBCPGKey = (ECPublicBCPGKey)((ECDSAPublicBCPGKey)bCPGKey);
                break;
            }
            case 2: {
                BCPGKey bCPGKey = $this$getCurveName.getPublicKeyPacket().getKey();
                Intrinsics.checkNotNull((Object)bCPGKey, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.ECDHPublicBCPGKey");
                eCPublicBCPGKey = (ECPublicBCPGKey)((ECDHPublicBCPGKey)bCPGKey);
                break;
            }
            case 3: {
                BCPGKey bCPGKey = $this$getCurveName.getPublicKeyPacket().getKey();
                Intrinsics.checkNotNull((Object)bCPGKey, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.EdDSAPublicBCPGKey");
                eCPublicBCPGKey = (ECPublicBCPGKey)((EdDSAPublicBCPGKey)bCPGKey);
                break;
            }
            default: {
                throw new IllegalArgumentException("No an elliptic curve public key (" + (Object)((Object)it) + ").");
            }
        }
        it = eCPublicBCPGKey;
        boolean bl2 = false;
        if (Intrinsics.areEqual((Object)it.getCurveOID(), (Object)GNUObjectIdentifiers.Ed25519)) {
            return EdDSALegacyCurve._Ed25519.getCurveName();
        }
        it = it.getCurveOID();
        boolean bl3 = false;
        it = TuplesKt.to((Object)((Object)it), (Object)ECUtil.getCurveName((ASN1ObjectIdentifier)it));
        boolean bl4 = false;
        if (it.getSecond() != null) {
            Object object = it.getSecond();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.second");
            return (String)object;
        }
        throw new IllegalArgumentException("Unknown curve: " + it.getFirst());
    }

    @NotNull
    public static final PublicKeyAlgorithm getPublicKeyAlgorithm(@NotNull PGPPublicKey $this$publicKeyAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)$this$publicKeyAlgorithm, (String)"<this>");
        return PublicKeyAlgorithm.Companion.requireFromId($this$publicKeyAlgorithm.getAlgorithm());
    }

    @NotNull
    public static final OpenPgpFingerprint getOpenPgpFingerprint(@NotNull PGPPublicKey $this$openPgpFingerprint) {
        Intrinsics.checkNotNullParameter((Object)$this$openPgpFingerprint, (String)"<this>");
        return OpenPgpFingerprint.Companion.of($this$openPgpFingerprint);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PublicKeyAlgorithm.values().length];
            try {
                nArray[PublicKeyAlgorithm.ECDSA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PublicKeyAlgorithm.ECDH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PublicKeyAlgorithm.EDDSA_LEGACY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

