/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionBuilderInterface;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMessageInputStream;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/pgpainless/decryption_verification/DecryptionBuilder;", "Lorg/pgpainless/decryption_verification/DecryptionBuilderInterface;", "()V", "onInputStream", "Lorg/pgpainless/decryption_verification/DecryptionBuilderInterface$DecryptWith;", "inputStream", "Ljava/io/InputStream;", "DecryptWithImpl", "pgpainless-core"})
public final class DecryptionBuilder
implements DecryptionBuilderInterface {
    @Override
    @NotNull
    public DecryptionBuilderInterface.DecryptWith onInputStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return new DecryptWithImpl(inputStream);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/pgpainless/decryption_verification/DecryptionBuilder$DecryptWithImpl;", "Lorg/pgpainless/decryption_verification/DecryptionBuilderInterface$DecryptWith;", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "getInputStream", "()Ljava/io/InputStream;", "withOptions", "Lorg/pgpainless/decryption_verification/DecryptionStream;", "consumerOptions", "Lorg/pgpainless/decryption_verification/ConsumerOptions;", "pgpainless-core"})
    public static final class DecryptWithImpl
    implements DecryptionBuilderInterface.DecryptWith {
        @NotNull
        private final InputStream inputStream;

        public DecryptWithImpl(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            this.inputStream = inputStream;
        }

        @NotNull
        public final InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        @NotNull
        public DecryptionStream withOptions(@NotNull ConsumerOptions consumerOptions) {
            Intrinsics.checkNotNullParameter((Object)consumerOptions, (String)"consumerOptions");
            return OpenPgpMessageInputStream.Companion.create(this.inputStream, consumerOptions);
        }
    }
}

