/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import openpgp.LongExtensionsKt;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.util.Strings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.bouncycastle.extensions.PGPSecretKeyRingExtensionsKt;
import org.pgpainless.exception.MissingPassphraseException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.fixes.S2KUsageFix;
import org.pgpainless.key.util.KeyRingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/key/util/KeyRingUtils;", "", "()V", "Companion", "pgpainless-core"})
public final class KeyRingUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOGGER;

    @JvmStatic
    @Deprecated(message="Deprecated in favor of PGPSecretKeyRing extension function.", replaceWith=@ReplaceWith(expression="secretKeys.requireSecretKey(keyId)", imports={}))
    @NotNull
    public static final PGPSecretKey requirePrimarySecretKeyFrom(@NotNull PGPSecretKeyRing secretKeys) {
        return Companion.requirePrimarySecretKeyFrom(secretKeys);
    }

    @JvmStatic
    @Nullable
    public static final PGPSecretKey getPrimarySecretKeyFrom(@NotNull PGPSecretKeyRing secretKeys) {
        return Companion.getPrimarySecretKeyFrom(secretKeys);
    }

    @JvmStatic
    @NotNull
    public static final PGPPublicKey requirePrimaryPublicKeyFrom(@NotNull PGPKeyRing keyRing) {
        return Companion.requirePrimaryPublicKeyFrom(keyRing);
    }

    @JvmStatic
    @Nullable
    public static final PGPPublicKey getPrimaryPublicKey(@NotNull PGPKeyRing keyRing) {
        return Companion.getPrimaryPublicKey(keyRing);
    }

    @JvmStatic
    @NotNull
    public static final PGPPublicKey requirePublicKeyFrom(@NotNull PGPKeyRing keyRing, long subKeyId) {
        return Companion.requirePublicKeyFrom(keyRing, subKeyId);
    }

    @JvmStatic
    @NotNull
    public static final PGPSecretKey requireSecretKeyFrom(@NotNull PGPSecretKeyRing keyRing, long subKeyId) {
        return Companion.requireSecretKeyFrom(keyRing, subKeyId);
    }

    @JvmStatic
    @NotNull
    public static final PGPPublicKeyRing publicKeys(@NotNull PGPKeyRing keys) {
        return Companion.publicKeys(keys);
    }

    @JvmStatic
    @Deprecated(message="Deprecated in favor of PGPSecretKeyRing extension method.", replaceWith=@ReplaceWith(expression="secretKeys.certificate", imports={"org.bouncycastle.extensions.certificate"}))
    @NotNull
    public static final PGPPublicKeyRing publicKeyRingFrom(@NotNull PGPSecretKeyRing secretKeys) {
        return Companion.publicKeyRingFrom(secretKeys);
    }

    @JvmStatic
    @NotNull
    public static final PGPPublicKeyRingCollection publicKeyRingCollectionFrom(@NotNull PGPSecretKeyRingCollection secretKeyRings) {
        return Companion.publicKeyRingCollectionFrom(secretKeyRings);
    }

    @JvmStatic
    @NotNull
    public static final PGPPublicKeyRingCollection keyRingsToKeyRingCollection(PGPPublicKeyRing ... certificates) {
        return Companion.keyRingsToKeyRingCollection(certificates);
    }

    @JvmStatic
    @NotNull
    public static final PGPSecretKeyRingCollection keyRingsToKeyRingCollection(PGPSecretKeyRing ... secretKeys) {
        return Companion.keyRingsToKeyRingCollection(secretKeys);
    }

    @JvmStatic
    public static final boolean keyRingContainsKeyWithId(@NotNull PGPPublicKeyRing certificate, long keyId) {
        return Companion.keyRingContainsKeyWithId(certificate, keyId);
    }

    @JvmStatic
    @NotNull
    public static final <T extends PGPKeyRing> T injectCertification(@NotNull T keyRing, @NotNull PGPSignature certification) {
        return Companion.injectCertification(keyRing, certification);
    }

    @JvmStatic
    @NotNull
    public static final <T extends PGPKeyRing> T injectCertification(@NotNull T keyRing, @NotNull PGPPublicKey certifiedKey, @NotNull PGPSignature certification) {
        return Companion.injectCertification(keyRing, certifiedKey, certification);
    }

    @JvmStatic
    @NotNull
    public static final <T extends PGPKeyRing> T injectCertification(@NotNull T keyRing, @NotNull CharSequence userId, @NotNull PGPSignature certification) {
        return Companion.injectCertification(keyRing, userId, certification);
    }

    @JvmStatic
    @NotNull
    public static final <T extends PGPKeyRing> T injectCertification(@NotNull T keyRing, @NotNull PGPUserAttributeSubpacketVector userAttributes, @NotNull PGPSignature certification) {
        return Companion.injectCertification(keyRing, userAttributes, certification);
    }

    @JvmStatic
    @NotNull
    public static final <T extends PGPKeyRing> T keysPlusPublicKey(@NotNull T keyRing, @NotNull PGPPublicKey publicKey) {
        return Companion.keysPlusPublicKey(keyRing, publicKey);
    }

    @JvmStatic
    private static final Pair<PGPSecretKeyRing, PGPPublicKeyRing> secretAndPublicKeys(PGPKeyRing keyRing) {
        return KeyRingUtils.Companion.secretAndPublicKeys(keyRing);
    }

    @JvmStatic
    @NotNull
    public static final PGPSecretKeyRing keysPlusSecretKey(@NotNull PGPSecretKeyRing secretKeys, @NotNull PGPSecretKey secretKey) {
        return Companion.keysPlusSecretKey(secretKeys, secretKey);
    }

    @JvmStatic
    @NotNull
    public static final PGPSecretKey secretKeyPlusSignature(@NotNull PGPSecretKey secretKey, @NotNull PGPSignature signature) {
        return Companion.secretKeyPlusSignature(secretKey, signature);
    }

    @JvmStatic
    @NotNull
    public static final PGPSecretKeyRing stripSecretKey(@NotNull PGPSecretKeyRing secretKeys, long keyId) {
        return Companion.stripSecretKey(secretKeys, keyId);
    }

    @JvmStatic
    @NotNull
    public static final PGPPublicKey getStrippedDownPublicKey(@NotNull PGPPublicKey bloatedKey) {
        return Companion.getStrippedDownPublicKey(bloatedKey);
    }

    @JvmStatic
    @NotNull
    public static final List<String> getUserIdsIgnoringInvalidUTF8(@NotNull PGPPublicKey key) {
        return Companion.getUserIdsIgnoringInvalidUTF8(key);
    }

    @JvmStatic
    @NotNull
    public static final PGPSecretKeyRing changePassphrase(@Nullable Long keyId, @NotNull PGPSecretKeyRing secretKeys, @NotNull SecretKeyRingProtector oldProtector, @NotNull SecretKeyRingProtector newProtector) throws MissingPassphraseException, PGPException {
        return Companion.changePassphrase(keyId, secretKeys, oldProtector, newProtector);
    }

    @JvmStatic
    @NotNull
    public static final PGPSecretKey reencryptPrivateKey(@NotNull PGPSecretKey secretKey, @NotNull SecretKeyRingProtector oldProtector, @NotNull SecretKeyRingProtector newProtector) {
        return Companion.reencryptPrivateKey(secretKey, oldProtector, newProtector);
    }

    @JvmStatic
    @NotNull
    public static final PGPSecretKeyRing s2kUsageFixIfNecessary(@NotNull PGPSecretKeyRing secretKeys, @NotNull SecretKeyRingProtector protector) {
        return Companion.s2kUsageFixIfNecessary(secretKeys, protector);
    }

    static {
        Logger logger = LoggerFactory.getLogger(KeyRingUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(KeyRingUtils::class.java)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u0007H\u0007J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0007J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u0010H\u0007J/\u0010\u001b\u001a\u0002H\u001c\"\b\b\u0000\u0010\u001c*\u00020\u00122\u0006\u0010\u0011\u001a\u0002H\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0007\u00a2\u0006\u0002\u0010!J/\u0010\u001b\u001a\u0002H\u001c\"\b\b\u0000\u0010\u001c*\u00020\u00122\u0006\u0010\u0011\u001a\u0002H\u001c2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 H\u0007\u00a2\u0006\u0002\u0010#J'\u0010\u001b\u001a\u0002H\u001c\"\b\b\u0000\u0010\u001c*\u00020\u00122\u0006\u0010\u0011\u001a\u0002H\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0007\u00a2\u0006\u0002\u0010$J/\u0010\u001b\u001a\u0002H\u001c\"\b\b\u0000\u0010\u001c*\u00020\u00122\u0006\u0010\u0011\u001a\u0002H\u001c2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020 H\u0007\u00a2\u0006\u0002\u0010'J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010\b\u001a\u00020\tH\u0007J!\u0010,\u001a\u00020-2\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0/\"\u00020+H\u0007\u00a2\u0006\u0002\u00100J!\u0010,\u001a\u0002012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070/\"\u00020\u0007H\u0007\u00a2\u0006\u0002\u00102J'\u00103\u001a\u0002H\u001c\"\b\b\u0000\u0010\u001c*\u00020\u00122\u0006\u0010\u0011\u001a\u0002H\u001c2\u0006\u00104\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u00105J\u0018\u00106\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u0014H\u0007J\u0010\u00108\u001a\u00020-2\u0006\u00109\u001a\u000201H\u0007J\u0010\u0010:\u001a\u00020+2\u0006\u0010\n\u001a\u00020\u0007H\u0007J\u0010\u0010;\u001a\u00020+2\u0006\u0010<\u001a\u00020\u0012H\u0007J \u0010=\u001a\u00020\u00142\u0006\u00107\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0007J\u0010\u0010>\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010?\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0007H\u0007J\u0018\u0010@\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010A\u001a\u00020\tH\u0007J\u0018\u0010B\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010A\u001a\u00020\tH\u0007J\u0018\u0010C\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010D\u001a\u00020\fH\u0007J\u001e\u0010E\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020+0F2\u0006\u0010\u0011\u001a\u00020\u0012H\u0003J\u0018\u0010G\u001a\u00020\u00142\u0006\u00107\u001a\u00020\u00142\u0006\u0010H\u001a\u00020 H\u0007J\u0018\u0010I\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006J"}, d2={"Lorg/pgpainless/key/util/KeyRingUtils$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER$annotations", "changePassphrase", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "keyId", "", "secretKeys", "oldProtector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "newProtector", "(Ljava/lang/Long;Lorg/bouncycastle/openpgp/PGPSecretKeyRing;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/pgpainless/key/protection/SecretKeyRingProtector;)Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "getPrimaryPublicKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "keyRing", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "getPrimarySecretKeyFrom", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "getStrippedDownPublicKey", "bloatedKey", "getUserIdsIgnoringInvalidUTF8", "", "", "key", "injectCertification", "T", "userId", "", "certification", "Lorg/bouncycastle/openpgp/PGPSignature;", "(Lorg/bouncycastle/openpgp/PGPKeyRing;Ljava/lang/CharSequence;Lorg/bouncycastle/openpgp/PGPSignature;)Lorg/bouncycastle/openpgp/PGPKeyRing;", "certifiedKey", "(Lorg/bouncycastle/openpgp/PGPKeyRing;Lorg/bouncycastle/openpgp/PGPPublicKey;Lorg/bouncycastle/openpgp/PGPSignature;)Lorg/bouncycastle/openpgp/PGPKeyRing;", "(Lorg/bouncycastle/openpgp/PGPKeyRing;Lorg/bouncycastle/openpgp/PGPSignature;)Lorg/bouncycastle/openpgp/PGPKeyRing;", "userAttributes", "Lorg/bouncycastle/openpgp/PGPUserAttributeSubpacketVector;", "(Lorg/bouncycastle/openpgp/PGPKeyRing;Lorg/bouncycastle/openpgp/PGPUserAttributeSubpacketVector;Lorg/bouncycastle/openpgp/PGPSignature;)Lorg/bouncycastle/openpgp/PGPKeyRing;", "keyRingContainsKeyWithId", "", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "keyRingsToKeyRingCollection", "Lorg/bouncycastle/openpgp/PGPPublicKeyRingCollection;", "certificates", "", "([Lorg/bouncycastle/openpgp/PGPPublicKeyRing;)Lorg/bouncycastle/openpgp/PGPPublicKeyRingCollection;", "Lorg/bouncycastle/openpgp/PGPSecretKeyRingCollection;", "([Lorg/bouncycastle/openpgp/PGPSecretKeyRing;)Lorg/bouncycastle/openpgp/PGPSecretKeyRingCollection;", "keysPlusPublicKey", "publicKey", "(Lorg/bouncycastle/openpgp/PGPKeyRing;Lorg/bouncycastle/openpgp/PGPPublicKey;)Lorg/bouncycastle/openpgp/PGPKeyRing;", "keysPlusSecretKey", "secretKey", "publicKeyRingCollectionFrom", "secretKeyRings", "publicKeyRingFrom", "publicKeys", "keys", "reencryptPrivateKey", "requirePrimaryPublicKeyFrom", "requirePrimarySecretKeyFrom", "requirePublicKeyFrom", "subKeyId", "requireSecretKeyFrom", "s2kUsageFixIfNecessary", "protector", "secretAndPublicKeys", "Lkotlin/Pair;", "secretKeyPlusSignature", "signature", "stripSecretKey", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nKeyRingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyRingUtils.kt\norg/pgpainless/key/util/KeyRingUtils$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,529:1\n1855#2,2:530\n32#3,2:532\n32#3,2:534\n1#4:536\n1229#5,2:537\n*S KotlinDebug\n*F\n+ 1 KeyRingUtils.kt\norg/pgpainless/key/util/KeyRingUtils$Companion\n*L\n427#1:530,2\n436#1:532,2\n458#1:534,2\n520#1:537,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLOGGER$annotations() {
        }

        @JvmStatic
        @Deprecated(message="Deprecated in favor of PGPSecretKeyRing extension function.", replaceWith=@ReplaceWith(expression="secretKeys.requireSecretKey(keyId)", imports={}))
        @NotNull
        public final PGPSecretKey requirePrimarySecretKeyFrom(@NotNull PGPSecretKeyRing secretKeys) {
            Intrinsics.checkNotNullParameter((Object)secretKeys, (String)"secretKeys");
            return PGPSecretKeyRingExtensionsKt.requireSecretKey(secretKeys, secretKeys.getPublicKey().getKeyID());
        }

        @JvmStatic
        @Nullable
        public final PGPSecretKey getPrimarySecretKeyFrom(@NotNull PGPSecretKeyRing secretKeys) {
            Intrinsics.checkNotNullParameter((Object)secretKeys, (String)"secretKeys");
            PGPSecretKey it = secretKeys.getSecretKey();
            boolean bl = false;
            return it.isMasterKey() ? it : null;
        }

        @JvmStatic
        @NotNull
        public final PGPPublicKey requirePrimaryPublicKeyFrom(@NotNull PGPKeyRing keyRing) {
            Intrinsics.checkNotNullParameter((Object)keyRing, (String)"keyRing");
            PGPPublicKey pGPPublicKey = this.getPrimaryPublicKey(keyRing);
            if (pGPPublicKey == null) {
                throw new NoSuchElementException("Provided PGPKeyRing has no primary public key.");
            }
            return pGPPublicKey;
        }

        @JvmStatic
        @Nullable
        public final PGPPublicKey getPrimaryPublicKey(@NotNull PGPKeyRing keyRing) {
            Intrinsics.checkNotNullParameter((Object)keyRing, (String)"keyRing");
            PGPPublicKey it = keyRing.getPublicKey();
            boolean bl = false;
            return it.isMasterKey() ? it : null;
        }

        @JvmStatic
        @NotNull
        public final PGPPublicKey requirePublicKeyFrom(@NotNull PGPKeyRing keyRing, long subKeyId) {
            Intrinsics.checkNotNullParameter((Object)keyRing, (String)"keyRing");
            PGPPublicKey pGPPublicKey = keyRing.getPublicKey(subKeyId);
            if (pGPPublicKey == null) {
                throw new NoSuchElementException("KeyRing does not contain public key with keyId " + LongExtensionsKt.openPgpKeyId(subKeyId) + '.');
            }
            return pGPPublicKey;
        }

        @JvmStatic
        @NotNull
        public final PGPSecretKey requireSecretKeyFrom(@NotNull PGPSecretKeyRing keyRing, long subKeyId) {
            Intrinsics.checkNotNullParameter((Object)keyRing, (String)"keyRing");
            PGPSecretKey pGPSecretKey = keyRing.getSecretKey(subKeyId);
            if (pGPSecretKey == null) {
                throw new NoSuchElementException("KeyRing does not contain secret key with keyID " + LongExtensionsKt.openPgpKeyId(subKeyId) + '.');
            }
            return pGPSecretKey;
        }

        @JvmStatic
        @NotNull
        public final PGPPublicKeyRing publicKeys(@NotNull PGPKeyRing keys) {
            PGPPublicKeyRing pGPPublicKeyRing;
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            PGPKeyRing pGPKeyRing = keys;
            if (pGPKeyRing instanceof PGPPublicKeyRing) {
                pGPPublicKeyRing = (PGPPublicKeyRing)keys;
            } else if (pGPKeyRing instanceof PGPSecretKeyRing) {
                pGPPublicKeyRing = PGPSecretKeyRingExtensionsKt.getCertificate((PGPSecretKeyRing)keys);
            } else {
                throw new IllegalArgumentException("Unknown keys class: " + keys.getClass().getName());
            }
            return pGPPublicKeyRing;
        }

        @JvmStatic
        @Deprecated(message="Deprecated in favor of PGPSecretKeyRing extension method.", replaceWith=@ReplaceWith(expression="secretKeys.certificate", imports={"org.bouncycastle.extensions.certificate"}))
        @NotNull
        public final PGPPublicKeyRing publicKeyRingFrom(@NotNull PGPSecretKeyRing secretKeys) {
            Intrinsics.checkNotNullParameter((Object)secretKeys, (String)"secretKeys");
            return PGPSecretKeyRingExtensionsKt.getCertificate(secretKeys);
        }

        @JvmStatic
        @NotNull
        public final PGPPublicKeyRingCollection publicKeyRingCollectionFrom(@NotNull PGPSecretKeyRingCollection secretKeyRings) {
            Intrinsics.checkNotNullParameter((Object)secretKeyRings, (String)"secretKeyRings");
            Iterator iterator = secretKeyRings.getKeyRings();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"secretKeyRings.keyRings");
            return new PGPPublicKeyRingCollection((Collection)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)publicKeyRingCollectionFrom.1.INSTANCE)));
        }

        @JvmStatic
        @NotNull
        public final PGPPublicKeyRingCollection keyRingsToKeyRingCollection(PGPPublicKeyRing ... certificates) {
            Intrinsics.checkNotNullParameter((Object)certificates, (String)"certificates");
            return new PGPPublicKeyRingCollection((Collection)ArraysKt.toList((Object[])certificates));
        }

        @JvmStatic
        @NotNull
        public final PGPSecretKeyRingCollection keyRingsToKeyRingCollection(PGPSecretKeyRing ... secretKeys) {
            Intrinsics.checkNotNullParameter((Object)secretKeys, (String)"secretKeys");
            return new PGPSecretKeyRingCollection((Collection)ArraysKt.toList((Object[])secretKeys));
        }

        @JvmStatic
        public final boolean keyRingContainsKeyWithId(@NotNull PGPPublicKeyRing certificate, long keyId) {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            return certificate.getPublicKey(keyId) != null;
        }

        @JvmStatic
        @NotNull
        public final <T extends PGPKeyRing> T injectCertification(@NotNull T keyRing, @NotNull PGPSignature certification) {
            Intrinsics.checkNotNullParameter(keyRing, (String)"keyRing");
            Intrinsics.checkNotNullParameter((Object)certification, (String)"certification");
            PGPPublicKey pGPPublicKey = keyRing.getPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"keyRing.publicKey");
            return this.injectCertification(keyRing, pGPPublicKey, certification);
        }

        @JvmStatic
        @NotNull
        public final <T extends PGPKeyRing> T injectCertification(@NotNull T keyRing, @NotNull PGPPublicKey certifiedKey, @NotNull PGPSignature certification) {
            PGPKeyRing pGPKeyRing;
            Intrinsics.checkNotNullParameter(keyRing, (String)"keyRing");
            Intrinsics.checkNotNullParameter((Object)certifiedKey, (String)"certifiedKey");
            Intrinsics.checkNotNullParameter((Object)certification, (String)"certification");
            Pair<PGPSecretKeyRing, PGPPublicKeyRing> secretAndPublicKeys = this.secretAndPublicKeys(keyRing);
            PGPSecretKeyRing secretKeys = (PGPSecretKeyRing)secretAndPublicKeys.getFirst();
            PGPPublicKeyRing certificate = (PGPPublicKeyRing)secretAndPublicKeys.getSecond();
            if (!this.keyRingContainsKeyWithId(certificate, certifiedKey.getKeyID())) {
                throw new NoSuchElementException("Cannot find public key with id " + LongExtensionsKt.openPgpKeyId(certifiedKey.getKeyID()) + " in the provided key ring.");
            }
            Iterator iterator = certificate.getPublicKeys();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"certificate.publicKeys");
            certificate = new PGPPublicKeyRing(SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)((Function1)new Function1<PGPPublicKey, PGPPublicKey>(certifiedKey, certification){
                final /* synthetic */ PGPPublicKey $certifiedKey;
                final /* synthetic */ PGPSignature $certification;
                {
                    this.$certifiedKey = $certifiedKey;
                    this.$certification = $certification;
                    super(1);
                }

                public final PGPPublicKey invoke(PGPPublicKey it) {
                    return it.getKeyID() == this.$certifiedKey.getKeyID() ? PGPPublicKey.addCertification((PGPPublicKey)it, (PGPSignature)this.$certification) : it;
                }
            }))));
            if (secretKeys == null) {
                pGPKeyRing = (PGPKeyRing)certificate;
            } else {
                PGPSecretKeyRing pGPSecretKeyRing = PGPSecretKeyRing.replacePublicKeys((PGPSecretKeyRing)secretKeys, (PGPPublicKeyRing)certificate);
                Intrinsics.checkNotNull((Object)pGPSecretKeyRing, (String)"null cannot be cast to non-null type T of org.pgpainless.key.util.KeyRingUtils.Companion.injectCertification");
                pGPKeyRing = (PGPKeyRing)pGPSecretKeyRing;
            }
            return (T)pGPKeyRing;
        }

        @JvmStatic
        @NotNull
        public final <T extends PGPKeyRing> T injectCertification(@NotNull T keyRing, @NotNull CharSequence userId, @NotNull PGPSignature certification) {
            PGPKeyRing pGPKeyRing;
            Intrinsics.checkNotNullParameter(keyRing, (String)"keyRing");
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)certification, (String)"certification");
            Pair<PGPSecretKeyRing, PGPPublicKeyRing> secretAndPublicKeys = this.secretAndPublicKeys(keyRing);
            PGPSecretKeyRing secretKeys = (PGPSecretKeyRing)secretAndPublicKeys.getFirst();
            PGPPublicKeyRing certificate = (PGPPublicKeyRing)secretAndPublicKeys.getSecond();
            PGPPublicKey pGPPublicKey = PGPPublicKey.addCertification((PGPPublicKey)this.requirePrimaryPublicKeyFrom((PGPKeyRing)certificate), (String)((Object)userId).toString(), (PGPSignature)certification);
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"addCertification(\n      \u2026           certification)");
            Collection collection = CollectionsKt.listOf((Object)pGPPublicKey);
            Iterator iterator = certificate.getPublicKeys();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"certificate.publicKeys");
            certificate = new PGPPublicKeyRing(CollectionsKt.plus((Collection)collection, (Sequence)SequencesKt.drop((Sequence)SequencesKt.asSequence((Iterator)iterator), (int)1)));
            if (secretKeys == null) {
                pGPKeyRing = (PGPKeyRing)certificate;
            } else {
                PGPSecretKeyRing pGPSecretKeyRing = PGPSecretKeyRing.replacePublicKeys((PGPSecretKeyRing)secretKeys, (PGPPublicKeyRing)certificate);
                Intrinsics.checkNotNull((Object)pGPSecretKeyRing, (String)"null cannot be cast to non-null type T of org.pgpainless.key.util.KeyRingUtils.Companion.injectCertification");
                pGPKeyRing = (PGPKeyRing)pGPSecretKeyRing;
            }
            return (T)pGPKeyRing;
        }

        @JvmStatic
        @NotNull
        public final <T extends PGPKeyRing> T injectCertification(@NotNull T keyRing, @NotNull PGPUserAttributeSubpacketVector userAttributes, @NotNull PGPSignature certification) {
            PGPKeyRing pGPKeyRing;
            Intrinsics.checkNotNullParameter(keyRing, (String)"keyRing");
            Intrinsics.checkNotNullParameter((Object)userAttributes, (String)"userAttributes");
            Intrinsics.checkNotNullParameter((Object)certification, (String)"certification");
            Pair<PGPSecretKeyRing, PGPPublicKeyRing> secretAndPublicKeys = this.secretAndPublicKeys(keyRing);
            PGPSecretKeyRing secretKeys = (PGPSecretKeyRing)secretAndPublicKeys.getFirst();
            PGPPublicKeyRing certificate = (PGPPublicKeyRing)secretAndPublicKeys.getSecond();
            PGPPublicKey pGPPublicKey = PGPPublicKey.addCertification((PGPPublicKey)this.requirePrimaryPublicKeyFrom((PGPKeyRing)certificate), (PGPUserAttributeSubpacketVector)userAttributes, (PGPSignature)certification);
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"addCertification(\n      \u2026           certification)");
            Collection collection = CollectionsKt.listOf((Object)pGPPublicKey);
            Iterator iterator = certificate.getPublicKeys();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"certificate.publicKeys");
            certificate = new PGPPublicKeyRing(CollectionsKt.plus((Collection)collection, (Sequence)SequencesKt.drop((Sequence)SequencesKt.asSequence((Iterator)iterator), (int)1)));
            if (secretKeys == null) {
                pGPKeyRing = (PGPKeyRing)certificate;
            } else {
                PGPSecretKeyRing pGPSecretKeyRing = PGPSecretKeyRing.replacePublicKeys((PGPSecretKeyRing)secretKeys, (PGPPublicKeyRing)certificate);
                Intrinsics.checkNotNull((Object)pGPSecretKeyRing, (String)"null cannot be cast to non-null type T of org.pgpainless.key.util.KeyRingUtils.Companion.injectCertification");
                pGPKeyRing = (PGPKeyRing)pGPSecretKeyRing;
            }
            return (T)pGPKeyRing;
        }

        @JvmStatic
        @NotNull
        public final <T extends PGPKeyRing> T keysPlusPublicKey(@NotNull T keyRing, @NotNull PGPPublicKey publicKey) {
            PGPKeyRing pGPKeyRing;
            Intrinsics.checkNotNullParameter(keyRing, (String)"keyRing");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Pair<PGPSecretKeyRing, PGPPublicKeyRing> secretAndPublicKeys = this.secretAndPublicKeys(keyRing);
            PGPSecretKeyRing secretKeys = (PGPSecretKeyRing)secretAndPublicKeys.getFirst();
            PGPPublicKeyRing certificate = (PGPPublicKeyRing)secretAndPublicKeys.getSecond();
            if (secretKeys == null) {
                PGPPublicKeyRing pGPPublicKeyRing = PGPPublicKeyRing.insertPublicKey((PGPPublicKeyRing)certificate, (PGPPublicKey)publicKey);
                Intrinsics.checkNotNull((Object)pGPPublicKeyRing, (String)"null cannot be cast to non-null type T of org.pgpainless.key.util.KeyRingUtils.Companion.keysPlusPublicKey");
                pGPKeyRing = (PGPKeyRing)pGPPublicKeyRing;
            } else {
                PGPSecretKeyRing pGPSecretKeyRing = PGPSecretKeyRing.insertOrReplacePublicKey((PGPSecretKeyRing)secretKeys, (PGPPublicKey)publicKey);
                Intrinsics.checkNotNull((Object)pGPSecretKeyRing, (String)"null cannot be cast to non-null type T of org.pgpainless.key.util.KeyRingUtils.Companion.keysPlusPublicKey");
                pGPKeyRing = (PGPKeyRing)pGPSecretKeyRing;
            }
            return (T)pGPKeyRing;
        }

        @JvmStatic
        private final Pair<PGPSecretKeyRing, PGPPublicKeyRing> secretAndPublicKeys(PGPKeyRing keyRing) {
            PGPSecretKeyRing secretKeys = null;
            PGPPublicKeyRing certificate = null;
            PGPKeyRing pGPKeyRing = keyRing;
            if (pGPKeyRing instanceof PGPSecretKeyRing) {
                secretKeys = (PGPSecretKeyRing)keyRing;
                certificate = PGPSecretKeyRingExtensionsKt.getCertificate(secretKeys);
            } else if (pGPKeyRing instanceof PGPPublicKeyRing) {
                certificate = (PGPPublicKeyRing)keyRing;
            } else {
                throw new IllegalArgumentException("keyRing is an unknown PGPKeyRing subclass: " + keyRing.getClass().getName());
            }
            return TuplesKt.to((Object)secretKeys, (Object)certificate);
        }

        @JvmStatic
        @NotNull
        public final PGPSecretKeyRing keysPlusSecretKey(@NotNull PGPSecretKeyRing secretKeys, @NotNull PGPSecretKey secretKey) {
            Intrinsics.checkNotNullParameter((Object)secretKeys, (String)"secretKeys");
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            PGPSecretKeyRing pGPSecretKeyRing = PGPSecretKeyRing.insertSecretKey((PGPSecretKeyRing)secretKeys, (PGPSecretKey)secretKey);
            Intrinsics.checkNotNullExpressionValue((Object)pGPSecretKeyRing, (String)"insertSecretKey(secretKeys, secretKey)");
            return pGPSecretKeyRing;
        }

        @JvmStatic
        @NotNull
        public final PGPSecretKey secretKeyPlusSignature(@NotNull PGPSecretKey secretKey, @NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            PGPPublicKey it = PGPPublicKey.addCertification((PGPPublicKey)secretKey.getPublicKey(), (PGPSignature)signature);
            boolean bl = false;
            PGPSecretKey pGPSecretKey = PGPSecretKey.replacePublicKey((PGPSecretKey)secretKey, (PGPPublicKey)it);
            Intrinsics.checkNotNullExpressionValue((Object)pGPSecretKey, (String)"replacePublicKey(secretKey, it)");
            return pGPSecretKey;
        }

        @JvmStatic
        @NotNull
        public final PGPSecretKeyRing stripSecretKey(@NotNull PGPSecretKeyRing secretKeys, long keyId) {
            PGPSecretKey it;
            Object element$iv;
            Intrinsics.checkNotNullParameter((Object)secretKeys, (String)"secretKeys");
            if (!(keyId != secretKeys.getPublicKey().getKeyID())) {
                boolean $i$a$-require-KeyRingUtils$Companion$stripSecretKey$22 = false;
                String $i$a$-require-KeyRingUtils$Companion$stripSecretKey$22 = "Bouncy Castle currently cannot deal with stripped primary secret keys.";
                throw new IllegalArgumentException($i$a$-require-KeyRingUtils$Companion$stripSecretKey$22.toString());
            }
            if (secretKeys.getSecretKey(keyId) == null) {
                throw new NoSuchElementException("PGPSecretKeyRing does not contain secret key " + LongExtensionsKt.openPgpKeyId(keyId) + '.');
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Object $this$forEach$iv = (Iterable)secretKeys;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                element$iv = object.next();
                it = (PGPSecretKey)element$iv;
                boolean bl = false;
                if (it.getKeyID() == keyId) {
                    it.getPublicKey().encode((OutputStream)out);
                    continue;
                }
                it.encode((OutputStream)out);
            }
            Iterator iterator = secretKeys.getExtraPublicKeys();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"secretKeys.extraPublicKeys");
            $this$forEach$iv = iterator;
            $i$f$forEach = false;
            object = $this$forEach$iv;
            while (object.hasNext()) {
                element$iv = object.next();
                it = (PGPPublicKey)element$iv;
                boolean bl = false;
                it.encode((OutputStream)out);
            }
            return new PGPSecretKeyRing(out.toByteArray(), ImplementationFactory.Companion.getInstance().getKeyFingerprintCalculator());
        }

        @JvmStatic
        @NotNull
        public final PGPPublicKey getStrippedDownPublicKey(@NotNull PGPPublicKey bloatedKey) {
            Intrinsics.checkNotNullParameter((Object)bloatedKey, (String)"bloatedKey");
            return new PGPPublicKey(bloatedKey.getPublicKeyPacket(), ImplementationFactory.Companion.getInstance().getKeyFingerprintCalculator());
        }

        @JvmStatic
        @NotNull
        public final List<String> getUserIdsIgnoringInvalidUTF8(@NotNull PGPPublicKey key) {
            List list;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            List $this$getUserIdsIgnoringInvalidUTF8_u24lambda_u247 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            Iterator iterator = key.getRawUserIDs();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"key.rawUserIDs");
            Iterator $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv;
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                byte[] it = (byte[])element$iv;
                boolean bl2 = false;
                try {
                    String string = Strings.fromUTF8ByteArray((byte[])it);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fromUTF8ByteArray(it)");
                    $this$getUserIdsIgnoringInvalidUTF8_u24lambda_u247.add(string);
                }
                catch (IllegalArgumentException e) {
                    Logger logger = LOGGER;
                    StringBuilder stringBuilder = new StringBuilder().append("Invalid UTF-8 user-ID encountered: ");
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    logger.warn(stringBuilder.append(new String(it, Charsets.UTF_8)).toString());
                }
            }
            return CollectionsKt.build((List)list);
        }

        @JvmStatic
        @NotNull
        public final PGPSecretKeyRing changePassphrase(@Nullable Long keyId, @NotNull PGPSecretKeyRing secretKeys, @NotNull SecretKeyRingProtector oldProtector, @NotNull SecretKeyRingProtector newProtector) throws MissingPassphraseException, PGPException {
            PGPSecretKeyRing pGPSecretKeyRing;
            Intrinsics.checkNotNullParameter((Object)secretKeys, (String)"secretKeys");
            Intrinsics.checkNotNullParameter((Object)oldProtector, (String)"oldProtector");
            Intrinsics.checkNotNullParameter((Object)newProtector, (String)"newProtector");
            if (keyId == null) {
                Iterator iterator = secretKeys.getSecretKeys();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"secretKeys.secretKeys");
                pGPSecretKeyRing = new PGPSecretKeyRing(SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)((Function1)new Function1<PGPSecretKey, PGPSecretKey>(oldProtector, newProtector){
                    final /* synthetic */ SecretKeyRingProtector $oldProtector;
                    final /* synthetic */ SecretKeyRingProtector $newProtector;
                    {
                        this.$oldProtector = $oldProtector;
                        this.$newProtector = $newProtector;
                        super(1);
                    }

                    @NotNull
                    public final PGPSecretKey invoke(PGPSecretKey it) {
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        return KeyRingUtils.Companion.reencryptPrivateKey(it, this.$oldProtector, this.$newProtector);
                    }
                }))));
            } else {
                Iterator iterator = secretKeys.getSecretKeys();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"secretKeys.secretKeys");
                pGPSecretKeyRing = new PGPSecretKeyRing(SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)((Function1)new Function1<PGPSecretKey, PGPSecretKey>(keyId, oldProtector, newProtector){
                    final /* synthetic */ Long $keyId;
                    final /* synthetic */ SecretKeyRingProtector $oldProtector;
                    final /* synthetic */ SecretKeyRingProtector $newProtector;
                    {
                        this.$keyId = $keyId;
                        this.$oldProtector = $oldProtector;
                        this.$newProtector = $newProtector;
                        super(1);
                    }

                    public final PGPSecretKey invoke(PGPSecretKey it) {
                        PGPSecretKey pGPSecretKey;
                        Long l = this.$keyId;
                        if (l != null && it.getKeyID() == l.longValue()) {
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            pGPSecretKey = KeyRingUtils.Companion.reencryptPrivateKey(it, this.$oldProtector, this.$newProtector);
                        } else {
                            pGPSecretKey = it;
                        }
                        return pGPSecretKey;
                    }
                }))));
            }
            PGPSecretKeyRing it = pGPSecretKeyRing;
            boolean bl = false;
            return Companion.s2kUsageFixIfNecessary(it, newProtector);
        }

        @JvmStatic
        @NotNull
        public final PGPSecretKey reencryptPrivateKey(@NotNull PGPSecretKey secretKey, @NotNull SecretKeyRingProtector oldProtector, @NotNull SecretKeyRingProtector newProtector) {
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            Intrinsics.checkNotNullParameter((Object)oldProtector, (String)"oldProtector");
            Intrinsics.checkNotNullParameter((Object)newProtector, (String)"newProtector");
            if (secretKey.getS2K() != null && secretKey.getS2K().getType() == 101) {
                return secretKey;
            }
            PGPSecretKey pGPSecretKey = PGPSecretKey.copyWithNewPassword((PGPSecretKey)secretKey, (PBESecretKeyDecryptor)oldProtector.getDecryptor(secretKey.getKeyID()), (PBESecretKeyEncryptor)newProtector.getEncryptor(secretKey.getKeyID()));
            Intrinsics.checkNotNullExpressionValue((Object)pGPSecretKey, (String)"copyWithNewPassword(\n   \u2026cryptor(secretKey.keyID))");
            return pGPSecretKey;
        }

        @JvmStatic
        @NotNull
        public final PGPSecretKeyRing s2kUsageFixIfNecessary(@NotNull PGPSecretKeyRing secretKeys, @NotNull SecretKeyRingProtector protector) {
            boolean bl;
            block2: {
                Intrinsics.checkNotNullParameter((Object)secretKeys, (String)"secretKeys");
                Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
                Iterator iterator = secretKeys.getSecretKeys();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"secretKeys.secretKeys");
                Sequence $this$any$iv = SequencesKt.asSequence((Iterator)iterator);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PGPSecretKey it = (PGPSecretKey)element$iv;
                    boolean bl2 = false;
                    if (!(it.getS2KUsage() == 255)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (bl) {
                return S2KUsageFix.Companion.replaceUsageChecksumWithUsageSha1(secretKeys, protector, true);
            }
            return secretKeys;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

