/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.bouncycastle.extensions;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.bouncycastle.extensions.PGPPublicKeyExtensionsKt;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;
import org.pgpainless.key.generation.type.eddsa_legacy.EdDSALegacyCurve;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Lorg/pgpainless/bouncycastle/extensions/PGPPublicKeyExtensionsTest;", "", "()V", "openPgpFingerprint returns fitting fingerprint", "", "test getCurveName fails for non-curve keys", "test getCurveName for all ECDSA curves", "test getCurveName for legacy EdDSA curves", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nPGPPublicKeyExtensionsTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PGPPublicKeyExtensionsTest.kt\norg/pgpainless/bouncycastle/extensions/PGPPublicKeyExtensionsTest\n+ 2 Assertions.kt\norg/junit/jupiter/api/AssertionsKt\n*L\n1#1,61:1\n100#2,7:62\n*S KotlinDebug\n*F\n+ 1 PGPPublicKeyExtensionsTest.kt\norg/pgpainless/bouncycastle/extensions/PGPPublicKeyExtensionsTest\n*L\n52#1:62,7\n*E\n"})
public final class PGPPublicKeyExtensionsTest {
    @Test
    public final void test getCurveName for all ECDSA curves() {
        for (EllipticCurve curve : EllipticCurve.values()) {
            PGPPublicKey key = ((KeyRingBuilder)PGPainless.Companion.buildKeyRing().setPrimaryKey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.ECDSA(curve), new KeyFlag[0]))).build().getPublicKey();
            String string = curve.getCurveName();
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            Assertions.assertEquals((Object)string, (Object)PGPPublicKeyExtensionsKt.getCurveName((PGPPublicKey)key));
        }
    }

    @Test
    public final void test getCurveName for legacy EdDSA curves() {
        for (EdDSALegacyCurve curve : EdDSALegacyCurve.values()) {
            PGPPublicKey key = ((KeyRingBuilder)PGPainless.Companion.buildKeyRing().setPrimaryKey(KeySpec.Companion.getBuilder((KeyType)KeyType.Companion.EDDSA_LEGACY(curve), new KeyFlag[0]))).build().getPublicKey();
            String string = curve.getCurveName();
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            Assertions.assertEquals((Object)string, (Object)PGPPublicKeyExtensionsKt.getCurveName((PGPPublicKey)key));
        }
    }

    @Test
    public final void test getCurveName fails for non-curve keys() {
        Throwable throwable;
        Throwable throwable2;
        PGPPublicKeyRing key = TestKeys.getJulietPublicKeyRing();
        PGPPublicKey pGPPublicKey = key.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"key.publicKey");
        Assertions.assertEquals((Object)PublicKeyAlgorithm.RSA_GENERAL, (Object)PGPPublicKeyExtensionsKt.getPublicKeyAlgorithm((PGPPublicKey)pGPPublicKey));
        boolean $i$f$assertThrows = false;
        try {
            boolean bl = false;
            PGPPublicKey pGPPublicKey2 = key.getPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey2, (String)"key.publicKey");
            PGPPublicKeyExtensionsKt.getCurveName((PGPPublicKey)pGPPublicKey2);
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable2 = caught$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        Throwable throwable$iv = throwable;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
    }

    @Test
    public final void openPgpFingerprint returns fitting fingerprint() {
        PGPSecretKeyRing key = TestKeys.getEmilSecretKeyRing();
        PGPPublicKey pGPPublicKey = key.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"key.publicKey");
        Assertions.assertEquals((Object)TestKeys.EMIL_FINGERPRINT, (Object)PGPPublicKeyExtensionsKt.getOpenPgpFingerprint((PGPPublicKey)pGPPublicKey));
    }
}

