/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.bouncycastle.extensions;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.pgpainless.PGPainless;
import org.pgpainless.bouncycastle.extensions.PGPSecretKeyRingExtensionsKt;
import org.pgpainless.encryption_signing.EncryptionBuilderInterface;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.SecretKeyRingProtector;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/pgpainless/bouncycastle/extensions/PGPSecretKeyRingExtensionsTest;", "", "()V", "testGetSecretKeyForSignature", "", "testHasPgpSecretKeyRing", "testRequireSecretKey", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nPGPSecretKeyRingExtensionsTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PGPSecretKeyRingExtensionsTest.kt\norg/pgpainless/bouncycastle/extensions/PGPSecretKeyRingExtensionsTest\n+ 2 Assertions.kt\norg/junit/jupiter/api/AssertionsKt\n*L\n1#1,60:1\n100#2,7:61\n100#2,7:68\n*S KotlinDebug\n*F\n+ 1 PGPSecretKeyRingExtensionsTest.kt\norg/pgpainless/bouncycastle/extensions/PGPSecretKeyRingExtensionsTest\n*L\n38#1:61,7\n39#1:68,7\n*E\n"})
public final class PGPSecretKeyRingExtensionsTest {
    @Test
    public final void testHasPgpSecretKeyRing() {
        PGPSecretKeyRing key = TestKeys.getEmilSecretKeyRing();
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
        Assertions.assertTrue((boolean)PGPSecretKeyRingExtensionsKt.hasSecretKey((PGPSecretKeyRing)key, (long)6284463849526474508L));
        OpenPgpV4Fingerprint openPgpV4Fingerprint = TestKeys.EMIL_FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)openPgpV4Fingerprint, (String)"EMIL_FINGERPRINT");
        Assertions.assertTrue((boolean)PGPSecretKeyRingExtensionsKt.hasSecretKey((PGPSecretKeyRing)key, (OpenPgpFingerprint)((OpenPgpFingerprint)openPgpV4Fingerprint)));
        Assertions.assertFalse((boolean)PGPSecretKeyRingExtensionsKt.hasSecretKey((PGPSecretKeyRing)key, (long)334147643349279223L));
        OpenPgpV4Fingerprint openPgpV4Fingerprint2 = TestKeys.ROMEO_FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)openPgpV4Fingerprint2, (String)"ROMEO_FINGERPRINT");
        Assertions.assertFalse((boolean)PGPSecretKeyRingExtensionsKt.hasSecretKey((PGPSecretKeyRing)key, (OpenPgpFingerprint)((OpenPgpFingerprint)openPgpV4Fingerprint2)));
    }

    @Test
    public final void testRequireSecretKey() {
        Throwable throwable;
        Throwable throwable2;
        Throwable throwable3;
        Throwable $i$a$-assertThrows-PGPSecretKeyRingExtensionsTest$testRequireSecretKey$32;
        PGPSecretKeyRing key = TestKeys.getEmilSecretKeyRing();
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
        Assertions.assertNotNull((Object)PGPSecretKeyRingExtensionsKt.requireSecretKey((PGPSecretKeyRing)key, (long)6284463849526474508L));
        OpenPgpV4Fingerprint openPgpV4Fingerprint = TestKeys.EMIL_FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)openPgpV4Fingerprint, (String)"EMIL_FINGERPRINT");
        Assertions.assertNotNull((Object)PGPSecretKeyRingExtensionsKt.requireSecretKey((PGPSecretKeyRing)key, (OpenPgpFingerprint)((OpenPgpFingerprint)openPgpV4Fingerprint)));
        boolean $i$f$assertThrows = false;
        try {
            boolean $i$a$-assertThrows-PGPSecretKeyRingExtensionsTest$testRequireSecretKey$32 = false;
            PGPSecretKeyRingExtensionsKt.requireSecretKey((PGPSecretKeyRing)key, (long)334147643349279223L);
            $i$a$-assertThrows-PGPSecretKeyRingExtensionsTest$testRequireSecretKey$32 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            $i$a$-assertThrows-PGPSecretKeyRingExtensionsTest$testRequireSecretKey$32 = caught$iv;
        }
        if (!((throwable3 = $i$a$-assertThrows-PGPSecretKeyRingExtensionsTest$testRequireSecretKey$32) instanceof Throwable)) {
            throwable3 = null;
        }
        Throwable throwable$iv = throwable3;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(NoSuchElementException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
        $i$f$assertThrows = false;
        try {
            boolean bl = false;
            OpenPgpV4Fingerprint openPgpV4Fingerprint2 = TestKeys.ROMEO_FINGERPRINT;
            Intrinsics.checkNotNullExpressionValue((Object)openPgpV4Fingerprint2, (String)"ROMEO_FINGERPRINT");
            PGPSecretKeyRingExtensionsKt.requireSecretKey((PGPSecretKeyRing)key, (OpenPgpFingerprint)((OpenPgpFingerprint)openPgpV4Fingerprint2));
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable2 = caught$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        throwable$iv = throwable;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(NoSuchElementException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
    }

    @Test
    public final void testGetSecretKeyForSignature() {
        PGPSecretKeyRing key = TestKeys.getEmilSecretKeyRing();
        EncryptionBuilderInterface.WithOptions withOptions = PGPainless.Companion.encryptAndOrSign().onOutputStream((OutputStream)new ByteArrayOutputStream());
        SigningOptions signingOptions = SigningOptions.Companion.get();
        SecretKeyRingProtector secretKeyRingProtector = (SecretKeyRingProtector)SecretKeyRingProtector.Companion.unprotectedKeys();
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
        EncryptionStream signer = withOptions.withOptions(ProducerOptions.Companion.sign(SigningOptions.addDetachedSignature$default((SigningOptions)signingOptions, (SecretKeyRingProtector)secretKeyRingProtector, (PGPSecretKeyRing)key, null, null, null, (int)28, null)));
        String string = "Hello, World!\n";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        signer.write(byArray);
        signer.close();
        PGPSignature sig = (PGPSignature)CollectionsKt.first((Iterable)((Iterable)((Map.Entry)CollectionsKt.first((Iterable)((Iterable)signer.getResult().getDetachedSignatures()))).getValue()));
        Assertions.assertNotNull((Object)PGPSecretKeyRingExtensionsKt.getSecretKeyFor((PGPSecretKeyRing)key, (PGPSignature)sig));
        PGPSecretKeyRing pGPSecretKeyRing = TestKeys.getRomeoSecretKeyRing();
        Intrinsics.checkNotNullExpressionValue((Object)pGPSecretKeyRing, (String)"getRomeoSecretKeyRing()");
        Assertions.assertNull((Object)PGPSecretKeyRingExtensionsKt.getSecretKeyFor((PGPSecretKeyRing)pGPSecretKeyRing, (PGPSignature)sig));
    }
}

