/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MessageMetadata;
import org.pgpainless.decryption_verification.cleartext_signatures.InMemoryMultiPassStrategy;
import org.pgpainless.decryption_verification.cleartext_signatures.MultiPassStrategy;

public class VerifyDetachedSignatureTest {
    @Test
    public void test1() throws PGPException, IOException {
        String signedContent = "Content-Type: multipart/mixed; boundary=\"OSR6TONWKJD9dgyc2XH5AQPNnAs7pdg1t\"\n\n--OSR6TONWKJD9dgyc2XH5AQPNnAs7pdg1t\nContent-Type: text/plain; charset=utf-8\nContent-Transfer-Encoding: quoted-printable\nContent-Language: en-US\n\nNOT encrypted + signed(detached)\n\n\n\n--OSR6TONWKJD9dgyc2XH5AQPNnAs7pdg1t--\n";
        String signature = "-----BEGIN PGP SIGNATURE-----\n\niHUEARYIAB0WIQTBZCjWAcs5N4nPYdTDIInNavjWzgUCYgKPzAAKCRDDIInNavjW\nzmdoAP0TdFt1OWqosHhXxt2hNYqZQMc6bgQRpJNL029nRyzkPAD/SoYJ4T+aYEhw\n11qrbXloqkr0G3QaA6/zk31RPMI/bgI=\n=o5Ze\n-----END PGP SIGNATURE-----\n";
        String pubkey = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: PGPainless\n\nmDMEYIucWBYJKwYBBAHaRw8BAQdAew+8mzMWyf3+Pfy49qa60uKV6e5os7de4TdZ\nceAWUq+0F2RlbmJvbmQ3QGZsb3djcnlwdC50ZXN0iHgEExYKACAFAmCLnFgCGwMF\nFgIDAQAECwkIBwUVCgkICwIeAQIZAQAKCRDDIInNavjWzm3JAQCgFgCEyD58iEa/\nRw/DYNoQNoZC1lhw1bxBiOcIbtkdBgEAsDFZu3TBavOMKI7KW+vfMBHtRVbkMNpv\nunaAldoabgO4OARgi5xYEgorBgEEAZdVAQUBAQdAB1/Mrq5JGYim4KqGTSK4OESQ\nUwPgK56q0yrkiU9WgyYDAQgHiHUEGBYKAB0FAmCLnFgCGwwFFgIDAQAECwkIBwUV\nCgkICwIeAQAKCRDDIInNavjWzjMgAQCU+R1fItqdY6lt9jXUqipmXuqVaEFPwNA8\nYJ1rIwDwVQEAyUc8162KWzA2iQB5akwLwNr/pLDDtOWwhLUkrBb3mAc=\n=pXF6\n-----END PGP PUBLIC KEY BLOCK-----\n";
        DecryptionStream verifier = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(signedContent.getBytes(StandardCharsets.UTF_8))).withOptions(new ConsumerOptions().addVerificationOfDetachedSignatures((InputStream)new ByteArrayInputStream(signature.getBytes(StandardCharsets.UTF_8))).addVerificationCerts(PGPainless.readKeyRing().keyRingCollection(pubkey, true).getPgpPublicKeyRingCollection()).setMultiPassStrategy((MultiPassStrategy)new InMemoryMultiPassStrategy()));
        Streams.drain((InputStream)verifier);
        verifier.close();
        MessageMetadata metadata = verifier.getMetadata();
        Assertions.assertTrue((boolean)metadata.isVerifiedSigned());
    }

    @Test
    public void test2() throws PGPException, IOException {
        String signedContent = "Content-Type: multipart/mixed; boundary=\"------------26m0wPaTDf7nRDIftnMj4qjE\";\r\n protected-headers=\"v1\"\r\nFrom: Denys <denbond7@flowcrypt.test>\r\nTo: default@flowcrypt.test\r\nMessage-ID: <b2ffb55b-3ef0-4ce2-b522-85bd730bfa7e@flowcrypt.test>\r\nSubject: Signed + pub key\r\n\r\n--------------26m0wPaTDf7nRDIftnMj4qjE\r\nContent-Type: multipart/mixed; boundary=\"------------RQxi6oNuQI1n8MnuNglORR5s\"\r\n\r\n--------------RQxi6oNuQI1n8MnuNglORR5s\r\nContent-Type: text/plain; charset=UTF-8; format=flowed\r\nContent-Transfer-Encoding: base64\r\n\r\nU29tZSBpbXBvcnRhbnQgdGV4dA0KDQo=\r\n--------------RQxi6oNuQI1n8MnuNglORR5s\r\nContent-Type: application/pgp-keys; name=\"OpenPGP_0xC32089CD6AF8D6CE.asc\"\r\nContent-Disposition: attachment; filename=\"OpenPGP_0xC32089CD6AF8D6CE.asc\"\r\nContent-Description: OpenPGP public key\r\nContent-Transfer-Encoding: quoted-printable\r\n\r\n-----BEGIN PGP PUBLIC KEY BLOCK-----\r\n\r\nxjMEYIucWBYJKwYBBAHaRw8BAQdAew+8mzMWyf3+Pfy49qa60uKV6e5os7de4TdZ\r\nceAWUq/NF2RlbmJvbmQ3QGZsb3djcnlwdC50ZXN0wngEExYKACAFAmCLnFgCGwMF\r\nFgIDAQAECwkIBwUVCgkICwIeAQIZAQAKCRDDIInNavjWzm3JAQCgFgCEyD58iEa/\r\nRw/DYNoQNoZC1lhw1bxBiOcIbtkdBgEAsDFZu3TBavOMKI7KW+vfMBHtRVbkMNpv\r\nunaAldoabgPOOARgi5xYEgorBgEEAZdVAQUBAQdAB1/Mrq5JGYim4KqGTSK4OESQ\r\nUwPgK56q0yrkiU9WgyYDAQgHwnUEGBYKAB0FAmCLnFgCGwwFFgIDAQAECwkIBwUV\r\nCgkICwIeAQAKCRDDIInNavjWzjMgAQCU+R1fItqdY6lt9jXUqipmXuqVaEFPwNA8\r\nYJ1rIwDwVQEAyUc8162KWzA2iQB5akwLwNr/pLDDtOWwhLUkrBb3mAc=3D\r\n=3DyJxA\r\n-----END PGP PUBLIC KEY BLOCK-----\r\n\r\n--------------RQxi6oNuQI1n8MnuNglORR5s--\r\n\r\n--------------26m0wPaTDf7nRDIftnMj4qjE--\r\n";
        String signature = "-----BEGIN PGP SIGNATURE-----\n\nwnsEABYIACMWIQTBZCjWAcs5N4nPYdTDIInNavjWzgUCYguNRQUDAAAAAAAKCRDDIInNavjWzoxf\nAQCOCu6bityLBbY1MPF+smwYLjkJvzEHf+ErXC7KkI4mnAEAn7FPPOzJAwWENv8a//0zg4P9Ymdr\nuyp1EJ1tsavXRQA=\n=K5yW\n-----END PGP SIGNATURE-----\n";
        String pubkey = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: PGPainless\n\nmDMEYIucWBYJKwYBBAHaRw8BAQdAew+8mzMWyf3+Pfy49qa60uKV6e5os7de4TdZ\nceAWUq+0F2RlbmJvbmQ3QGZsb3djcnlwdC50ZXN0iHgEExYKACAFAmCLnFgCGwMF\nFgIDAQAECwkIBwUVCgkICwIeAQIZAQAKCRDDIInNavjWzm3JAQCgFgCEyD58iEa/\nRw/DYNoQNoZC1lhw1bxBiOcIbtkdBgEAsDFZu3TBavOMKI7KW+vfMBHtRVbkMNpv\nunaAldoabgO4OARgi5xYEgorBgEEAZdVAQUBAQdAB1/Mrq5JGYim4KqGTSK4OESQ\nUwPgK56q0yrkiU9WgyYDAQgHiHUEGBYKAB0FAmCLnFgCGwwFFgIDAQAECwkIBwUV\nCgkICwIeAQAKCRDDIInNavjWzjMgAQCU+R1fItqdY6lt9jXUqipmXuqVaEFPwNA8\nYJ1rIwDwVQEAyUc8162KWzA2iQB5akwLwNr/pLDDtOWwhLUkrBb3mAc=\n=pXF6\n-----END PGP PUBLIC KEY BLOCK-----\n";
        DecryptionStream verifier = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(signedContent.getBytes(StandardCharsets.UTF_8))).withOptions(new ConsumerOptions().addVerificationOfDetachedSignatures((InputStream)new ByteArrayInputStream(signature.getBytes(StandardCharsets.UTF_8))).addVerificationCerts(PGPainless.readKeyRing().keyRingCollection(pubkey, true).getPgpPublicKeyRingCollection()).setMultiPassStrategy((MultiPassStrategy)new InMemoryMultiPassStrategy()));
        Streams.drain((InputStream)verifier);
        verifier.close();
        MessageMetadata metadata = verifier.getMetadata();
        Assertions.assertTrue((boolean)metadata.isVerifiedSigned());
    }
}

