/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MessageMetadata;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.TestKeys;
import org.pgpainless.util.DateUtil;

public class VerifyNotBeforeNotAfterTest {
    private static final byte[] data = "Hello, World!\n".getBytes(StandardCharsets.UTF_8);
    private static final byte[] inlineSigned = "-----BEGIN PGP MESSAGE-----\nVersion: PGPainless\n\nkA0DAAoTVzbmkxrPNwwAyxRiAAAAAABIZWxsbywgV29ybGQhCoh1BAATCgAGBQJh\nG7iQACEJEFc25pMazzcMFiEET2ZcTcLEZgvGQl5BVzbmkxrPNwxH7AEAsEyOCQPG\n3F2JSWK/8AYyvsk17Gtb9TGn5SWqLo5Ac8YBAIlijYnSIHm0aatlMsK6t/rAB3bU\neHyT9/mVlk9qrOWs\n=vkxO\n-----END PGP MESSAGE-----".getBytes(StandardCharsets.UTF_8);
    private static final byte[] detachedSignature = "-----BEGIN PGP SIGNATURE-----\nVersion: PGPainless\n\niHUEABMKAAYFAmEbuJAAIQkQVzbmkxrPNwwWIQRPZlxNwsRmC8ZCXkFXNuaTGs83\nDEfsAQDNXmvhkh92aoUp9KNCpCqA6nvHmT5O0n1Lr0BmBccHtgD8CVR3VElemas+\naH5l06cDUW1peQQs+xZ0FHltWmk5PJw=\n=RJDi\n-----END PGP SIGNATURE-----".getBytes(StandardCharsets.UTF_8);
    private static final Date signatureCreationDate = DateUtil.parseUTCDate((String)"2021-08-17 13:24:32 UTC");
    private static final Date T0 = DateUtil.parseUTCDate((String)"2021-08-17 12:30:00 UTC");
    private static final Date T1 = signatureCreationDate;
    private static final Date T2 = DateUtil.parseUTCDate((String)"2021-08-17 13:30:00 UTC");
    private static PGPPublicKeyRing certificate;
    private static SubkeyIdentifier signingKey;

    @BeforeAll
    public static void setup() throws IOException {
        certificate = TestKeys.getEmilPublicKeyRing();
        signingKey = new SubkeyIdentifier((PGPKeyRing)certificate);
    }

    @Test
    public void noConstraintsVerifyInlineSig() throws PGPException, IOException {
        ConsumerOptions options = new ConsumerOptions().addVerificationCert(certificate);
        DecryptionStream verifier = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(inlineSigned)).withOptions(options);
        MessageMetadata metadata = this.processSignedData(verifier);
        Assertions.assertTrue((boolean)metadata.isVerifiedSignedBy((PGPKeyRing)certificate));
    }

    @Test
    public void noConstraintsVerifyDetachedSig() throws PGPException, IOException {
        ConsumerOptions options = new ConsumerOptions().addVerificationCert(certificate).addVerificationOfDetachedSignatures((InputStream)new ByteArrayInputStream(detachedSignature));
        DecryptionStream verifier = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(data)).withOptions(options);
        MessageMetadata metadata = this.processSignedData(verifier);
        Assertions.assertTrue((boolean)metadata.isVerifiedSignedBy((PGPKeyRing)certificate));
    }

    @Test
    public void notBeforeT1DoesNotRejectInlineSigMadeAtT1() throws PGPException, IOException {
        ConsumerOptions options = new ConsumerOptions().verifyNotBefore(T1).addVerificationCert(certificate);
        DecryptionStream verifier = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(inlineSigned)).withOptions(options);
        MessageMetadata metadata = this.processSignedData(verifier);
        Assertions.assertTrue((boolean)metadata.isVerifiedSignedBy((PGPKeyRing)certificate));
    }

    @Test
    public void notBeforeT1DoesNotRejectDetachedSigMadeAtT1() throws PGPException, IOException {
        ConsumerOptions options = new ConsumerOptions().verifyNotBefore(T1).addVerificationCert(certificate).addVerificationOfDetachedSignatures((InputStream)new ByteArrayInputStream(detachedSignature));
        DecryptionStream verifier = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(data)).withOptions(options);
        MessageMetadata metadata = this.processSignedData(verifier);
        Assertions.assertTrue((boolean)metadata.isVerifiedSignedBy((PGPKeyRing)certificate));
    }

    @Test
    public void verifyNotBeforeT2DoesRejectInlineSignatureMadeAtT1() throws PGPException, IOException {
        ConsumerOptions options = new ConsumerOptions().verifyNotBefore(T2).addVerificationCert(certificate);
        DecryptionStream verifier = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(inlineSigned)).withOptions(options);
        MessageMetadata metadata = this.processSignedData(verifier);
        Assertions.assertFalse((boolean)metadata.isVerifiedInlineSignedBy((PGPKeyRing)certificate));
    }

    @Test
    public void verifyNotBeforeT2DoesRejectDetachedSigMadeAtT1() throws PGPException, IOException {
        ConsumerOptions options = new ConsumerOptions().verifyNotBefore(T2).addVerificationCert(certificate).addVerificationOfDetachedSignatures((InputStream)new ByteArrayInputStream(detachedSignature));
        DecryptionStream verifier = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(data)).withOptions(options);
        MessageMetadata metadata = this.processSignedData(verifier);
        Assertions.assertFalse((boolean)metadata.isVerifiedSignedBy((PGPKeyRing)certificate));
    }

    @Test
    public void verifyNotAfterT1DoesNotRejectInlineSigMadeAtT1() throws PGPException, IOException {
        ConsumerOptions options = new ConsumerOptions().verifyNotAfter(T1).addVerificationCert(certificate);
        DecryptionStream verifier = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(inlineSigned)).withOptions(options);
        MessageMetadata metadata = this.processSignedData(verifier);
        Assertions.assertTrue((boolean)metadata.isVerifiedSignedBy((PGPKeyRing)certificate));
    }

    @Test
    public void verifyNotAfterT1DoesRejectDetachedSigMadeAtT1() throws PGPException, IOException {
        ConsumerOptions options = new ConsumerOptions().verifyNotAfter(T1).addVerificationCert(certificate).addVerificationOfDetachedSignatures((InputStream)new ByteArrayInputStream(detachedSignature));
        DecryptionStream verifier = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(data)).withOptions(options);
        MessageMetadata metadata = this.processSignedData(verifier);
        Assertions.assertTrue((boolean)metadata.isVerifiedSignedBy((PGPKeyRing)certificate));
    }

    @Test
    public void verifyNotAfterT0DoesRejectInlineSigMadeAtT1() throws PGPException, IOException {
        ConsumerOptions options = new ConsumerOptions().verifyNotAfter(T0).addVerificationCert(certificate);
        DecryptionStream verifier = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(inlineSigned)).withOptions(options);
        MessageMetadata metadata = this.processSignedData(verifier);
        Assertions.assertFalse((boolean)metadata.isVerifiedSignedBy((PGPKeyRing)certificate));
    }

    @Test
    public void verifyNotAfterT0DoesRejectDetachedSigMadeAtT1() throws PGPException, IOException {
        ConsumerOptions options = new ConsumerOptions().verifyNotAfter(T0).addVerificationCert(certificate).addVerificationOfDetachedSignatures((InputStream)new ByteArrayInputStream(detachedSignature));
        DecryptionStream verifier = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(data)).withOptions(options);
        MessageMetadata metadata = this.processSignedData(verifier);
        Assertions.assertFalse((boolean)metadata.isVerifiedSignedBy((PGPKeyRing)certificate));
    }

    private MessageMetadata processSignedData(DecryptionStream verifier) throws IOException {
        Streams.drain((InputStream)verifier);
        verifier.close();
        return verifier.getMetadata();
    }
}

