/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.example;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MessageMetadata;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.util.Passphrase;

public class Encrypt {
    private static final String ALICE_KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: 12E3 4F04 C66D 2B70 D16C  960D ACF2 16F0 F93D DD20\nComment: alice@pgpainless.org\n\nlFgEYksu1hYJKwYBBAHaRw8BAQdAIhUpRrs6zFTBI1pK40jCkzY/DQ/t4fUgNtlS\nmXOt1cIAAP4wM0LQD/Wj9w6/QujM/erj/TodDZzmp2ZwblrvDQri0RJ/tBRhbGlj\nZUBwZ3BhaW5sZXNzLm9yZ4iPBBMWCgBBBQJiSy7WCRCs8hbw+T3dIBYhBBLjTwTG\nbStw0WyWDazyFvD5Pd0gAp4BApsBBRYCAwEABAsJCAcFFQoJCAsCmQEAAOOTAQDf\nUsRQSAs0d/Nm4YIrq+gU7gOdTJuf33f/u/u1nGM1fAD/RY7I3gQoZ0lWbvXVkRAL\nCu9cUJdvL7kpW1oYtYg21QucXQRiSy7WEgorBgEEAZdVAQUBAQdA60F84k6MY/Uy\nBCZe4/WP8JDw/Efu5/Gyk8hcd3HzHFsDAQgHAAD/aC8DOOkK0XNVz2hkSVczmNoJ\nUmog0PfQLRujpOTqonAQKIh1BBgWCgAdBQJiSy7WAp4BApsMBRYCAwEABAsJCAcF\nFQoJCAsACgkQrPIW8Pk93SCd6AD/Y3LF2RvgbEaOBtAvH6w0ZBPorB3rk6dx+Ae0\nGvW4E8wA+QHmgNo0pdkDxTl0BN1KC7BV1iRFqe9Vo7fW2LLfhlEEnFgEYksu1hYJ\nKwYBBAHaRw8BAQdAPtqap21/zmVzxOHk++891/EZSNikwWkq9t0pmYjhtJ8AAP9N\nm/G6nbiEB8mu/TkNnb7vdhSmLddL9kdKh0LzWD95LBF0iNUEGBYKAH0FAmJLLtYC\nngECmwIFFgIDAQAECwkIBwUVCgkIC18gBBkWCgAGBQJiSy7WAAoJEOEz2Vo79Yyl\nzN0A/iZAVklSJsfQslshR6/zMBufwCK1S05jg/5Ydaksv3QcAQC4gsxdFFne+H4M\nmos4atad6hMhlqr0/Zyc71ZdO5I/CAAKCRCs8hbw+T3dIGhqAQCIdVtCus336cDe\nNug+E9v1PEM3F/dt6GAqSG8LJqdAGgEA8cUXdUBooOo/QBkDnpteke8Z3IhIGyGe\ndc8OwJyVFwc=\n=ARAi\n-----END PGP PRIVATE KEY BLOCK-----\n";
    private static final String ALICE_CERT = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: PGPainless\nComment: 12E3 4F04 C66D 2B70 D16C  960D ACF2 16F0 F93D DD20\nComment: alice@pgpainless.org\n\nmDMEYksu1hYJKwYBBAHaRw8BAQdAIhUpRrs6zFTBI1pK40jCkzY/DQ/t4fUgNtlS\nmXOt1cK0FGFsaWNlQHBncGFpbmxlc3Mub3JniI8EExYKAEEFAmJLLtYJEKzyFvD5\nPd0gFiEEEuNPBMZtK3DRbJYNrPIW8Pk93SACngECmwEFFgIDAQAECwkIBwUVCgkI\nCwKZAQAA45MBAN9SxFBICzR382bhgiur6BTuA51Mm5/fd/+7+7WcYzV8AP9Fjsje\nBChnSVZu9dWREAsK71xQl28vuSlbWhi1iDbVC7g4BGJLLtYSCisGAQQBl1UBBQEB\nB0DrQXziToxj9TIEJl7j9Y/wkPD8R+7n8bKTyFx3cfMcWwMBCAeIdQQYFgoAHQUC\nYksu1gKeAQKbDAUWAgMBAAQLCQgHBRUKCQgLAAoJEKzyFvD5Pd0gnegA/2Nyxdkb\n4GxGjgbQLx+sNGQT6Kwd65OncfgHtBr1uBPMAPkB5oDaNKXZA8U5dATdSguwVdYk\nRanvVaO31tiy34ZRBLgzBGJLLtYWCSsGAQQB2kcPAQEHQD7amqdtf85lc8Th5Pvv\nPdfxGUjYpMFpKvbdKZmI4bSfiNUEGBYKAH0FAmJLLtYCngECmwIFFgIDAQAECwkI\nBwUVCgkIC18gBBkWCgAGBQJiSy7WAAoJEOEz2Vo79YylzN0A/iZAVklSJsfQslsh\nR6/zMBufwCK1S05jg/5Ydaksv3QcAQC4gsxdFFne+H4Mmos4atad6hMhlqr0/Zyc\n71ZdO5I/CAAKCRCs8hbw+T3dIGhqAQCIdVtCus336cDeNug+E9v1PEM3F/dt6GAq\nSG8LJqdAGgEA8cUXdUBooOo/QBkDnpteke8Z3IhIGyGedc8OwJyVFwc=\n=GUhm\n-----END PGP PUBLIC KEY BLOCK-----\n";
    private static final String BOB_KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: A0D2 F316 0F6B 2CE5 7A50  FF32 261E 5081 9736 C493\nComment: bob@pgpainless.org\n\nlFgEYksu1hYJKwYBBAHaRw8BAQdAXTBT1OKN1GAvGC+fzuy/k34BK+d5Saa87Glb\niQgIxg8AAPwMI5DGqADFfl6H3Nxj3NxEZLasiFDpwEszluLVRy0jihGbtBJib2JA\ncGdwYWlubGVzcy5vcmeIjwQTFgoAQQUCYksu1gkQJh5QgZc2xJMWIQSg0vMWD2ss\n5XpQ/zImHlCBlzbEkwKeAQKbAQUWAgMBAAQLCQgHBRUKCQgLApkBAADvrAD/cWBW\nmRkSfoCbEl22s59FXE7NPENrsJK8jxmWsWX3jbEA/AyXMCjwH6IhDgdgO7wH2z1r\ncUb/hokiCcCaJs6hjKcInF0EYksu1hIKKwYBBAGXVQEFAQEHQCeURSBi9brhisUH\nDz0xN1NCgU5yeirx53xrQDFFx+d6AwEIBwAA/1GHX9+4Rg0ePsXGm1QIWL+C4rdf\nAReCTYoS3EBiZVdADoyIdQQYFgoAHQUCYksu1gKeAQKbDAUWAgMBAAQLCQgHBRUK\nCQgLAAoJECYeUIGXNsST8c0A/1dEIO9gsFB15UWDlTzN3S0TXQNN8wVzIMdW7XP2\n7c6bAQCB5ChqQA9AB1020DLr28BAbSjI7mPdIWg2PpE7B1EXC5xYBGJLLtYWCSsG\nAQQB2kcPAQEHQKP5NxT0ZhmRbrl3S6uwrUN248g1TEUR0DCVuLgyGSLpAAEA6bMa\nGaUf3S55rkFDjFC4Cv72zc8E5ex2RKgbpxXxqhYQN4jVBBgWCgB9BQJiSy7WAp4B\nApsCBRYCAwEABAsJCAcFFQoJCAtfIAQZFgoABgUCYksu1gAKCRDJLjPCA2NIfylD\nAP4tNFV23FBlrC57iesHVc+TTfNJ8rd+U7mbJvUgykcSNAEAy64tKPuVj+aA1bpm\ngHxfqdEJCOko8UhVVP6ltiDUcAoACgkQJh5QgZc2xJP9TQEA1DNgFno3di+xGDEN\npwe9lmz8d/RWy/kuBT9S/3CMJjQBAKNBhHPuFfvk7RFbsmMrHsSqDFqIuUfGqq39\nVzmiMp8N\n=LpkJ\n-----END PGP PRIVATE KEY BLOCK-----\n";
    private static final String BOB_CERT = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: PGPainless\nComment: A0D2 F316 0F6B 2CE5 7A50  FF32 261E 5081 9736 C493\nComment: bob@pgpainless.org\n\nmDMEYksu1hYJKwYBBAHaRw8BAQdAXTBT1OKN1GAvGC+fzuy/k34BK+d5Saa87Glb\niQgIxg+0EmJvYkBwZ3BhaW5sZXNzLm9yZ4iPBBMWCgBBBQJiSy7WCRAmHlCBlzbE\nkxYhBKDS8xYPayzlelD/MiYeUIGXNsSTAp4BApsBBRYCAwEABAsJCAcFFQoJCAsC\nmQEAAO+sAP9xYFaZGRJ+gJsSXbazn0VcTs08Q2uwkryPGZaxZfeNsQD8DJcwKPAf\noiEOB2A7vAfbPWtxRv+GiSIJwJomzqGMpwi4OARiSy7WEgorBgEEAZdVAQUBAQdA\nJ5RFIGL1uuGKxQcPPTE3U0KBTnJ6KvHnfGtAMUXH53oDAQgHiHUEGBYKAB0FAmJL\nLtYCngECmwwFFgIDAQAECwkIBwUVCgkICwAKCRAmHlCBlzbEk/HNAP9XRCDvYLBQ\ndeVFg5U8zd0tE10DTfMFcyDHVu1z9u3OmwEAgeQoakAPQAddNtAy69vAQG0oyO5j\n3SFoNj6ROwdRFwu4MwRiSy7WFgkrBgEEAdpHDwEBB0Cj+TcU9GYZkW65d0ursK1D\nduPINUxFEdAwlbi4Mhki6YjVBBgWCgB9BQJiSy7WAp4BApsCBRYCAwEABAsJCAcF\nFQoJCAtfIAQZFgoABgUCYksu1gAKCRDJLjPCA2NIfylDAP4tNFV23FBlrC57iesH\nVc+TTfNJ8rd+U7mbJvUgykcSNAEAy64tKPuVj+aA1bpmgHxfqdEJCOko8UhVVP6l\ntiDUcAoACgkQJh5QgZc2xJP9TQEA1DNgFno3di+xGDENpwe9lmz8d/RWy/kuBT9S\n/3CMJjQBAKNBhHPuFfvk7RFbsmMrHsSqDFqIuUfGqq39VzmiMp8N\n=1MqZ\n-----END PGP PUBLIC KEY BLOCK-----\n";

    @Test
    public void encryptAndSignMessage() throws PGPException, IOException {
        PGPSecretKeyRing keyAlice = PGPainless.readKeyRing().secretKeyRing(ALICE_KEY);
        PGPPublicKeyRing certificateAlice = PGPainless.readKeyRing().publicKeyRing(ALICE_CERT);
        UnprotectedKeysProtector protectorAlice = SecretKeyRingProtector.unprotectedKeys();
        PGPSecretKeyRing keyBob = PGPainless.readKeyRing().secretKeyRing(BOB_KEY);
        PGPPublicKeyRing certificateBob = PGPainless.readKeyRing().publicKeyRing(BOB_CERT);
        UnprotectedKeysProtector protectorBob = SecretKeyRingProtector.unprotectedKeys();
        String message = "Hello, World!\n";
        ByteArrayOutputStream ciphertext = new ByteArrayOutputStream();
        EncryptionStream encryptor = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)ciphertext).withOptions(ProducerOptions.signAndEncrypt((EncryptionOptions)EncryptionOptions.encryptCommunications().addRecipient(certificateBob).addRecipient(certificateAlice), (SigningOptions)new SigningOptions().addInlineSignature((SecretKeyRingProtector)protectorAlice, keyAlice, DocumentSignatureType.CANONICAL_TEXT_DOCUMENT)).setAsciiArmor(true));
        Streams.pipeAll((InputStream)new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8)), (OutputStream)encryptor);
        encryptor.close();
        String encryptedMessage = ciphertext.toString();
        DecryptionStream decryptor = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(encryptedMessage.getBytes(StandardCharsets.UTF_8))).withOptions(new ConsumerOptions().addDecryptionKey(keyBob, (SecretKeyRingProtector)protectorBob).addVerificationCert(certificateAlice));
        ByteArrayOutputStream plaintext = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptor, (OutputStream)plaintext);
        decryptor.close();
        MessageMetadata metadata = decryptor.getMetadata();
        Assertions.assertTrue((boolean)metadata.isEncrypted());
        Assertions.assertTrue((boolean)metadata.isVerifiedSignedBy((PGPKeyRing)certificateAlice));
        Assertions.assertEquals((Object)message, (Object)plaintext.toString());
    }

    @Test
    public void encryptUsingPassphrase() throws PGPException, IOException {
        String message = "Hello, World!";
        ByteArrayOutputStream ciphertext = new ByteArrayOutputStream();
        EncryptionStream encryptor = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)ciphertext).withOptions(ProducerOptions.encrypt((EncryptionOptions)EncryptionOptions.encryptCommunications().addMessagePassphrase(Passphrase.fromPassword((CharSequence)"p4ssphr4s3"))).setAsciiArmor(true));
        Streams.pipeAll((InputStream)new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8)), (OutputStream)encryptor);
        encryptor.close();
        String asciiCiphertext = ciphertext.toString();
        DecryptionStream decryptor = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(asciiCiphertext.getBytes(StandardCharsets.UTF_8))).withOptions(new ConsumerOptions().addMessagePassphrase(Passphrase.fromPassword((CharSequence)"p4ssphr4s3")));
        ByteArrayOutputStream plaintext = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptor, (OutputStream)plaintext);
        decryptor.close();
        Assertions.assertEquals((Object)message, (Object)plaintext.toString());
    }

    @Test
    public void encryptWithCommentHeader() throws PGPException, IOException {
        PGPPublicKeyRing certificateAlice = PGPainless.readKeyRing().publicKeyRing(ALICE_CERT);
        PGPSecretKeyRing keyBob = PGPainless.readKeyRing().secretKeyRing(BOB_KEY);
        PGPPublicKeyRing certificateBob = PGPainless.readKeyRing().publicKeyRing(BOB_CERT);
        UnprotectedKeysProtector protectorBob = SecretKeyRingProtector.unprotectedKeys();
        String message = "Hello, World!\n";
        String[] comments = new String[]{"This comment was added using options.", "And it has three lines.", " ", "Empty lines are skipped."};
        String comment = comments[0] + "\n" + comments[1] + "\n" + comments[2] + "\n" + comments[3];
        ByteArrayOutputStream ciphertext = new ByteArrayOutputStream();
        EncryptionStream encryptor = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)ciphertext).withOptions(ProducerOptions.encrypt((EncryptionOptions)EncryptionOptions.encryptCommunications().addRecipient(certificateBob).addRecipient(certificateAlice)).setAsciiArmor(true).setComment(comment));
        Streams.pipeAll((InputStream)new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8)), (OutputStream)encryptor);
        encryptor.close();
        String encryptedMessage = ciphertext.toString();
        Assertions.assertEquals((Object)encryptedMessage.split("\n")[2].trim(), (Object)("Comment: " + comments[0]));
        Assertions.assertEquals((Object)encryptedMessage.split("\n")[3].trim(), (Object)("Comment: " + comments[1]));
        Assertions.assertEquals((Object)encryptedMessage.split("\n")[4].trim(), (Object)("Comment: " + comments[3]));
        DecryptionStream decryptor = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(encryptedMessage.getBytes(StandardCharsets.UTF_8))).withOptions(new ConsumerOptions().addDecryptionKey(keyBob, (SecretKeyRingProtector)protectorBob).addVerificationCert(certificateAlice));
        ByteArrayOutputStream plaintext = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptor, (OutputStream)plaintext);
        decryptor.close();
        MessageMetadata metadata = decryptor.getMetadata();
        Assertions.assertTrue((boolean)metadata.isEncrypted());
        Assertions.assertEquals((Object)message, (Object)plaintext.toString());
    }
}

