/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.collection;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.collection.PGPKeyRingCollection;
import org.pgpainless.key.util.KeyRingUtils;

public class PGPKeyRingCollectionTest {
    @Test
    public void constructorThrowsForInvalidInput() throws PGPException, IOException {
        String invalidKeyRing = "-----BEGIN PGP SIGNATURE-----\n\nwsE7BAABCABlBYJgv4U3RxQAAAAAAB4AIHNhbHRAbm90YXRpb25zLnNlcXVvaWEt\ncGdwLm9yZyPTSDcCaeqXuP6nWREE/C94XG6ABwpIlZHM08WewmWgFiEE0aZuGiOx\ngsmYD3iM+/zIKgFeczAACgkQ+/zIKgFeczBdoQv+MqOUYG+LA0Sa6P/827ILn9lW\n4IQJZVBo/ssvIU0Q8GjvCl4c/kRf+VKSprfkBz+q+vjHI1Ob0rW8amuTvvlSzBQX\n6Kb20ahvRYDo445Twuo+/rnp+j5PdRpYITY665AhdwfHSYoEEMhqrEDSQGT8O2xO\n1115FJEJaepomY4K9rv2pI8+pX9jOht7sCBK/qkTy/8RC22VyYWoPLSpxldzOBAK\n/AcuVCXFGfBt6ybRDXKJJduOVDQ5UFCoC71tq4ah7YmwIMD+/cXYPd+0Xg66U8Eq\n3F9MPYCzDYwnhEYZPuHODucHXZ0xpiFRlRkVMZT//+3b4NdOONRf/8sz9YUIMNxB\nU2qrEUnByfz3k1ZdkNwn40jYYWHp7hxVmaIDN3v+o5lZfzrKLTWU6wZThZL2FQlf\nSqGzjkxOW/c5OcO/EtCUNwIATpou32d1srfK0wGy2ar/o40yezukr5DLTo6B67Hq\nZ0D2bD+77247LmD4iuHMHxTI3yv2J+ecfM11Ejir\n=pQWH\n-----END PGP SIGNATURE-----\n";
        byte[] bytes = invalidKeyRing.getBytes(StandardCharsets.UTF_8);
        Assertions.assertThrows(PGPException.class, () -> new PGPKeyRingCollection(bytes, false));
        PGPKeyRingCollection collection = new PGPKeyRingCollection(bytes, true);
        Assertions.assertEquals((int)0, (int)collection.getPgpPublicKeyRingCollection().size());
        Assertions.assertEquals((int)0, (int)collection.getPgpSecretKeyRingCollection().size());
    }

    @Test
    public void testConstructorFromCollection() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing first = PGPainless.generateKeyRing().simpleEcKeyRing((CharSequence)"alice@wonderland.lit");
        PGPSecretKeyRing second = PGPainless.generateKeyRing().simpleEcKeyRing((CharSequence)"bob@the-builder.tv");
        PGPPublicKeyRing secondPub = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)second);
        List<PGPKeyRing> keys = Arrays.asList(first, second, secondPub);
        PGPKeyRingCollection collection = new PGPKeyRingCollection(keys, true);
        Assertions.assertEquals((int)2, (int)collection.getPgpSecretKeyRingCollection().size());
        Assertions.assertEquals((int)1, (int)collection.getPgpPublicKeyRingCollection().size());
    }
}

