/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.NoSuchElementException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.util.selection.userid.SelectUserId;

public class RevokeUserIdsTest {
    @Test
    public void revokeWithSelectUserId() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice <alice@pgpainless.org>");
        UnprotectedKeysProtector protector = SecretKeyRingProtector.unprotectedKeys();
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addUserId((CharSequence)"Allice <alice@example.org>", (SecretKeyRingProtector)protector).addUserId((CharSequence)"Alice <alice@example.org>", (SecretKeyRingProtector)protector).done();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertTrue((boolean)info.isUserIdValid((CharSequence)"Alice <alice@pgpainless.org>"));
        Assertions.assertTrue((boolean)info.isUserIdValid((CharSequence)"Allice <alice@example.org>"));
        Assertions.assertTrue((boolean)info.isUserIdValid((CharSequence)"Alice <alice@example.org>"));
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revokeUserIds(SelectUserId.containsEmailAddress((CharSequence)"alice@example.org"), (SecretKeyRingProtector)protector, RevocationAttributes.createCertificateRevocation().withReason(RevocationAttributes.Reason.USER_ID_NO_LONGER_VALID).withoutDescription()).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertTrue((boolean)info.isUserIdValid((CharSequence)"Alice <alice@pgpainless.org>"));
        Assertions.assertFalse((boolean)info.isUserIdValid((CharSequence)"Allice <alice@example.org>"));
        Assertions.assertFalse((boolean)info.isUserIdValid((CharSequence)"Alice <alice@example.org>"));
    }

    @Test
    public void removeUserId() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice <alice@pgpainless.org>");
        UnprotectedKeysProtector protector = SecretKeyRingProtector.unprotectedKeys();
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addUserId((CharSequence)"Allice <alice@example.org>", (SecretKeyRingProtector)protector).addUserId((CharSequence)"Alice <alice@example.org>", (SecretKeyRingProtector)protector).done();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertTrue((boolean)info.isUserIdValid((CharSequence)"Alice <alice@pgpainless.org>"));
        Assertions.assertTrue((boolean)info.isUserIdValid((CharSequence)"Allice <alice@example.org>"));
        Assertions.assertTrue((boolean)info.isUserIdValid((CharSequence)"Alice <alice@example.org>"));
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).removeUserId((CharSequence)"Allice <alice@example.org>", (SecretKeyRingProtector)protector).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertTrue((boolean)info.isUserIdValid((CharSequence)"Alice <alice@pgpainless.org>"));
        Assertions.assertFalse((boolean)info.isUserIdValid((CharSequence)"Allice <alice@example.org>"));
        Assertions.assertTrue((boolean)info.isUserIdValid((CharSequence)"Alice <alice@example.org>"));
        PGPSignature revocation = info.getUserIdRevocation((CharSequence)"Allice <alice@example.org>");
        Assertions.assertNotNull((Object)revocation);
        Assertions.assertFalse((boolean)RevocationAttributes.Reason.isHardRevocation((byte)revocation.getHashedSubPackets().getRevocationReason().getRevocationReason()));
    }

    @Test
    public void emptySelectionYieldsNoSuchElementException() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice <alice@pgpainless.org>");
        Assertions.assertThrows(NoSuchElementException.class, () -> PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revokeUserIds(SelectUserId.containsEmailAddress((CharSequence)"alice@example.org"), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys(), (RevocationAttributes)null));
    }
}

