/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.parsing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.MarkerPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.TestAbortedException;
import org.pgpainless.PGPainless;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.collection.PGPKeyRingCollection;
import org.pgpainless.key.parsing.KeyRingReader;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.util.ArmoredOutputStreamFactory;
import org.pgpainless.util.TestUtils;

class KeyRingReaderTest {
    KeyRingReaderTest() {
    }

    private InputStream requireResource(String resourceName) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
        if (inputStream == null) {
            throw new TestAbortedException("Cannot read resource " + resourceName + ": InputStream is null.");
        }
        return inputStream;
    }

    private byte[] readFromResource(String resourceName) throws IOException {
        InputStream inputStream = this.requireResource(resourceName);
        return Streams.readAll((InputStream)inputStream);
    }

    @Test
    public void assertThatPGPUtilsDetectAsciiArmoredData() throws IOException, PGPException {
        InputStream inputStream = this.requireResource("pub_keys_10_pieces.asc");
        InputStream possiblyArmored = PGPUtil.getDecoderStream((InputStream)PGPUtil.getDecoderStream((InputStream)inputStream));
        PGPPublicKeyRingCollection collection = new PGPPublicKeyRingCollection(possiblyArmored, ImplementationFactory.getInstance().getKeyFingerprintCalculator());
        Assertions.assertEquals((int)10, (int)collection.size());
    }

    @Test
    void publicKeyRingCollectionFromStream() throws IOException, PGPException {
        InputStream inputStream = this.requireResource("pub_keys_10_pieces.asc");
        PGPPublicKeyRingCollection rings = PGPainless.readKeyRing().publicKeyRingCollection(inputStream);
        Assertions.assertEquals((int)10, (int)rings.size());
    }

    @Test
    void publicKeyRingCollectionFromNotArmoredStream() throws IOException, PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        ArrayList<PGPPublicKeyRing> collection = new ArrayList<PGPPublicKeyRing>();
        for (int i = 0; i < 10; ++i) {
            PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing((CharSequence)("user_" + i + "@encrypted.key"));
            collection.add(KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)secretKeys));
        }
        PGPPublicKeyRingCollection originalRings = new PGPPublicKeyRingCollection(collection);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        originalRings.encode((OutputStream)out);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(out.toByteArray());
        PGPPublicKeyRingCollection parsedRings = PGPainless.readKeyRing().publicKeyRingCollection((InputStream)inputStream);
        Assertions.assertEquals((int)10, (int)parsedRings.size());
    }

    @Test
    void publicKeyRingCollectionFromString() throws IOException, PGPException {
        String armoredString = new String(this.readFromResource("pub_keys_10_pieces.asc"));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(armoredString.getBytes(StandardCharsets.UTF_8));
        PGPPublicKeyRingCollection rings = PGPainless.readKeyRing().publicKeyRingCollection((InputStream)inputStream);
        Assertions.assertEquals((int)10, (int)rings.size());
    }

    @Test
    void publicKeyRingCollectionFromBytes() throws IOException, PGPException {
        byte[] bytes = this.readFromResource("pub_keys_10_pieces.asc");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        PGPPublicKeyRingCollection rings = PGPainless.readKeyRing().publicKeyRingCollection((InputStream)byteArrayInputStream);
        Assertions.assertEquals((int)10, (int)rings.size());
    }

    @Test
    void parsePublicKeysSingleArmored() throws IOException, PGPException {
        Assertions.assertEquals((int)1, (int)this.getPgpPublicKeyRingsFromResource("single_pub_key_armored.asc").size());
    }

    @Test
    void parsePublicKeysSingleBinary() throws IOException, PGPException {
        Assertions.assertEquals((int)1, (int)this.getPgpPublicKeyRingsFromResource("single_pub_key_binary.key").size());
    }

    @Test
    void parsePublicKeysMultiplyArmoredSingleHeader() throws IOException, PGPException {
        Assertions.assertEquals((int)10, (int)this.getPgpPublicKeyRingsFromResource("10_pub_keys_armored_single_header.asc").size());
    }

    @Test
    void parsePublicKeysMultiplyArmoredOwnHeader() throws IOException, PGPException {
        Assertions.assertEquals((int)10, (int)this.getPgpPublicKeyRingsFromResource("10_pub_keys_armored_own_header.asc").size());
    }

    @Test
    void parsePublicKeysMultiplyArmoredOwnWithSingleHeader() throws IOException, PGPException {
        Assertions.assertEquals((int)10, (int)this.getPgpPublicKeyRingsFromResource("10_pub_keys_armored_own_with_single_header.asc").size());
    }

    @Test
    void parsePublicKeysMultiplyBinary() throws IOException, PGPException {
        Assertions.assertEquals((int)10, (int)this.getPgpPublicKeyRingsFromResource("10_pub_keys_binary.key").size());
    }

    @Test
    void parseSecretKeysSingleArmored() throws IOException, PGPException {
        Assertions.assertEquals((int)1, (int)this.getPgpSecretKeyRingsFromResource("single_prv_key_armored.asc").size());
    }

    @Test
    void parseSecretKeysSingleBinary() throws IOException, PGPException {
        Assertions.assertEquals((int)1, (int)this.getPgpSecretKeyRingsFromResource("single_prv_key_binary.key").size());
    }

    @Test
    void parseSecretKeysMultiplyArmoredSingleHeader() throws IOException, PGPException {
        Assertions.assertEquals((int)10, (int)this.getPgpSecretKeyRingsFromResource("10_prv_keys_armored_single_header.asc").size());
    }

    @Test
    void parseSecretKeysMultiplyArmoredOwnHeader() throws IOException, PGPException {
        Assertions.assertEquals((int)10, (int)this.getPgpSecretKeyRingsFromResource("10_prv_keys_armored_own_header.asc").size());
    }

    @Test
    void parseSecretKeysMultiplyArmoredOwnWithSingleHeader() throws IOException, PGPException {
        Assertions.assertEquals((int)10, (int)this.getPgpSecretKeyRingsFromResource("10_prv_keys_armored_own_with_single_header.asc").size());
    }

    @Test
    void parseSecretKeysMultiplyBinary() throws IOException, PGPException {
        Assertions.assertEquals((int)10, (int)this.getPgpSecretKeyRingsFromResource("10_prv_keys_binary.key").size());
    }

    @Test
    void parseKeysMultiplyArmoredOwnHeader() throws IOException, PGPException {
        Assertions.assertEquals((int)10, (int)this.getPGPKeyRingsFromResource("10_prv_and_pub_keys_armored_own_header.asc").size());
    }

    @Test
    void parseKeysMultiplyArmoredOwnWithSingleHeader() throws IOException, PGPException {
        Assertions.assertEquals((int)10, (int)this.getPGPKeyRingsFromResource("10_prv_and_pub_keys_armored_own_with_single_header.asc").size());
    }

    @Test
    void parseKeysMultiplyBinary() throws IOException, PGPException {
        Assertions.assertEquals((int)10, (int)this.getPGPKeyRingsFromResource("10_prv_and_pub_keys_binary.key").size());
    }

    private PGPKeyRingCollection getPGPKeyRingsFromResource(String fileName) throws IOException, PGPException {
        return PGPainless.readKeyRing().keyRingCollection(this.requireResource(fileName), true);
    }

    private PGPPublicKeyRingCollection getPgpPublicKeyRingsFromResource(String fileName) throws IOException, PGPException {
        return PGPainless.readKeyRing().publicKeyRingCollection(this.requireResource(fileName));
    }

    private PGPSecretKeyRingCollection getPgpSecretKeyRingsFromResource(String fileName) throws IOException, PGPException {
        return PGPainless.readKeyRing().secretKeyRingCollection(this.requireResource(fileName));
    }

    @Test
    public void testReadSecretKeyIgnoresMarkerPacket() throws IOException {
        String markerAndKey = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: Secret Key with prepended Marker Packet\n\nqANQR1CUWARg6WWBFgkrBgEEAdpHDwEBB0AyPTMeZL9XZtTedc9j8uX6igs+ZPGX\nKfJGSem/zCxrogABAMAXMTtEsEXDd90tgD2oasEQ9NNDKsHIxStLbhbu/W0GDzu0\nFGFsaWNlQHBncGFpbmxlc3Mub3JniHgEExYKACAFAmDpZYECGwEFFgIDAQAECwkI\nBwUVCgkICwIeAQIZAQAKCRBzXl6xxUHAzuckAP9j7FYdXB4y1G+qC8PxRWygnDLC\n3bgoJr+8mSBw8oGGowD/akhhuiU/EIFIG0A+kATN92AlJYLbq73sKF+1pIpPcA6c\nXQRg6WWBEgorBgEEAZdVAQUBAQdA1RexkLKsWJtxG82lsiaBpiUzjayFFlEpHhZv\nNemY+gQDAQgHAAD/ZluthWe9mBdbJxkq3+XGK3EBvFCSkTqEjAOeZpYRgOAPOIh1\nBBgWCgAdBQJg6WWBAhsMBRYCAwEABAsJCAcFFQoJCAsCHgEACgkQc15escVBwM4U\nHwEAjTd22074lQ4EsL/g6P6wVSrdIfxF6Sgx5652uKD2Cx0A/iR+3R1XlQd9+64G\nBDgLpvi4qox59RoXyLDZ1TDtnGQFnFgEYOllgRYJKwYBBAHaRw8BAQdA7+NE2Y83\nwoDWXUIPQANQcskNOcwUU9hDw+qXxhCysesAAQDSgvEGDhoXcs8bJFrsTDrxugyl\ne1QRBde52d4PZfxOHw48iNUEGBYKAH0FAmDpZYECGwIFFgIDAQAECwkIBwUVCgkI\nCwIeAV8gBBkWCgAGBQJg6WWBAAoJEAZefiHacdJCCKYA/j+8mNlLNfeoBKx3vDxq\nPWB3C0n/RZdeV4pz3EsT46MyAP9fCBzLADQeSwNv4BCWl5EGv6YMlg0+S1Q0A3Cn\nlrtBCwAKCRBzXl6xxUHAzn9hAQCdTCa8P3aE8jbUav/eCSLsr5+ELi4ODg5ZAZaN\nGlNPVAD/byyQfgQgtxrdf7sHBEg2+CCEtac6vvTyq6o9ndW3owg=\n=9jtR\n-----END PGP PRIVATE KEY BLOCK-----";
        PGPSecretKeyRing secretKey = PGPainless.readKeyRing().secretKeyRing(markerAndKey);
        Assertions.assertEquals((Object)new OpenPgpV4Fingerprint("562584F8730F39FCB02AACAE735E5EB1C541C0CE"), (Object)new OpenPgpV4Fingerprint((PGPKeyRing)secretKey));
    }

    @Test
    public void testReadCertificateIgnoresMarkerPacket() throws IOException {
        String markerAndCert = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: PGPainless\nComment: Certificate with prepended Marker Packet\n\nqANQR1CYMwRg6WcmFgkrBgEEAdpHDwEBB0D33FQiRhS7lvYXVxYqHK5iFiXE9dO0\nrdNZ8i/YCVquLbQUYWxpY2VAcGdwYWlubGVzcy5vcmeIeAQTFgoAIAUCYOlnJgIb\nAQUWAgMBAAQLCQgHBRUKCQgLAh4BAhkBAAoJEPbyu9T10peTttsBAKYt4qWIcf+U\nJ8rceVKr8WrbTbmYcMI948QKASqOmHQUAP0cBgIvJiTV6VPCzrr6y4DctgC2KmL2\nWLUVB5oKTVpnB7g4BGDpZyYSCisGAQQBl1UBBQEBB0CbvjPN9vqxth2ICQ2C8TEf\nVkSY44EghL9bs0aYfio1fgMBCAeIdQQYFgoAHQUCYOlnJgIbDAUWAgMBAAQLCQgH\nBRUKCQgLAh4BAAoJEPbyu9T10peTJCQBAIkIfsgWjvc1lBHjoqK1TG0uO2bR3+2x\n2fO2sB8s4ulAAQD/U5SWyx+2vw0Oi1GV6Do4xNKivJuNU5UgcbJj1SF+B7gzBGDp\nZyYWCSsGAQQB2kcPAQEHQJbuNdOUc35ZOo6+8cYuV+d+Gu+AZIhkA7zFsyLMrGsC\niNUEGBYKAH0FAmDpZyYCGwIFFgIDAQAECwkIBwUVCgkICwIeAV8gBBkWCgAGBQJg\n6WcmAAoJEAqPm07pCscSwX8BAJkVbDWA6FBHVqmU9Iis+ZeQpolmeRdyuKm6AkYp\nZ1jLAP9/MNtKOsbAvL1c7YXomytJAzgbx1hxWfFlD5rGSVuUBAAKCRD28rvU9dKX\nkxnQAQCe6sgVoCIWw2nFwlEBnwEH4OIsRya79mBps6UZPv8g9QD+K8imuYR9zOwT\nsFrPBVJ6f5HPPBEeQKMS0DBcg0NE3g4=\n=6XFh\n-----END PGP PUBLIC KEY BLOCK-----\n";
        PGPPublicKeyRing certificate = PGPainless.readKeyRing().publicKeyRing(markerAndCert);
        Assertions.assertEquals((Object)new OpenPgpV4Fingerprint("4291C2BEF9B9209DF11128E7F6F2BBD4F5D29793"), (Object)new OpenPgpV4Fingerprint((PGPKeyRing)certificate));
    }

    @Test
    public void testReadSecretKeyCollectionIgnoresMarkerPackets() throws PGPException, IOException {
        String markersAndKeys = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: Secret Keys with injected Marker Packets\n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\nErE+7aqGe7NeySfX+Dq2JQ2oA1BHUA==\n=Jgh3\n-----END PGP PRIVATE KEY BLOCK-----";
        PGPSecretKeyRingCollection secretKeys = PGPainless.readKeyRing().secretKeyRingCollection(markersAndKeys);
        Assertions.assertEquals((int)3, (int)secretKeys.size());
    }

    @Test
    public void testReadCertificateCollectionIgnoresMarkerPackets() throws PGPException, IOException {
        String markersAndCerts = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: PGPainless\nComment: Certificates with injected Marker Packets\n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\nr1zIt4pkvfxrlrxvxlk80IqcTsYMqANQR1A=\n=aWCj\n-----END PGP PUBLIC KEY BLOCK-----\n";
        PGPPublicKeyRingCollection certificates = PGPainless.readKeyRing().publicKeyRingCollection(markersAndCerts);
        Assertions.assertEquals((int)3, (int)certificates.size());
    }

    @Test
    public void testReadSignatureIgnoresMarkerPacket() throws PGPException, IOException {
        String markerAndSignature = "-----BEGIN PGP SIGNATURE-----\nVersion: PGPainless\nComment: Signature with prepended Marker Packet\n\nqANQR1CIeAQTFgoAIAUCYOlqZgIbAQUWAgMBAAQLCQgHBRUKCQgLAh4BAhkBAAoJ\nEAJI18O3wl3pF3AA/3PcUODYUYfaFtwOjhRnbSVJDpRf271yNGkbuRPI9q7vAQCo\nnqxxfvd9VxfZCrdZc5gCbIxVUnbuBL2fjBqIoYQkDQ==\n=S1jF\n-----END PGP SIGNATURE-----";
        List signatureList = SignatureUtils.readSignatures((String)markerAndSignature);
        Assertions.assertEquals((int)1, (int)signatureList.size());
    }

    @Test
    public void testReadSecretKeysIgnoresMultipleMarkers() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        int i;
        PGPSecretKeyRing alice = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"alice@pgpainless.org");
        PGPSecretKeyRing bob = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"bob@pgpainless.org");
        MarkerPacket marker = TestUtils.getMarkerPacket();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ArmoredOutputStream armor = ArmoredOutputStreamFactory.get((OutputStream)bytes);
        armor.setHeader("Comment", "Secret Keys and an absurd amount of markers");
        BCPGOutputStream outputStream = new BCPGOutputStream((OutputStream)armor);
        for (i = 0; i < 25; ++i) {
            marker.encode(outputStream);
        }
        alice.encode((OutputStream)outputStream);
        for (i = 0; i < 53; ++i) {
            marker.encode(outputStream);
        }
        bob.encode((OutputStream)outputStream);
        for (i = 0; i < 102; ++i) {
            marker.encode(outputStream);
        }
        outputStream.close();
        armor.close();
        String armoredMess = bytes.toString();
        PGPSecretKeyRingCollection secretKeys = PGPainless.readKeyRing().secretKeyRingCollection(armoredMess);
        Assertions.assertEquals((int)2, (int)secretKeys.size());
        Assertions.assertTrue((boolean)secretKeys.contains(alice.getSecretKey().getKeyID()));
        Assertions.assertTrue((boolean)secretKeys.contains(bob.getSecretKey().getKeyID()));
    }

    @Test
    public void testReadingSecretKeysExceedsIterationLimit() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing alice = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"alice@pgpainless.org");
        MarkerPacket marker = TestUtils.getMarkerPacket();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ArmoredOutputStream armor = ArmoredOutputStreamFactory.get((OutputStream)bytes);
        BCPGOutputStream outputStream = new BCPGOutputStream((OutputStream)armor);
        for (int i = 0; i < 600; ++i) {
            marker.encode(outputStream);
        }
        alice.encode((OutputStream)outputStream);
        Assertions.assertThrows(IOException.class, () -> KeyRingReader.readSecretKeyRing((InputStream)new ByteArrayInputStream(bytes.toByteArray()), (int)512));
    }

    @Test
    public void testReadingSecretKeyCollectionExceedsIterationLimit() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing alice = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"alice@pgpainless.org");
        PGPSecretKeyRing bob = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"bob@pgpainless.org");
        MarkerPacket marker = TestUtils.getMarkerPacket();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ArmoredOutputStream armor = ArmoredOutputStreamFactory.get((OutputStream)bytes);
        BCPGOutputStream outputStream = new BCPGOutputStream((OutputStream)armor);
        for (int i = 0; i < 600; ++i) {
            marker.encode(outputStream);
        }
        alice.encode((OutputStream)outputStream);
        bob.encode((OutputStream)outputStream);
        Assertions.assertThrows(IOException.class, () -> KeyRingReader.readSecretKeyRingCollection((InputStream)new ByteArrayInputStream(bytes.toByteArray()), (int)512));
    }

    @Test
    public void testReadingPublicKeysExceedsIterationLimit() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"alice@pgpainless.org");
        PGPPublicKeyRing alice = PGPainless.extractCertificate((PGPSecretKeyRing)secretKeys);
        MarkerPacket marker = TestUtils.getMarkerPacket();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ArmoredOutputStream armor = ArmoredOutputStreamFactory.get((OutputStream)bytes);
        BCPGOutputStream outputStream = new BCPGOutputStream((OutputStream)armor);
        for (int i = 0; i < 600; ++i) {
            marker.encode(outputStream);
        }
        alice.encode((OutputStream)outputStream);
        Assertions.assertThrows(IOException.class, () -> KeyRingReader.readPublicKeyRing((InputStream)new ByteArrayInputStream(bytes.toByteArray()), (int)512));
    }

    @Test
    public void testReadingPublicKeyCollectionExceedsIterationLimit() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing sec1 = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"alice@pgpainless.org");
        PGPSecretKeyRing sec2 = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"bob@pgpainless.org");
        PGPPublicKeyRing alice = PGPainless.extractCertificate((PGPSecretKeyRing)sec1);
        PGPPublicKeyRing bob = PGPainless.extractCertificate((PGPSecretKeyRing)sec2);
        MarkerPacket marker = TestUtils.getMarkerPacket();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ArmoredOutputStream armor = ArmoredOutputStreamFactory.get((OutputStream)bytes);
        BCPGOutputStream outputStream = new BCPGOutputStream((OutputStream)armor);
        for (int i = 0; i < 600; ++i) {
            marker.encode(outputStream);
        }
        alice.encode((OutputStream)outputStream);
        bob.encode((OutputStream)outputStream);
        Assertions.assertThrows(IOException.class, () -> KeyRingReader.readPublicKeyRingCollection((InputStream)new ByteArrayInputStream(bytes.toByteArray()), (int)512));
    }

    @Test
    public void testReadKeyRingWithBinaryPublicKey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice <alice@pgpainless.org>");
        PGPPublicKeyRing publicKeys = PGPainless.extractCertificate((PGPSecretKeyRing)secretKeys);
        byte[] bytes = publicKeys.getEncoded();
        PGPKeyRing keyRing = PGPainless.readKeyRing().keyRing(bytes);
        Assertions.assertTrue((boolean)(keyRing instanceof PGPPublicKeyRing));
        Assertions.assertArrayEquals((byte[])keyRing.getEncoded(), (byte[])publicKeys.getEncoded());
    }

    @Test
    public void testReadKeyRingWithBinarySecretKey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice <alice@pgpainless.org>");
        byte[] bytes = secretKeys.getEncoded();
        PGPKeyRing keyRing = PGPainless.readKeyRing().keyRing(bytes);
        Assertions.assertTrue((boolean)(keyRing instanceof PGPSecretKeyRing));
        Assertions.assertArrayEquals((byte[])keyRing.getEncoded(), (byte[])secretKeys.getEncoded());
    }

    @Test
    public void testReadKeyRingWithArmoredPublicKey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice <alice@pgpainless.org>");
        PGPPublicKeyRing publicKeys = PGPainless.extractCertificate((PGPSecretKeyRing)secretKeys);
        String armored = PGPainless.asciiArmor((PGPKeyRing)publicKeys);
        PGPKeyRing keyRing = PGPainless.readKeyRing().keyRing(armored);
        Assertions.assertTrue((boolean)(keyRing instanceof PGPPublicKeyRing));
        Assertions.assertArrayEquals((byte[])keyRing.getEncoded(), (byte[])publicKeys.getEncoded());
    }

    @Test
    public void testReadKeyRingWithArmoredSecretKey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice <alice@pgpainless.org>");
        String armored = PGPainless.asciiArmor((PGPKeyRing)secretKeys);
        PGPKeyRing keyRing = PGPainless.readKeyRing().keyRing(armored);
        Assertions.assertTrue((boolean)(keyRing instanceof PGPSecretKeyRing));
        Assertions.assertArrayEquals((byte[])keyRing.getEncoded(), (byte[])secretKeys.getEncoded());
    }
}

