/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.util;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.key.util.KeyIdUtil;

public class KeyIdUtilTest {
    @Test
    public void testParsing() {
        String longKeyId = "b1bd1f049ec87f3d";
        long asLong = KeyIdUtil.fromLongKeyId((String)longKeyId);
        Assertions.assertEquals((long)-5639317053693722819L, (long)asLong);
        Assertions.assertEquals((Object)longKeyId.toUpperCase(), (Object)KeyIdUtil.formatKeyId((long)-5639317053693722819L));
    }

    @Test
    public void testParsingLowerAndUppercase() {
        long fromLower = KeyIdUtil.fromLongKeyId((String)"f5ffdf6d71dd5789");
        Assertions.assertEquals((long)-720611754201229431L, (long)fromLower);
        long fromUpper = KeyIdUtil.fromLongKeyId((String)"F5FFDF6D71DD5789");
        Assertions.assertEquals((long)-720611754201229431L, (long)fromUpper);
    }

    @Test
    public void formatLowerAsUpper() {
        Assertions.assertEquals((Object)"5F04ACF44FD822B1", (Object)KeyIdUtil.formatKeyId((long)KeyIdUtil.fromLongKeyId((String)"5f04acf44fd822b1")));
    }

    @Test
    public void testParsing0() {
        long asLong = 0L;
        String formatted = KeyIdUtil.formatKeyId((long)asLong);
        Assertions.assertEquals((Object)"0000000000000000", (Object)formatted);
        Assertions.assertEquals((long)asLong, (long)KeyIdUtil.fromLongKeyId((String)"0000000000000000"));
    }
}

