/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.policy;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.policy.Policy;

public class PolicySetterTest {
    @Test
    public void testSetCertificationSignatureHashAlgorithmPolicy_NullFails() {
        Policy policy = Policy.getInstance();
        Assertions.assertThrows(NullPointerException.class, () -> policy.setCertificationSignatureHashAlgorithmPolicy(null));
    }

    @Test
    public void testSetDataSignatureHashAlgorithmPolicy_NullFails() {
        Policy policy = Policy.getInstance();
        Assertions.assertThrows(NullPointerException.class, () -> policy.setDataSignatureHashAlgorithmPolicy(null));
    }

    @Test
    public void testSetRevocationSignatureHashAlgorithmPolicy_NullFails() {
        Policy policy = Policy.getInstance();
        Assertions.assertThrows(NullPointerException.class, () -> policy.setRevocationSignatureHashAlgorithmPolicy(null));
    }

    @Test
    public void testSetSymmetricKeyEncryptionAlgorithmPolicy_NullFails() {
        Policy policy = Policy.getInstance();
        Assertions.assertThrows(NullPointerException.class, () -> policy.setSymmetricKeyEncryptionAlgorithmPolicy(null));
    }

    @Test
    public void testSetSymmetricKeyDecryptionAlgorithmPolicy_NullFails() {
        Policy policy = Policy.getInstance();
        Assertions.assertThrows(NullPointerException.class, () -> policy.setSymmetricKeyDecryptionAlgorithmPolicy(null));
    }

    @Test
    public void testSetCompressionAlgorithmPolicy_NullFails() {
        Policy policy = Policy.getInstance();
        Assertions.assertThrows(NullPointerException.class, () -> policy.setCompressionAlgorithmPolicy(null));
    }

    @Test
    public void testSetPublicKeyAlgorithmPolicy_NullFails() {
        Policy policy = Policy.getInstance();
        Assertions.assertThrows(NullPointerException.class, () -> policy.setPublicKeyAlgorithmPolicy(null));
    }

    @Test
    public void testNonRegisteredPublicKeyAlgorithm() {
        Policy policy = new Policy();
        HashMap<PublicKeyAlgorithm, Integer> acceptableAlgorithms = new HashMap<PublicKeyAlgorithm, Integer>();
        acceptableAlgorithms.put(PublicKeyAlgorithm.RSA_GENERAL, 2000);
        policy.setPublicKeyAlgorithmPolicy(new Policy.PublicKeyAlgorithmPolicy(acceptableAlgorithms));
        Assertions.assertFalse((boolean)policy.getPublicKeyAlgorithmPolicy().isAcceptable(PublicKeyAlgorithm.ECDSA, 256));
    }
}

