/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa_legacy.EdDSALegacyCurve;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.generation.type.xdh_legacy.XDHLegacySpec;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\"\u0010\u000b\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ$\u0010\u000b\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\u000e\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001c\u0010\u000e\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\"\u0010\u000f\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ$\u0010\u000f\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u0010"}, d2={"Lorg/pgpainless/key/generation/KeyRingTemplates;", "", "()V", "modernKeyRing", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "userId", "", "password", "", "passphrase", "Lorg/pgpainless/util/Passphrase;", "rsaKeyRing", "length", "Lorg/pgpainless/key/generation/type/rsa/RsaLength;", "simpleEcKeyRing", "simpleRsaKeyRing", "pgpainless-core"})
public final class KeyRingTemplates {
    @JvmOverloads
    @NotNull
    public final PGPSecretKeyRing rsaKeyRing(@Nullable CharSequence userId, @NotNull RsaLength length, @NotNull Passphrase passphrase) {
        KeyRingBuilder keyRingBuilder;
        Intrinsics.checkNotNullParameter((Object)length, (String)"length");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        KeyRingBuilder $this$rsaKeyRing_u24lambda_u240 = keyRingBuilder = PGPainless.Companion.buildKeyRing();
        boolean bl = false;
        KeyFlag[] keyFlagArray = new KeyFlag[]{KeyFlag.CERTIFY_OTHER};
        $this$rsaKeyRing_u24lambda_u240.setPrimaryKey(KeySpec.Companion.getBuilder(KeyType.Companion.RSA(length), keyFlagArray));
        keyFlagArray = new KeyFlag[]{KeyFlag.SIGN_DATA};
        $this$rsaKeyRing_u24lambda_u240.addSubkey(KeySpec.Companion.getBuilder(KeyType.Companion.RSA(length), keyFlagArray));
        keyFlagArray = new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE};
        $this$rsaKeyRing_u24lambda_u240.addSubkey(KeySpec.Companion.getBuilder(KeyType.Companion.RSA(length), keyFlagArray));
        $this$rsaKeyRing_u24lambda_u240.setPassphrase(passphrase);
        if (userId != null) {
            $this$rsaKeyRing_u24lambda_u240.addUserId(userId);
        }
        return keyRingBuilder.build();
    }

    public static /* synthetic */ PGPSecretKeyRing rsaKeyRing$default(KeyRingTemplates keyRingTemplates, CharSequence charSequence, RsaLength rsaLength, Passphrase passphrase, int n, Object object) {
        if ((n & 4) != 0) {
            passphrase = Passphrase.Companion.emptyPassphrase();
        }
        return keyRingTemplates.rsaKeyRing(charSequence, rsaLength, passphrase);
    }

    @NotNull
    public final PGPSecretKeyRing rsaKeyRing(@Nullable CharSequence userId, @NotNull RsaLength length, @Nullable String password) {
        Intrinsics.checkNotNullParameter((Object)length, (String)"length");
        String it = password;
        boolean bl = false;
        CharSequence charSequence = it;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? this.rsaKeyRing(userId, length, Passphrase.Companion.emptyPassphrase()) : this.rsaKeyRing(userId, length, Passphrase.Companion.fromPassword(it));
    }

    @JvmOverloads
    @NotNull
    public final PGPSecretKeyRing simpleRsaKeyRing(@Nullable CharSequence userId, @NotNull RsaLength length, @NotNull Passphrase passphrase) {
        KeyRingBuilder keyRingBuilder;
        Intrinsics.checkNotNullParameter((Object)length, (String)"length");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        KeyRingBuilder $this$simpleRsaKeyRing_u24lambda_u242 = keyRingBuilder = PGPainless.Companion.buildKeyRing();
        boolean bl = false;
        KeyFlag[] keyFlagArray = new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA, KeyFlag.ENCRYPT_COMMS};
        $this$simpleRsaKeyRing_u24lambda_u242.setPrimaryKey(KeySpec.Companion.getBuilder(KeyType.Companion.RSA(length), keyFlagArray));
        $this$simpleRsaKeyRing_u24lambda_u242.setPassphrase(passphrase);
        if (userId != null) {
            $this$simpleRsaKeyRing_u24lambda_u242.addUserId(((Object)userId).toString());
        }
        return keyRingBuilder.build();
    }

    public static /* synthetic */ PGPSecretKeyRing simpleRsaKeyRing$default(KeyRingTemplates keyRingTemplates, CharSequence charSequence, RsaLength rsaLength, Passphrase passphrase, int n, Object object) {
        if ((n & 4) != 0) {
            passphrase = Passphrase.Companion.emptyPassphrase();
        }
        return keyRingTemplates.simpleRsaKeyRing(charSequence, rsaLength, passphrase);
    }

    @NotNull
    public final PGPSecretKeyRing simpleRsaKeyRing(@Nullable CharSequence userId, @NotNull RsaLength length, @Nullable String password) {
        Intrinsics.checkNotNullParameter((Object)length, (String)"length");
        String it = password;
        boolean bl = false;
        CharSequence charSequence = it;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? this.simpleRsaKeyRing(userId, length, Passphrase.Companion.emptyPassphrase()) : this.simpleRsaKeyRing(userId, length, Passphrase.Companion.fromPassword(it));
    }

    @JvmOverloads
    @NotNull
    public final PGPSecretKeyRing simpleEcKeyRing(@Nullable CharSequence userId, @NotNull Passphrase passphrase) {
        KeyRingBuilder keyRingBuilder;
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        KeyRingBuilder $this$simpleEcKeyRing_u24lambda_u244 = keyRingBuilder = PGPainless.Companion.buildKeyRing();
        boolean bl = false;
        KeyFlag[] keyFlagArray = new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA};
        $this$simpleEcKeyRing_u24lambda_u244.setPrimaryKey(KeySpec.Companion.getBuilder(KeyType.Companion.EDDSA_LEGACY(EdDSALegacyCurve._Ed25519), keyFlagArray));
        keyFlagArray = new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS};
        $this$simpleEcKeyRing_u24lambda_u244.addSubkey(KeySpec.Companion.getBuilder(KeyType.Companion.XDH_LEGACY(XDHLegacySpec._X25519), keyFlagArray));
        $this$simpleEcKeyRing_u24lambda_u244.setPassphrase(passphrase);
        if (userId != null) {
            $this$simpleEcKeyRing_u24lambda_u244.addUserId(((Object)userId).toString());
        }
        return keyRingBuilder.build();
    }

    public static /* synthetic */ PGPSecretKeyRing simpleEcKeyRing$default(KeyRingTemplates keyRingTemplates, CharSequence charSequence, Passphrase passphrase, int n, Object object) {
        if ((n & 2) != 0) {
            passphrase = Passphrase.Companion.emptyPassphrase();
        }
        return keyRingTemplates.simpleEcKeyRing(charSequence, passphrase);
    }

    @NotNull
    public final PGPSecretKeyRing simpleEcKeyRing(@Nullable CharSequence userId, @Nullable String password) {
        String it = password;
        boolean bl = false;
        CharSequence charSequence = it;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? this.simpleEcKeyRing(userId, Passphrase.Companion.emptyPassphrase()) : this.simpleEcKeyRing(userId, Passphrase.Companion.fromPassword(it));
    }

    @JvmOverloads
    @NotNull
    public final PGPSecretKeyRing modernKeyRing(@Nullable CharSequence userId, @NotNull Passphrase passphrase) {
        KeyRingBuilder keyRingBuilder;
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        KeyRingBuilder $this$modernKeyRing_u24lambda_u246 = keyRingBuilder = PGPainless.Companion.buildKeyRing();
        boolean bl = false;
        KeyFlag[] keyFlagArray = new KeyFlag[]{KeyFlag.CERTIFY_OTHER};
        $this$modernKeyRing_u24lambda_u246.setPrimaryKey(KeySpec.Companion.getBuilder(KeyType.Companion.EDDSA_LEGACY(EdDSALegacyCurve._Ed25519), keyFlagArray));
        keyFlagArray = new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE};
        $this$modernKeyRing_u24lambda_u246.addSubkey(KeySpec.Companion.getBuilder(KeyType.Companion.XDH_LEGACY(XDHLegacySpec._X25519), keyFlagArray));
        keyFlagArray = new KeyFlag[]{KeyFlag.SIGN_DATA};
        $this$modernKeyRing_u24lambda_u246.addSubkey(KeySpec.Companion.getBuilder(KeyType.Companion.EDDSA_LEGACY(EdDSALegacyCurve._Ed25519), keyFlagArray));
        $this$modernKeyRing_u24lambda_u246.setPassphrase(passphrase);
        if (userId != null) {
            $this$modernKeyRing_u24lambda_u246.addUserId(userId);
        }
        return keyRingBuilder.build();
    }

    public static /* synthetic */ PGPSecretKeyRing modernKeyRing$default(KeyRingTemplates keyRingTemplates, CharSequence charSequence, Passphrase passphrase, int n, Object object) {
        if ((n & 2) != 0) {
            passphrase = Passphrase.Companion.emptyPassphrase();
        }
        return keyRingTemplates.modernKeyRing(charSequence, passphrase);
    }

    @NotNull
    public final PGPSecretKeyRing modernKeyRing(@Nullable CharSequence userId, @Nullable String password) {
        String it = password;
        boolean bl = false;
        CharSequence charSequence = it;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? this.modernKeyRing(userId, Passphrase.Companion.emptyPassphrase()) : this.modernKeyRing(userId, Passphrase.Companion.fromPassword(it));
    }

    @JvmOverloads
    @NotNull
    public final PGPSecretKeyRing rsaKeyRing(@Nullable CharSequence userId, @NotNull RsaLength length) {
        Intrinsics.checkNotNullParameter((Object)length, (String)"length");
        return KeyRingTemplates.rsaKeyRing$default(this, userId, length, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final PGPSecretKeyRing simpleRsaKeyRing(@Nullable CharSequence userId, @NotNull RsaLength length) {
        Intrinsics.checkNotNullParameter((Object)length, (String)"length");
        return KeyRingTemplates.simpleRsaKeyRing$default(this, userId, length, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final PGPSecretKeyRing simpleEcKeyRing(@Nullable CharSequence userId) {
        return KeyRingTemplates.simpleEcKeyRing$default(this, userId, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final PGPSecretKeyRing modernKeyRing(@Nullable CharSequence userId) {
        return KeyRingTemplates.modernKeyRing$default(this, userId, null, 2, null);
    }
}

