/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.builder.AbstractSignatureBuilder;
import org.pgpainless.signature.subpackets.BaseSignatureSubpackets;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpackets;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u001c"}, d2={"Lorg/pgpainless/signature/builder/PrimaryKeyBindingSignatureBuilder;", "Lorg/pgpainless/signature/builder/AbstractSignatureBuilder;", "signingSubkey", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "subkeyProtector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "(Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;)V", "hashAlgorithm", "Lorg/pgpainless/algorithm/HashAlgorithm;", "(Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/pgpainless/algorithm/HashAlgorithm;)V", "hashedSubpackets", "Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets;", "getHashedSubpackets", "()Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets;", "signatureTypePredicate", "Ljava/util/function/Predicate;", "Lorg/pgpainless/algorithm/SignatureType;", "getSignatureTypePredicate", "()Ljava/util/function/Predicate;", "unhashedSubpackets", "getUnhashedSubpackets", "applyCallback", "callback", "Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets$Callback;", "build", "Lorg/bouncycastle/openpgp/PGPSignature;", "primaryKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "pgpainless-core"})
public final class PrimaryKeyBindingSignatureBuilder
extends AbstractSignatureBuilder<PrimaryKeyBindingSignatureBuilder> {
    @NotNull
    private final SelfSignatureSubpackets hashedSubpackets;
    @NotNull
    private final SelfSignatureSubpackets unhashedSubpackets;

    @Override
    @NotNull
    protected Predicate<SignatureType> getSignatureTypePredicate() {
        return PrimaryKeyBindingSignatureBuilder::_get_signatureTypePredicate_$lambda$0;
    }

    public PrimaryKeyBindingSignatureBuilder(@NotNull PGPSecretKey signingSubkey, @NotNull SecretKeyRingProtector subkeyProtector) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)signingSubkey, (String)"signingSubkey");
        Intrinsics.checkNotNullParameter((Object)subkeyProtector, (String)"subkeyProtector");
        super(SignatureType.PRIMARYKEY_BINDING, signingSubkey, subkeyProtector);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    public PrimaryKeyBindingSignatureBuilder(@NotNull PGPSecretKey signingSubkey, @NotNull SecretKeyRingProtector subkeyProtector, @NotNull HashAlgorithm hashAlgorithm) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)signingSubkey, (String)"signingSubkey");
        Intrinsics.checkNotNullParameter((Object)subkeyProtector, (String)"subkeyProtector");
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
        PGPPublicKey pGPPublicKey = signingSubkey.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"signingSubkey.publicKey");
        super(SignatureType.PRIMARYKEY_BINDING, signingSubkey, subkeyProtector, hashAlgorithm, SignatureSubpackets.Companion.createHashedSubpackets(pGPPublicKey), SignatureSubpackets.Companion.createEmptySubpackets());
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    @NotNull
    public final SelfSignatureSubpackets getHashedSubpackets() {
        return this.hashedSubpackets;
    }

    @NotNull
    public final SelfSignatureSubpackets getUnhashedSubpackets() {
        return this.unhashedSubpackets;
    }

    @NotNull
    public final PrimaryKeyBindingSignatureBuilder applyCallback(@Nullable SelfSignatureSubpackets.Callback callback2) {
        PrimaryKeyBindingSignatureBuilder primaryKeyBindingSignatureBuilder;
        block0: {
            PrimaryKeyBindingSignatureBuilder $this$applyCallback_u24lambda_u242 = primaryKeyBindingSignatureBuilder = this;
            boolean bl = false;
            SelfSignatureSubpackets.Callback callback3 = callback2;
            if (callback3 == null) break block0;
            SelfSignatureSubpackets.Callback it = callback3;
            boolean bl2 = false;
            it.modifyHashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u242.hashedSubpackets);
            it.modifyUnhashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u242.unhashedSubpackets);
        }
        return primaryKeyBindingSignatureBuilder;
    }

    @NotNull
    public final PGPSignature build(@NotNull PGPPublicKey primaryKey) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
        PGPSignature pGPSignature = this.buildAndInitSignatureGenerator().generateCertification(primaryKey, this.getPublicSigningKey());
        Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"buildAndInitSignatureGen\u2026aryKey, publicSigningKey)");
        return pGPSignature;
    }

    private static final boolean _get_signatureTypePredicate_$lambda$0(SignatureType it) {
        return it == SignatureType.PRIMARYKEY_BINDING;
    }
}

