/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.consumer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import openpgp.DateExtensionsKt;
import openpgp.LongExtensionsKt;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SignatureSubpacket;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.bouncycastle.extensions.PGPPublicKeyExtensionsKt;
import org.pgpainless.bouncycastle.extensions.PGPSignatureExtensionsKt;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;
import org.pgpainless.util.NotationRegistry;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\b"}, d2={"Lorg/pgpainless/signature/consumer/SignatureValidator;", "", "()V", "verify", "", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "Companion", "pgpainless-core"})
public abstract class SignatureValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public abstract void verify(@NotNull PGPSignature var1) throws SignatureValidationException;

    @JvmStatic
    @NotNull
    public static final SignatureValidator wasPossiblyMadeByKey(@NotNull PGPPublicKey signingKey) {
        return Companion.wasPossiblyMadeByKey(signingKey);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator hasValidPrimaryKeyBindingSignatureIfRequired(@NotNull PGPPublicKey primaryKey, @NotNull PGPPublicKey subkey, @NotNull Policy policy, @NotNull Date referenceTime) {
        return Companion.hasValidPrimaryKeyBindingSignatureIfRequired(primaryKey, subkey, policy, referenceTime);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator signatureStructureIsAcceptable(@NotNull PGPPublicKey signingKey, @NotNull Policy policy) {
        return Companion.signatureStructureIsAcceptable(signingKey, policy);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator signatureUsesAcceptablePublicKeyAlgorithm(@NotNull Policy policy, @NotNull PGPPublicKey signingKey) {
        return Companion.signatureUsesAcceptablePublicKeyAlgorithm(policy, signingKey);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator signatureUsesAcceptableHashAlgorithm(@NotNull Policy policy) {
        return Companion.signatureUsesAcceptableHashAlgorithm(policy);
    }

    @JvmStatic
    private static final Policy.HashAlgorithmPolicy getHashAlgorithmPolicyForSignature(PGPSignature signature, Policy policy) {
        return SignatureValidator.Companion.getHashAlgorithmPolicyForSignature(signature, policy);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator signatureDoesNotHaveCriticalUnknownNotations(@NotNull NotationRegistry registry) {
        return Companion.signatureDoesNotHaveCriticalUnknownNotations(registry);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator signatureDoesNotHaveCriticalUnknownSubpackets() {
        return Companion.signatureDoesNotHaveCriticalUnknownSubpackets();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SignatureValidator signatureIsEffective(@NotNull Date referenceTime) {
        return Companion.signatureIsEffective(referenceTime);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator signatureIsAlreadyEffective(@NotNull Date referenceTime) {
        return Companion.signatureIsAlreadyEffective(referenceTime);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator signatureIsNotYetExpired(@NotNull Date referenceTime) {
        return Companion.signatureIsNotYetExpired(referenceTime);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator signatureIsNotMalformed(@NotNull PGPPublicKey signingKey) {
        return Companion.signatureIsNotMalformed(signingKey);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator signatureDoesNotPredateSignee(@NotNull PGPPublicKey signee) {
        return Companion.signatureDoesNotPredateSignee(signee);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator signatureDoesNotPredateSigningKey(@NotNull PGPPublicKey signingKey) {
        return Companion.signatureDoesNotPredateSigningKey(signingKey);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator signatureDoesNotPredateKeyCreation(@NotNull PGPPublicKey key) {
        return Companion.signatureDoesNotPredateKeyCreation(key);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator signatureHasHashedCreationTime() {
        return Companion.signatureHasHashedCreationTime();
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator signatureDoesNotPredateSigningKeyBindingDate(@NotNull PGPPublicKey signingKey) {
        return Companion.signatureDoesNotPredateSigningKeyBindingDate(signingKey);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator correctSubkeyBindingSignature(@NotNull PGPPublicKey primaryKey, @NotNull PGPPublicKey subkey) {
        return Companion.correctSubkeyBindingSignature(primaryKey, subkey);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator correctPrimaryKeyBindingSignature(@NotNull PGPPublicKey primaryKey, @NotNull PGPPublicKey subkey) {
        return Companion.correctPrimaryKeyBindingSignature(primaryKey, subkey);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator correctSignatureOverKey(@NotNull PGPPublicKey signingKey, @NotNull PGPPublicKey signedKey) {
        return Companion.correctSignatureOverKey(signingKey, signedKey);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator signatureIsCertification() {
        return Companion.signatureIsCertification();
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator signatureIsOfType(SignatureType ... signatureType) {
        return Companion.signatureIsOfType(signatureType);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator correctSignatureOverUserId(@NotNull CharSequence userId, @NotNull PGPPublicKey certifiedKey, @NotNull PGPPublicKey certifyingKey) {
        return Companion.correctSignatureOverUserId(userId, certifiedKey, certifyingKey);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator correctSignatureOverUserAttributes(@NotNull PGPUserAttributeSubpacketVector userAttributes, @NotNull PGPPublicKey certifiedKey, @NotNull PGPPublicKey certifyingKey) {
        return Companion.correctSignatureOverUserAttributes(userAttributes, certifiedKey, certifyingKey);
    }

    @JvmStatic
    @NotNull
    public static final SignatureValidator signatureWasCreatedInBounds(@Nullable Date notBefore, @Nullable Date notAfter) {
        return Companion.signatureWasCreatedInBounds(notBefore, notAfter);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SignatureValidator signatureIsEffective() {
        return Companion.signatureIsEffective();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0007J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0007J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0007J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0003J(\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\b\u0010 \u001a\u00020\u0004H\u0007J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0006H\u0007J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0006H\u0007J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0007J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0007J\b\u0010'\u001a\u00020\u0004H\u0007J\u0010\u0010(\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\b\u0010)\u001a\u00020\u0004H\u0007J\u0012\u0010*\u001a\u00020\u00042\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0007J\u0010\u0010+\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0007J\u0010\u0010,\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J!\u0010-\u001a\u00020\u00042\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u0002000/\"\u000200H\u0007\u00a2\u0006\u0002\u00101J\u0018\u00102\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u00103\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0018\u00104\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\u0006H\u0007J\u001c\u00105\u001a\u00020\u00042\b\u00106\u001a\u0004\u0018\u00010\u001c2\b\u00107\u001a\u0004\u0018\u00010\u001cH\u0007J\u0010\u00108\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0007\u00a8\u00069"}, d2={"Lorg/pgpainless/signature/consumer/SignatureValidator$Companion;", "", "()V", "correctPrimaryKeyBindingSignature", "Lorg/pgpainless/signature/consumer/SignatureValidator;", "primaryKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "subkey", "correctSignatureOverKey", "signingKey", "signedKey", "correctSignatureOverUserAttributes", "userAttributes", "Lorg/bouncycastle/openpgp/PGPUserAttributeSubpacketVector;", "certifiedKey", "certifyingKey", "correctSignatureOverUserId", "userId", "", "correctSubkeyBindingSignature", "getHashAlgorithmPolicyForSignature", "Lorg/pgpainless/policy/Policy$HashAlgorithmPolicy;", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "policy", "Lorg/pgpainless/policy/Policy;", "hasValidPrimaryKeyBindingSignatureIfRequired", "referenceTime", "Ljava/util/Date;", "signatureDoesNotHaveCriticalUnknownNotations", "registry", "Lorg/pgpainless/util/NotationRegistry;", "signatureDoesNotHaveCriticalUnknownSubpackets", "signatureDoesNotPredateKeyCreation", "key", "signatureDoesNotPredateSignee", "signee", "signatureDoesNotPredateSigningKey", "signatureDoesNotPredateSigningKeyBindingDate", "signatureHasHashedCreationTime", "signatureIsAlreadyEffective", "signatureIsCertification", "signatureIsEffective", "signatureIsNotMalformed", "signatureIsNotYetExpired", "signatureIsOfType", "signatureType", "", "Lorg/pgpainless/algorithm/SignatureType;", "([Lorg/pgpainless/algorithm/SignatureType;)Lorg/pgpainless/signature/consumer/SignatureValidator;", "signatureStructureIsAcceptable", "signatureUsesAcceptableHashAlgorithm", "signatureUsesAcceptablePublicKeyAlgorithm", "signatureWasCreatedInBounds", "notBefore", "notAfter", "wasPossiblyMadeByKey", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator wasPossiblyMadeByKey(@NotNull PGPPublicKey signingKey) {
            Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
            return new SignatureValidator(signingKey){
                final /* synthetic */ PGPPublicKey $signingKey;
                {
                    this.$signingKey = $signingKey;
                }

                public void verify(@NotNull PGPSignature signature) {
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    OpenPgpFingerprint signingKeyFingerprint = OpenPgpFingerprint.Companion.of(this.$signingKey);
                    Long issuer = SignatureSubpacketsUtil.Companion.getIssuerKeyIdAsLong(signature);
                    if (issuer != null) {
                        long l = this.$signingKey.getKeyID();
                        if (issuer != l) {
                            throw new SignatureValidationException("Signature was not created by " + signingKeyFingerprint + " (signature issuer: " + LongExtensionsKt.openPgpKeyId(issuer) + ")");
                        }
                    }
                    if (PGPSignatureExtensionsKt.getFingerprint(signature) != null && !Intrinsics.areEqual((Object)PGPSignatureExtensionsKt.getFingerprint(signature), (Object)signingKeyFingerprint)) {
                        throw new SignatureValidationException("Signature was not created by " + signingKeyFingerprint + " (signature fingerprint: " + PGPSignatureExtensionsKt.getFingerprint(signature) + ")");
                    }
                }
            };
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator hasValidPrimaryKeyBindingSignatureIfRequired(@NotNull PGPPublicKey primaryKey, @NotNull PGPPublicKey subkey, @NotNull Policy policy, @NotNull Date referenceTime) {
            Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
            Intrinsics.checkNotNullParameter((Object)subkey, (String)"subkey");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            return new SignatureValidator(subkey, policy, referenceTime, primaryKey){
                final /* synthetic */ PGPPublicKey $subkey;
                final /* synthetic */ Policy $policy;
                final /* synthetic */ Date $referenceTime;
                final /* synthetic */ PGPPublicKey $primaryKey;
                {
                    this.$subkey = $subkey;
                    this.$policy = $policy;
                    this.$referenceTime = $referenceTime;
                    this.$primaryKey = $primaryKey;
                }

                /*
                 * WARNING - void declaration
                 */
                public void verify(@NotNull PGPSignature signature) {
                    Unit unit;
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    if (!PGPSignatureExtensionsKt.getPublicKeyAlgorithm(signature).isSigningCapable()) {
                        return;
                    }
                    KeyFlags keyFlags = SignatureSubpacketsUtil.Companion.getKeyFlags(signature);
                    if (keyFlags != null) {
                        KeyFlags it = keyFlags;
                        boolean bl = false;
                        if (!KeyFlag.Companion.hasKeyFlag(it.getFlags(), KeyFlag.SIGN_DATA) && !KeyFlag.Companion.hasKeyFlag(it.getFlags(), KeyFlag.CERTIFY_OTHER)) {
                            return;
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit == null) {
                        return;
                    }
                    try {
                        boolean bl;
                        Map rejectedEmbeddedSignatures;
                        block16: {
                            void $this$any$iv;
                            PGPSignatureList embeddedSignatures = SignatureSubpacketsUtil.Companion.getEmbeddedSignature(signature);
                            if (embeddedSignatures.isEmpty()) {
                                throw new SignatureValidationException("Missing primary key binding signature on signing capable subkey " + LongExtensionsKt.openPgpKeyId(this.$subkey.getKeyID()), MapsKt.emptyMap());
                            }
                            rejectedEmbeddedSignatures = new LinkedHashMap<K, V>();
                            Iterable iterable = (Iterable)embeddedSignatures;
                            PGPPublicKey pGPPublicKey = this.$subkey;
                            Policy policy = this.$policy;
                            Date date = this.$referenceTime;
                            PGPPublicKey pGPPublicKey2 = this.$primaryKey;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    boolean bl2;
                                    block15: {
                                        PGPSignature embedded = (PGPSignature)element$iv;
                                        boolean bl3 = false;
                                        Intrinsics.checkNotNullExpressionValue((Object)embedded, (String)"embedded");
                                        if (PGPSignatureExtensionsKt.isOfType(embedded, SignatureType.PRIMARYKEY_BINDING)) {
                                            try {
                                                SignatureValidator.Companion.signatureStructureIsAcceptable(pGPPublicKey, policy).verify(embedded);
                                                SignatureValidator.Companion.signatureIsEffective(date).verify(embedded);
                                                SignatureValidator.Companion.correctPrimaryKeyBindingSignature(pGPPublicKey2, pGPPublicKey).verify(embedded);
                                                bl2 = true;
                                                break block15;
                                            }
                                            catch (SignatureValidationException e) {
                                                rejectedEmbeddedSignatures.put(embedded, e);
                                            }
                                        }
                                        bl2 = false;
                                    }
                                    if (!bl2) continue;
                                    bl = true;
                                    break block16;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) {
                            throw new SignatureValidationException("Missing primary key binding signature on signing capable subkey " + LongExtensionsKt.openPgpKeyId(this.$subkey.getKeyID()), rejectedEmbeddedSignatures);
                        }
                    }
                    catch (PGPException e) {
                        throw new SignatureValidationException("Cannot process list of embedded signatures.", (Exception)((Object)e));
                    }
                }
            };
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator signatureStructureIsAcceptable(@NotNull PGPPublicKey signingKey, @NotNull Policy policy) {
            Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            return new SignatureValidator(signingKey, policy){
                final /* synthetic */ PGPPublicKey $signingKey;
                final /* synthetic */ Policy $policy;
                {
                    this.$signingKey = $signingKey;
                    this.$policy = $policy;
                }

                public void verify(@NotNull PGPSignature signature) {
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    SignatureValidator.Companion.signatureIsNotMalformed(this.$signingKey).verify(signature);
                    if (signature.getVersion() >= 4) {
                        SignatureValidator.Companion.signatureDoesNotHaveCriticalUnknownNotations(this.$policy.getNotationRegistry()).verify(signature);
                        SignatureValidator.Companion.signatureDoesNotHaveCriticalUnknownSubpackets().verify(signature);
                    }
                    SignatureValidator.Companion.signatureUsesAcceptableHashAlgorithm(this.$policy).verify(signature);
                    SignatureValidator.Companion.signatureUsesAcceptablePublicKeyAlgorithm(this.$policy, this.$signingKey).verify(signature);
                }
            };
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator signatureUsesAcceptablePublicKeyAlgorithm(@NotNull Policy policy, @NotNull PGPPublicKey signingKey) {
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
            return new SignatureValidator(signingKey, policy){
                final /* synthetic */ PGPPublicKey $signingKey;
                final /* synthetic */ Policy $policy;
                {
                    this.$signingKey = $signingKey;
                    this.$policy = $policy;
                }

                public void verify(@NotNull PGPSignature signature) {
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    if (this.$signingKey.getBitStrength() == -1) {
                        throw new SignatureValidationException("Cannot determine bit strength of signing key.");
                    }
                    if (!this.$policy.getPublicKeyAlgorithmPolicy().isAcceptable(PGPPublicKeyExtensionsKt.getPublicKeyAlgorithm(this.$signingKey), this.$signingKey.getBitStrength())) {
                        throw new SignatureValidationException("Signature was made using unacceptable key. " + PGPPublicKeyExtensionsKt.getPublicKeyAlgorithm(this.$signingKey) + " (" + this.$signingKey.getBitStrength() + " bits) is not acceptable according to the public key algorithm policy.");
                    }
                }
            };
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator signatureUsesAcceptableHashAlgorithm(@NotNull Policy policy) {
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            return new SignatureValidator(policy){
                final /* synthetic */ Policy $policy;
                {
                    this.$policy = $policy;
                }

                public void verify(@NotNull PGPSignature signature) {
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    try {
                        Policy.HashAlgorithmPolicy algorithmPolicy = org.pgpainless.signature.consumer.SignatureValidator$Companion.access$getHashAlgorithmPolicyForSignature(SignatureValidator.Companion, signature, this.$policy);
                        HashAlgorithm hashAlgorithm = PGPSignatureExtensionsKt.getSignatureHashAlgorithm(signature);
                        Date date = signature.getCreationTime();
                        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"signature.creationTime");
                        if (!algorithmPolicy.isAcceptable(hashAlgorithm, date)) {
                            HashAlgorithm hashAlgorithm2 = PGPSignatureExtensionsKt.getSignatureHashAlgorithm(signature);
                            Date date2 = signature.getCreationTime();
                            Intrinsics.checkNotNullExpressionValue((Object)date2, (String)"signature.creationTime");
                            throw new SignatureValidationException("Signature uses unacceptable hash algorithm " + hashAlgorithm2 + " (Signature creation time: " + DateExtensionsKt.formatUTC(date2) + ")");
                        }
                    }
                    catch (NoSuchElementException e) {
                        throw new SignatureValidationException("Signature uses unknown hash algorithm " + signature.getHashAlgorithm());
                    }
                }
            };
        }

        @JvmStatic
        private final Policy.HashAlgorithmPolicy getHashAlgorithmPolicyForSignature(PGPSignature signature, Policy policy) {
            Policy.HashAlgorithmPolicy hashAlgorithmPolicy;
            SignatureType signatureType = SignatureType.Companion.fromCode(signature.getSignatureType());
            switch (signatureType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[signatureType.ordinal()]) {
                case -1: {
                    hashAlgorithmPolicy = policy.getCertificationSignatureHashAlgorithmPolicy();
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    hashAlgorithmPolicy = policy.getRevocationSignatureHashAlgorithmPolicy();
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    hashAlgorithmPolicy = policy.getCertificationSignatureHashAlgorithmPolicy();
                    break;
                }
                default: {
                    hashAlgorithmPolicy = policy.getDataSignatureHashAlgorithmPolicy();
                }
            }
            return hashAlgorithmPolicy;
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator signatureDoesNotHaveCriticalUnknownNotations(@NotNull NotationRegistry registry) {
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            return new SignatureValidator(registry){
                final /* synthetic */ NotationRegistry $registry;
                {
                    this.$registry = $registry;
                }

                /*
                 * Unable to fully structure code
                 */
                public void verify(@NotNull PGPSignature signature) {
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    var2_2 = SignatureSubpacketsUtil.Companion.getHashedNotationData(signature);
                    var3_3 = this.$registry;
                    $i$f$filter = false;
                    var5_7 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (NotationData)element$iv$iv;
                        $i$a$-filter-SignatureValidator$Companion$signatureDoesNotHaveCriticalUnknownNotations$1$verify$1 = false;
                        if (!it.isCritical()) ** GOTO lbl-1000
                        v0 = it.getNotationName();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"it.notationName");
                        if (!var3_3.isKnownNotation(v0)) {
                            v1 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v1 = false;
                        }
                        if (!v1) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$forEach$iv = (List)destination$iv$iv;
                    $i$f$forEach = false;
                    var4_6 = $this$forEach$iv.iterator();
                    if (var4_6.hasNext()) {
                        element$iv = var4_6.next();
                        it = (NotationData)element$iv;
                        $i$a$-forEach-SignatureValidator$Companion$signatureDoesNotHaveCriticalUnknownNotations$1$verify$2 = false;
                        throw new SignatureValidationException("Signature contains unknown critical notation '" + it.getNotationName() + "' in its hashed area.");
                    }
                }
            };
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator signatureDoesNotHaveCriticalUnknownSubpackets() {
            return new SignatureValidator(){

                public void verify(@NotNull PGPSignature signature) {
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    int[] nArray = signature.getHashedSubPackets().getCriticalTags();
                    Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"signature.hashedSubPackets.criticalTags");
                    int[] $this$forEach$iv = nArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        int element$iv;
                        int it = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        try {
                            SignatureSubpacket.Companion.requireFromCode(it);
                            continue;
                        }
                        catch (NoSuchElementException e) {
                            throw new SignatureValidationException("Signature contains unknown critical subpacket of type 0x" + Integer.toHexString(it));
                        }
                    }
                }
            };
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SignatureValidator signatureIsEffective(@NotNull Date referenceTime) {
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            return new SignatureValidator(referenceTime){
                final /* synthetic */ Date $referenceTime;
                {
                    this.$referenceTime = $referenceTime;
                }

                public void verify(@NotNull PGPSignature signature) {
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    SignatureValidator.Companion.signatureIsAlreadyEffective(this.$referenceTime).verify(signature);
                    SignatureValidator.Companion.signatureIsNotYetExpired(this.$referenceTime).verify(signature);
                }
            };
        }

        public static /* synthetic */ SignatureValidator signatureIsEffective$default(Companion companion, Date date, int n, Object object) {
            if ((n & 1) != 0) {
                date = new Date();
            }
            return companion.signatureIsEffective(date);
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator signatureIsAlreadyEffective(@NotNull Date referenceTime) {
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            return new SignatureValidator(referenceTime){
                final /* synthetic */ Date $referenceTime;
                {
                    this.$referenceTime = $referenceTime;
                }

                public void verify(@NotNull PGPSignature signature) {
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    if (PGPSignatureExtensionsKt.isHardRevocation(signature)) {
                        return;
                    }
                    if (signature.getCreationTime().compareTo(this.$referenceTime) > 0) {
                        Date date = signature.getCreationTime();
                        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"signature.creationTime");
                        throw new SignatureValidationException("Signature was created at " + DateExtensionsKt.formatUTC(date) + " and is therefore not yet valid at " + DateExtensionsKt.formatUTC(this.$referenceTime));
                    }
                }
            };
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator signatureIsNotYetExpired(@NotNull Date referenceTime) {
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            return new SignatureValidator(referenceTime){
                final /* synthetic */ Date $referenceTime;
                {
                    this.$referenceTime = $referenceTime;
                }

                public void verify(@NotNull PGPSignature signature) {
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    if (PGPSignatureExtensionsKt.isHardRevocation(signature)) {
                        return;
                    }
                    Date expirationDate = PGPSignatureExtensionsKt.getSignatureExpirationDate(signature);
                    if (expirationDate != null && expirationDate.compareTo(this.$referenceTime) < 0) {
                        throw new SignatureValidationException("Signature is already expired (expiration: " + DateExtensionsKt.formatUTC(expirationDate) + ", validation: " + DateExtensionsKt.formatUTC(this.$referenceTime) + ")");
                    }
                }
            };
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator signatureIsNotMalformed(@NotNull PGPPublicKey signingKey) {
            Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
            return new SignatureValidator(signingKey){
                final /* synthetic */ PGPPublicKey $signingKey;
                {
                    this.$signingKey = $signingKey;
                }

                public void verify(@NotNull PGPSignature signature) {
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    if (signature.getVersion() >= 4) {
                        SignatureValidator.Companion.signatureHasHashedCreationTime().verify(signature);
                    }
                    SignatureValidator.Companion.signatureDoesNotPredateSigningKey(this.$signingKey).verify(signature);
                    if (!PGPSignatureExtensionsKt.isOfType(signature, SignatureType.PRIMARYKEY_BINDING)) {
                        SignatureValidator.Companion.signatureDoesNotPredateSigningKeyBindingDate(this.$signingKey).verify(signature);
                    }
                }
            };
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator signatureDoesNotPredateSignee(@NotNull PGPPublicKey signee) {
            Intrinsics.checkNotNullParameter((Object)signee, (String)"signee");
            return this.signatureDoesNotPredateKeyCreation(signee);
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator signatureDoesNotPredateSigningKey(@NotNull PGPPublicKey signingKey) {
            Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
            return this.signatureDoesNotPredateKeyCreation(signingKey);
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator signatureDoesNotPredateKeyCreation(@NotNull PGPPublicKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new SignatureValidator(key){
                final /* synthetic */ PGPPublicKey $key;
                {
                    this.$key = $key;
                }

                public void verify(@NotNull PGPSignature signature) {
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    if (this.$key.getCreationTime().compareTo(signature.getCreationTime()) > 0) {
                        Date date = this.$key.getCreationTime();
                        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"key.creationTime");
                        String string = DateExtensionsKt.formatUTC(date);
                        Date date2 = signature.getCreationTime();
                        Intrinsics.checkNotNullExpressionValue((Object)date2, (String)"signature.creationTime");
                        throw new SignatureValidationException("Signature predates key (key creation: " + string + ", signature creation: " + DateExtensionsKt.formatUTC(date2) + ")");
                    }
                }
            };
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator signatureHasHashedCreationTime() {
            return new SignatureValidator(){

                public void verify(@NotNull PGPSignature signature) {
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    if (SignatureSubpacketsUtil.Companion.getSignatureCreationTime(signature) == null) {
                        throw new SignatureValidationException("Malformed signature.Signature has no signature creation time subpacket in its hashed area.");
                    }
                }
            };
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator signatureDoesNotPredateSigningKeyBindingDate(@NotNull PGPPublicKey signingKey) {
            Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
            return new SignatureValidator(signingKey){
                final /* synthetic */ PGPPublicKey $signingKey;
                {
                    this.$signingKey = $signingKey;
                }

                public void verify(@NotNull PGPSignature signature) {
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    if (this.$signingKey.isMasterKey()) {
                        return;
                    }
                    Iterator iterator = this.$signingKey.getSignaturesOfType(SignatureType.SUBKEY_BINDING.getCode());
                    Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"signingKey\n             \u2026Type.SUBKEY_BINDING.code)");
                    if (SequencesKt.none((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)((Function1)new Function1<PGPSignature, Unit>(signature){
                        final /* synthetic */ PGPSignature $signature;
                        {
                            this.$signature = $signature;
                            super(1);
                        }

                        public final void invoke(PGPSignature it) {
                            if (this.$signature.getCreationTime().compareTo(it.getCreationTime()) < 0) {
                                throw new SignatureValidationException("Signature was created before the signing key was bound to the certificate.");
                            }
                        }
                    })))) {
                        throw new SignatureValidationException("Signing subkey does not have a subkey binding signature.");
                    }
                }
            };
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator correctSubkeyBindingSignature(@NotNull PGPPublicKey primaryKey, @NotNull PGPPublicKey subkey) {
            Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
            Intrinsics.checkNotNullParameter((Object)subkey, (String)"subkey");
            return new SignatureValidator(primaryKey, subkey){
                final /* synthetic */ PGPPublicKey $primaryKey;
                final /* synthetic */ PGPPublicKey $subkey;
                {
                    this.$primaryKey = $primaryKey;
                    this.$subkey = $subkey;
                }

                public void verify(@NotNull PGPSignature signature) {
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    if (this.$primaryKey.getKeyID() == this.$subkey.getKeyID()) {
                        throw new SignatureValidationException("Primary key cannot be its own subkey.");
                    }
                    try {
                        signature.init(ImplementationFactory.Companion.getInstance().getPgpContentVerifierBuilderProvider(), this.$primaryKey);
                        if (!signature.verifyCertification(this.$primaryKey, this.$subkey)) {
                            throw new SignatureValidationException("Signature is not correct.");
                        }
                    }
                    catch (PGPException e) {
                        throw new SignatureValidationException("Cannot verify subkey binding signature correctness", (Exception)((Object)e));
                    }
                    catch (ClassCastException e) {
                        throw new SignatureValidationException("Cannot verify subkey binding signature correctness", e);
                    }
                }
            };
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator correctPrimaryKeyBindingSignature(@NotNull PGPPublicKey primaryKey, @NotNull PGPPublicKey subkey) {
            Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
            Intrinsics.checkNotNullParameter((Object)subkey, (String)"subkey");
            return new SignatureValidator(primaryKey, subkey){
                final /* synthetic */ PGPPublicKey $primaryKey;
                final /* synthetic */ PGPPublicKey $subkey;
                {
                    this.$primaryKey = $primaryKey;
                    this.$subkey = $subkey;
                }

                public void verify(@NotNull PGPSignature signature) {
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    if (this.$primaryKey.getKeyID() == this.$subkey.getKeyID()) {
                        throw new SignatureValidationException("Primary key cannot be its own subkey.");
                    }
                    try {
                        signature.init(ImplementationFactory.Companion.getInstance().getPgpContentVerifierBuilderProvider(), this.$subkey);
                        if (!signature.verifyCertification(this.$primaryKey, this.$subkey)) {
                            throw new SignatureValidationException("Primary Key Binding Signature is not correct.");
                        }
                    }
                    catch (PGPException e) {
                        throw new SignatureValidationException("Cannot verify primary key binding signature correctness", (Exception)((Object)e));
                    }
                    catch (ClassCastException e) {
                        throw new SignatureValidationException("Cannot verify primary key binding signature correctness", e);
                    }
                }
            };
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator correctSignatureOverKey(@NotNull PGPPublicKey signingKey, @NotNull PGPPublicKey signedKey) {
            Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
            Intrinsics.checkNotNullParameter((Object)signedKey, (String)"signedKey");
            return new SignatureValidator(signingKey, signedKey){
                final /* synthetic */ PGPPublicKey $signingKey;
                final /* synthetic */ PGPPublicKey $signedKey;
                {
                    this.$signingKey = $signingKey;
                    this.$signedKey = $signedKey;
                }

                public void verify(@NotNull PGPSignature signature) {
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    try {
                        boolean valid;
                        signature.init(ImplementationFactory.Companion.getInstance().getPgpContentVerifierBuilderProvider(), this.$signingKey);
                        boolean bl = valid = this.$signingKey.getKeyID() == this.$signedKey.getKeyID() || PGPSignatureExtensionsKt.isOfType(signature, SignatureType.DIRECT_KEY) ? signature.verifyCertification(this.$signedKey) : signature.verifyCertification(this.$signingKey, this.$signedKey);
                        if (!valid) {
                            throw new SignatureValidationException("Signature is not correct.");
                        }
                    }
                    catch (PGPException e) {
                        throw new SignatureValidationException("Cannot verify direct-key signature correctness", (Exception)((Object)e));
                    }
                    catch (ClassCastException e) {
                        throw new SignatureValidationException("Cannot verify direct-key signature correctness", e);
                    }
                }
            };
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator signatureIsCertification() {
            SignatureType[] signatureTypeArray = new SignatureType[]{SignatureType.POSITIVE_CERTIFICATION, SignatureType.CASUAL_CERTIFICATION, SignatureType.GENERIC_CERTIFICATION, SignatureType.NO_CERTIFICATION};
            return this.signatureIsOfType(signatureTypeArray);
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator signatureIsOfType(SignatureType ... signatureType) {
            Intrinsics.checkNotNullParameter((Object)signatureType, (String)"signatureType");
            return new SignatureValidator(signatureType){
                final /* synthetic */ SignatureType[] $signatureType;
                {
                    this.$signatureType = $signatureType;
                }

                public void verify(@NotNull PGPSignature signature) {
                    boolean bl;
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                        SignatureType[] $this$none$iv = this.$signatureType;
                        boolean $i$f$none = false;
                        int n = $this$none$iv.length;
                        for (int i = 0; i < n; ++i) {
                            SignatureType element$iv;
                            SignatureType it = element$iv = $this$none$iv[i];
                            boolean bl2 = false;
                            if (!PGPSignatureExtensionsKt.isOfType(signature, it)) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                    if (bl) {
                        Object object = SignatureType.Companion.fromCode(signature.getSignatureType());
                        if (object == null) {
                            String string = Integer.toString(signature.getSignatureType(), CharsKt.checkRadix((int)16));
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
                            object = "0x" + string;
                        }
                        String string = Arrays.toString((Object[])this.$signatureType);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
                        throw new SignatureValidationException("Signature is of type " + (Object)object + ", while only " + string + " are allowed here.");
                    }
                }
            };
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator correctSignatureOverUserId(@NotNull CharSequence userId, @NotNull PGPPublicKey certifiedKey, @NotNull PGPPublicKey certifyingKey) {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)certifiedKey, (String)"certifiedKey");
            Intrinsics.checkNotNullParameter((Object)certifyingKey, (String)"certifyingKey");
            return new SignatureValidator(certifyingKey, userId, certifiedKey){
                final /* synthetic */ PGPPublicKey $certifyingKey;
                final /* synthetic */ CharSequence $userId;
                final /* synthetic */ PGPPublicKey $certifiedKey;
                {
                    this.$certifyingKey = $certifyingKey;
                    this.$userId = $userId;
                    this.$certifiedKey = $certifiedKey;
                }

                public void verify(@NotNull PGPSignature signature) {
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    try {
                        signature.init(ImplementationFactory.Companion.getInstance().getPgpContentVerifierBuilderProvider(), this.$certifyingKey);
                        if (!signature.verifyCertification(((Object)this.$userId).toString(), this.$certifiedKey)) {
                            throw new SignatureValidationException("Signature over user-id '" + this.$userId + "' is not valid.");
                        }
                    }
                    catch (PGPException e) {
                        throw new SignatureValidationException("Cannot verify signature over user-id '" + this.$userId + "'.", (Exception)((Object)e));
                    }
                    catch (ClassCastException e) {
                        throw new SignatureValidationException("Cannot verify signature over user-id '" + this.$userId + "'.", e);
                    }
                }
            };
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator correctSignatureOverUserAttributes(@NotNull PGPUserAttributeSubpacketVector userAttributes, @NotNull PGPPublicKey certifiedKey, @NotNull PGPPublicKey certifyingKey) {
            Intrinsics.checkNotNullParameter((Object)userAttributes, (String)"userAttributes");
            Intrinsics.checkNotNullParameter((Object)certifiedKey, (String)"certifiedKey");
            Intrinsics.checkNotNullParameter((Object)certifyingKey, (String)"certifyingKey");
            return new SignatureValidator(certifyingKey, userAttributes, certifiedKey){
                final /* synthetic */ PGPPublicKey $certifyingKey;
                final /* synthetic */ PGPUserAttributeSubpacketVector $userAttributes;
                final /* synthetic */ PGPPublicKey $certifiedKey;
                {
                    this.$certifyingKey = $certifyingKey;
                    this.$userAttributes = $userAttributes;
                    this.$certifiedKey = $certifiedKey;
                }

                public void verify(@NotNull PGPSignature signature) {
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    try {
                        signature.init(ImplementationFactory.Companion.getInstance().getPgpContentVerifierBuilderProvider(), this.$certifyingKey);
                        if (!signature.verifyCertification(this.$userAttributes, this.$certifiedKey)) {
                            throw new SignatureValidationException("Signature over user-attributes is not correct.");
                        }
                    }
                    catch (PGPException e) {
                        throw new SignatureValidationException("Cannot verify signature over user-attribute vector.", (Exception)((Object)e));
                    }
                    catch (ClassCastException e) {
                        throw new SignatureValidationException("Cannot verify signature over user-attribute vector.", e);
                    }
                }
            };
        }

        @JvmStatic
        @NotNull
        public final SignatureValidator signatureWasCreatedInBounds(@Nullable Date notBefore, @Nullable Date notAfter) {
            return new SignatureValidator(notBefore, notAfter){
                final /* synthetic */ Date $notBefore;
                final /* synthetic */ Date $notAfter;
                {
                    this.$notBefore = $notBefore;
                    this.$notAfter = $notAfter;
                }

                public void verify(@NotNull PGPSignature signature) {
                    Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                    Date timestamp = signature.getCreationTime();
                    if (this.$notBefore != null && timestamp.compareTo(this.$notBefore) < 0) {
                        Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"timestamp");
                        throw new SignatureValidationException("Signature was made before the earliest allowed signature creation time. Created: " + DateExtensionsKt.formatUTC(timestamp) + ", earliest allowed: " + DateExtensionsKt.formatUTC(this.$notBefore));
                    }
                    if (this.$notAfter != null && timestamp.compareTo(this.$notAfter) > 0) {
                        Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"timestamp");
                        throw new SignatureValidationException("Signature was made after the latest allowed signature creation time. Created: " + DateExtensionsKt.formatUTC(timestamp) + ", latest allowed: " + DateExtensionsKt.formatUTC(this.$notAfter));
                    }
                }
            };
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SignatureValidator signatureIsEffective() {
            return org.pgpainless.signature.consumer.SignatureValidator$Companion.signatureIsEffective$default(this, null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SignatureType.values().length];
                try {
                    nArray[SignatureType.CERTIFICATION_REVOCATION.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureType.KEY_REVOCATION.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureType.SUBKEY_REVOCATION.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureType.GENERIC_CERTIFICATION.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureType.NO_CERTIFICATION.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureType.CASUAL_CERTIFICATION.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureType.POSITIVE_CERTIFICATION.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureType.DIRECT_KEY.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureType.SUBKEY_BINDING.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureType.PRIMARYKEY_BINDING.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

