/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.bouncycastle.extensions;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.bouncycastle.extensions.PGPKeyRingExtensionsKt;
import org.pgpainless.bouncycastle.extensions.PGPSecretKeyExtensionsKt;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.key.TestKeys;
import org.pgpainless.util.Passphrase;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007\u00a8\u0006\n"}, d2={"Lorg/pgpainless/bouncycastle/extensions/PGPSecretKeyExtensionsTest;", "", "()V", "can successfully unlock protected secret key", "", "can successfully unlock unprotected secret key with empty passphrase", "can successfully unlock unprotected secret key with unprotectedKeys protector", "cannot unlock protected secret key using empty passphrase", "openPgpFingerprint returns fitting fingerprint", "publicKeyAlgorithm returns fitting algorithm", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nPGPSecretKeyExtensionsTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PGPSecretKeyExtensionsTest.kt\norg/pgpainless/bouncycastle/extensions/PGPSecretKeyExtensionsTest\n+ 2 Assertions.kt\norg/junit/jupiter/api/AssertionsKt\n*L\n1#1,68:1\n162#2:69\n196#2,6:70\n100#2,7:76\n162#2:83\n196#2,6:84\n162#2:90\n196#2,6:91\n*S KotlinDebug\n*F\n+ 1 PGPSecretKeyExtensionsTest.kt\norg/pgpainless/bouncycastle/extensions/PGPSecretKeyExtensionsTest\n*L\n24#1:69\n24#1:70,6\n33#1:76,7\n41#1:83\n41#1:84,6\n50#1:90\n50#1:91,6\n*E\n"})
public final class PGPSecretKeyExtensionsTest {
    @Test
    public final void can successfully unlock protected secret key() {
        ThrowingSupplier throwingSupplier;
        PGPSecretKeyRing key = TestKeys.getCryptieSecretKeyRing();
        PGPSecretKey secKey = key.getSecretKey();
        boolean $i$f$assertDoesNotThrow = false;
        boolean $i$f$evaluateAndWrap = false;
        try {
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)secKey, (String)"secKey");
            Passphrase passphrase = TestKeys.CRYPTIE_PASSPHRASE;
            Intrinsics.checkNotNullExpressionValue((Object)passphrase, (String)"CRYPTIE_PASSPHRASE");
            PGPPrivateKey result$iv$iv = PGPSecretKeyExtensionsKt.unlock((PGPSecretKey)secKey, (Passphrase)passphrase);
            throwingSupplier = new ThrowingSupplier(result$iv$iv){
                final /* synthetic */ Object $result;
                {
                    this.$result = object;
                }

                public final PGPPrivateKey get() {
                    return this.$result;
                }
            };
        }
        catch (Throwable throwable$iv$iv) {
            throwingSupplier = new ThrowingSupplier(throwable$iv$iv){
                final /* synthetic */ Throwable $throwable;
                {
                    this.$throwable = throwable;
                }

                @NotNull
                public final Void get() {
                    throw this.$throwable;
                }
            };
        }
        PGPPrivateKey privKey = (PGPPrivateKey)Assertions.assertDoesNotThrow((ThrowingSupplier)throwingSupplier);
        Assertions.assertNotNull((Object)privKey);
    }

    @Test
    public final void cannot unlock protected secret key using empty passphrase() {
        Throwable throwable;
        Throwable throwable2;
        PGPSecretKeyRing key = TestKeys.getCryptieSecretKeyRing();
        PGPSecretKey secKey = key.getSecretKey();
        boolean $i$f$assertThrows = false;
        try {
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)secKey, (String)"secKey");
            PGPSecretKeyExtensionsKt.unlock((PGPSecretKey)secKey, (Passphrase)Passphrase.Companion.emptyPassphrase());
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable2 = caught$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        Throwable throwable$iv = throwable;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(WrongPassphraseException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
    }

    @Test
    public final void can successfully unlock unprotected secret key with unprotectedKeys protector() {
        ThrowingSupplier throwingSupplier;
        PGPSecretKeyRing key = TestKeys.getEmilSecretKeyRing();
        PGPSecretKey secKey = key.getSecretKey();
        boolean $i$f$assertDoesNotThrow = false;
        boolean $i$f$evaluateAndWrap = false;
        try {
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)secKey, (String)"secKey");
            PGPPrivateKey result$iv$iv = PGPSecretKeyExtensionsKt.unlock$default((PGPSecretKey)secKey, null, (int)1, null);
            throwingSupplier = new ThrowingSupplier(result$iv$iv){
                final /* synthetic */ Object $result;
                {
                    this.$result = object;
                }

                public final PGPPrivateKey get() {
                    return this.$result;
                }
            };
        }
        catch (Throwable throwable$iv$iv) {
            throwingSupplier = new ThrowingSupplier(throwable$iv$iv){
                final /* synthetic */ Throwable $throwable;
                {
                    this.$throwable = throwable;
                }

                @NotNull
                public final Void get() {
                    throw this.$throwable;
                }
            };
        }
        PGPPrivateKey privKey = (PGPPrivateKey)Assertions.assertDoesNotThrow((ThrowingSupplier)throwingSupplier);
        Assertions.assertNotNull((Object)privKey);
    }

    @Test
    public final void can successfully unlock unprotected secret key with empty passphrase() {
        ThrowingSupplier throwingSupplier;
        PGPSecretKeyRing key = TestKeys.getEmilSecretKeyRing();
        PGPSecretKey secKey = key.getSecretKey();
        boolean $i$f$assertDoesNotThrow = false;
        boolean $i$f$evaluateAndWrap = false;
        try {
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)secKey, (String)"secKey");
            PGPPrivateKey result$iv$iv = PGPSecretKeyExtensionsKt.unlock((PGPSecretKey)secKey, (Passphrase)Passphrase.Companion.emptyPassphrase());
            throwingSupplier = new ThrowingSupplier(result$iv$iv){
                final /* synthetic */ Object $result;
                {
                    this.$result = object;
                }

                public final PGPPrivateKey get() {
                    return this.$result;
                }
            };
        }
        catch (Throwable throwable$iv$iv) {
            throwingSupplier = new ThrowingSupplier(throwable$iv$iv){
                final /* synthetic */ Throwable $throwable;
                {
                    this.$throwable = throwable;
                }

                @NotNull
                public final Void get() {
                    throw this.$throwable;
                }
            };
        }
        PGPPrivateKey privKey = (PGPPrivateKey)Assertions.assertDoesNotThrow((ThrowingSupplier)throwingSupplier);
        Assertions.assertNotNull((Object)privKey);
    }

    @Test
    public final void openPgpFingerprint returns fitting fingerprint() {
        PGPSecretKeyRing key = TestKeys.getEmilSecretKeyRing();
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
        Assertions.assertEquals((Object)TestKeys.EMIL_FINGERPRINT, (Object)PGPKeyRingExtensionsKt.getOpenPgpFingerprint((PGPKeyRing)((PGPKeyRing)key)));
        PGPSecretKey pGPSecretKey = key.getSecretKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPSecretKey, (String)"key.secretKey");
        Assertions.assertEquals((Object)TestKeys.EMIL_FINGERPRINT, (Object)PGPSecretKeyExtensionsKt.getOpenPgpFingerprint((PGPSecretKey)pGPSecretKey));
    }

    @Test
    public final void publicKeyAlgorithm returns fitting algorithm() {
        PGPSecretKeyRing key = TestKeys.getEmilSecretKeyRing();
        PGPSecretKey pGPSecretKey = key.getSecretKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPSecretKey, (String)"key.secretKey");
        Assertions.assertEquals((Object)PublicKeyAlgorithm.ECDSA, (Object)PGPSecretKeyExtensionsKt.getPublicKeyAlgorithm((PGPSecretKey)pGPSecretKey));
    }
}

