/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.CustomPublicKeyDataDecryptorFactory;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.HardwareSecurity;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.util.Passphrase;

public class CustomPublicKeyDataDecryptorFactoryTest {
    @Test
    public void testDecryptionWithEmulatedHardwareDecryptionCallback() throws PGPException, IOException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        final PGPSecretKeyRing secretKey = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice");
        PGPPublicKeyRing cert = PGPainless.extractCertificate((PGPSecretKeyRing)secretKey);
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKey);
        final PGPPublicKey encryptionKey = (PGPPublicKey)info.getEncryptionSubkeys(EncryptionPurpose.ANY).get(0);
        String plaintext = "Hello, World!\n";
        ByteArrayOutputStream ciphertextOut = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)ciphertextOut).withOptions(ProducerOptions.encrypt((EncryptionOptions)EncryptionOptions.get().addRecipient(cert)));
        encryptionStream.write(plaintext.getBytes(StandardCharsets.UTF_8));
        encryptionStream.close();
        HardwareSecurity.DecryptionCallback hardwareDecryptionCallback = new HardwareSecurity.DecryptionCallback(){

            public byte[] decryptSessionKey(long keyId, int keyAlgorithm, byte[] sessionKeyData, int pkeskVersion) throws HardwareSecurity.HardwareSecurityException {
                try {
                    PGPSecretKey decryptionKey = secretKey.getSecretKey(encryptionKey.getKeyID());
                    PGPPrivateKey privateKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)decryptionKey, (Passphrase)Passphrase.emptyPassphrase());
                    BcPublicKeyDataDecryptorFactory internal = new BcPublicKeyDataDecryptorFactory(privateKey);
                    return internal.recoverSessionData(keyAlgorithm, (byte[][])new byte[][]{sessionKeyData}, pkeskVersion);
                }
                catch (PGPException e) {
                    throw new HardwareSecurity.HardwareSecurityException();
                }
            }
        };
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(ciphertextOut.toByteArray())).withOptions(ConsumerOptions.get().addCustomDecryptorFactory((CustomPublicKeyDataDecryptorFactory)new HardwareSecurity.HardwareDataDecryptorFactory(new SubkeyIdentifier((PGPKeyRing)cert, encryptionKey.getKeyID()), hardwareDecryptionCallback)));
        ByteArrayOutputStream decryptedOut = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)decryptedOut);
        decryptionStream.close();
        Assertions.assertEquals((Object)plaintext, (Object)decryptedOut.toString());
    }
}

