/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MessageMetadata;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionResult;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.key.SubkeyIdentifier;

public class HiddenRecipientEncryptionTest {
    @Test
    public void testAnonymousRecipientRoundtrip() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice <alice@pgpainless.org>");
        PGPPublicKeyRing certificate = PGPainless.extractCertificate((PGPSecretKeyRing)secretKeys);
        String msg = "Hello, World!\n";
        ByteArrayOutputStream ciphertextOut = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)ciphertextOut).withOptions(ProducerOptions.encrypt((EncryptionOptions)EncryptionOptions.get().addHiddenRecipient(certificate)));
        encryptionStream.write(msg.getBytes(StandardCharsets.UTF_8));
        encryptionStream.close();
        EncryptionResult result = encryptionStream.getResult();
        SubkeyIdentifier actualEncryptionKey = (SubkeyIdentifier)result.getRecipients().iterator().next();
        byte[] ciphertext = ciphertextOut.toByteArray();
        ByteArrayInputStream ciphertextIn = new ByteArrayInputStream(ciphertext);
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)ciphertextIn).withOptions(ConsumerOptions.get().addDecryptionKey(secretKeys));
        ByteArrayOutputStream plaintextOut = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)plaintextOut);
        decryptionStream.close();
        MessageMetadata metadata = decryptionStream.getMetadata();
        Assertions.assertEquals((Object)msg, (Object)plaintextOut.toString());
        Assertions.assertTrue((boolean)metadata.getRecipientKeyIds().contains(0L));
        Assertions.assertEquals((Object)actualEncryptionKey, (Object)metadata.getDecryptionKey());
    }
}

