/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.certification;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.List;
import org.bouncycastle.bcpg.sig.TrustSignature;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CertificationType;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.Trustworthiness;
import org.pgpainless.key.certification.CertifyCertificate;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.consumer.SignatureVerifier;
import org.pgpainless.signature.subpackets.CertificationSubpackets;
import org.pgpainless.util.CollectionUtils;
import org.pgpainless.util.DateUtil;

public class CertifyCertificateTest {
    @Test
    public void testUserIdCertification() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        UnprotectedKeysProtector protector = SecretKeyRingProtector.unprotectedKeys();
        PGPSecretKeyRing alice = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice <alice@pgpainless.org>");
        String bobUserId = "Bob <bob@pgpainless.org>";
        PGPSecretKeyRing bob = PGPainless.generateKeyRing().modernKeyRing((CharSequence)bobUserId);
        PGPPublicKeyRing bobCertificate = PGPainless.extractCertificate((PGPSecretKeyRing)bob);
        CertifyCertificate.CertificationResult result = PGPainless.certify().userIdOnCertificate(bobUserId, bobCertificate).withKey(alice, (SecretKeyRingProtector)protector).build();
        Assertions.assertNotNull((Object)result);
        PGPSignature signature = result.getCertification();
        Assertions.assertNotNull((Object)signature);
        Assertions.assertEquals((Object)SignatureType.GENERIC_CERTIFICATION, (Object)SignatureType.valueOf((int)signature.getSignatureType()));
        Assertions.assertEquals((long)alice.getPublicKey().getKeyID(), (long)signature.getKeyID());
        Assertions.assertTrue((boolean)SignatureVerifier.verifyUserIdCertification((CharSequence)bobUserId, (PGPSignature)signature, (PGPPublicKey)alice.getPublicKey(), (PGPPublicKey)bob.getPublicKey(), (Policy)PGPainless.getPolicy(), (Date)DateUtil.now()));
        PGPPublicKeyRing bobCertified = result.getCertifiedCertificate();
        PGPPublicKey bobCertifiedKey = bobCertified.getPublicKey();
        Assertions.assertEquals((int)2, (int)CollectionUtils.iteratorToList(bobCertifiedKey.getSignaturesForID(bobUserId)).size());
        List sigsByAlice = CollectionUtils.iteratorToList(bobCertifiedKey.getSignaturesForKeyID(alice.getPublicKey().getKeyID()));
        Assertions.assertEquals((int)1, (int)sigsByAlice.size());
        Assertions.assertEquals((Object)signature, sigsByAlice.get(0));
        Assertions.assertFalse((boolean)Arrays.areEqual((byte[])bobCertificate.getEncoded(), (byte[])bobCertified.getEncoded()));
    }

    @Test
    public void testKeyDelegation() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        UnprotectedKeysProtector protector = SecretKeyRingProtector.unprotectedKeys();
        PGPSecretKeyRing alice = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice <alice@pgpainless.org>");
        PGPSecretKeyRing bob = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Bob <bob@pgpainless.org>");
        PGPPublicKeyRing bobCertificate = PGPainless.extractCertificate((PGPSecretKeyRing)bob);
        CertifyCertificate.CertificationResult result = PGPainless.certify().certificate(bobCertificate, Trustworthiness.fullyTrusted().introducer()).withKey(alice, (SecretKeyRingProtector)protector).build();
        Assertions.assertNotNull((Object)result);
        PGPSignature signature = result.getCertification();
        Assertions.assertNotNull((Object)signature);
        Assertions.assertEquals((Object)SignatureType.DIRECT_KEY, (Object)SignatureType.valueOf((int)signature.getSignatureType()));
        Assertions.assertEquals((long)alice.getPublicKey().getKeyID(), (long)signature.getKeyID());
        TrustSignature trustSignaturePacket = signature.getHashedSubPackets().getTrust();
        Assertions.assertNotNull((Object)trustSignaturePacket);
        Trustworthiness trustworthiness = new Trustworthiness(trustSignaturePacket.getTrustAmount(), trustSignaturePacket.getDepth());
        Assertions.assertTrue((boolean)trustworthiness.isFullyTrusted());
        Assertions.assertTrue((boolean)trustworthiness.isIntroducer());
        Assertions.assertFalse((boolean)trustworthiness.canIntroduce(1));
        Assertions.assertTrue((boolean)SignatureVerifier.verifyDirectKeySignature((PGPSignature)signature, (PGPPublicKey)alice.getPublicKey(), (PGPPublicKey)bob.getPublicKey(), (Policy)PGPainless.getPolicy(), (Date)DateUtil.now()));
        PGPPublicKeyRing bobCertified = result.getCertifiedCertificate();
        PGPPublicKey bobCertifiedKey = bobCertified.getPublicKey();
        List sigsByAlice = CollectionUtils.iteratorToList(bobCertifiedKey.getSignaturesForKeyID(alice.getPublicKey().getKeyID()));
        Assertions.assertEquals((int)1, (int)sigsByAlice.size());
        Assertions.assertEquals((Object)signature, sigsByAlice.get(0));
        Assertions.assertFalse((boolean)Arrays.areEqual((byte[])bobCertificate.getEncoded(), (byte[])bobCertified.getEncoded()));
    }

    @Test
    public void testPetNameCertification() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing aliceKey = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice <alice@pgpainless.org>");
        PGPSecretKeyRing bobKey = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Bob <bob@pgpainless.org>");
        PGPPublicKeyRing bobCert = PGPainless.extractCertificate((PGPSecretKeyRing)bobKey);
        String petName = "Bobby";
        CertifyCertificate.CertificationResult result = PGPainless.certify().userIdOnCertificate(petName, bobCert).withKey(aliceKey, (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()).buildWithSubpackets(new CertificationSubpackets.Callback(){

            public void modifyHashedSubpackets(CertificationSubpackets hashedSubpackets) {
                hashedSubpackets.setExportable(false);
            }
        });
        PGPSignature certification = result.getCertification();
        Assertions.assertEquals((long)aliceKey.getPublicKey().getKeyID(), (long)certification.getKeyID());
        Assertions.assertEquals((int)CertificationType.GENERIC.asSignatureType().getCode(), (int)certification.getSignatureType());
        PGPPublicKeyRing certWithPetName = result.getCertifiedCertificate();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)certWithPetName);
        Assertions.assertTrue((boolean)info.getUserIds().contains(petName));
        Assertions.assertFalse((boolean)info.getValidUserIds().contains(petName));
    }

    @Test
    public void testScopedDelegation() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing aliceKey = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice <alice@pgpainless.org>");
        PGPSecretKeyRing caKey = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"CA <ca@example.com>");
        PGPPublicKeyRing caCert = PGPainless.extractCertificate((PGPSecretKeyRing)caKey);
        CertifyCertificate.CertificationResult result = PGPainless.certify().certificate(caCert, Trustworthiness.fullyTrusted().introducer()).withKey(aliceKey, (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()).buildWithSubpackets(new CertificationSubpackets.Callback(){

            public void modifyHashedSubpackets(CertificationSubpackets hashedSubpackets) {
                hashedSubpackets.setRegularExpression((CharSequence)"^.*<.+@example.com>.*$");
            }
        });
        PGPSignature certification = result.getCertification();
        Assertions.assertEquals((int)SignatureType.DIRECT_KEY.getCode(), (int)certification.getSignatureType());
        Assertions.assertEquals((Object)"^.*<.+@example.com>.*$", (Object)certification.getHashedSubPackets().getRegularExpression().getRegex());
    }
}

