/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MessageMetadata;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionResult;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.exception.KeyException;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa_legacy.EdDSALegacyCurve;
import org.pgpainless.key.generation.type.xdh_legacy.XDHLegacySpec;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;

public class GenerateKeyWithoutPrimaryKeyFlagsTest {
    @Test
    public void generateKeyWithoutCertifyKeyFlag_cannotCertifyThirdParties() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing secretKeys = ((KeyRingBuilder)((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA_LEGACY((EdDSALegacyCurve)EdDSALegacyCurve._Ed25519), (KeyFlag[])new KeyFlag[0]))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.EDDSA_LEGACY((EdDSALegacyCurve)EdDSALegacyCurve._Ed25519), (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA}))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.XDH_LEGACY((XDHLegacySpec)XDHLegacySpec._X25519), (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS}))).addUserId((CharSequence)"Alice").build();
        PGPPublicKeyRing cert = PGPainless.extractCertificate((PGPSecretKeyRing)secretKeys);
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertTrue((boolean)info.getValidUserIds().contains("Alice"));
        long primaryKeyId = info.getKeyId();
        Assertions.assertTrue((boolean)info.getKeyFlagsOf((CharSequence)"Alice").isEmpty());
        Assertions.assertTrue((boolean)info.getKeyFlagsOf(primaryKeyId).isEmpty());
        Assertions.assertFalse((boolean)info.isUsableForThirdPartyCertification());
        PGPPublicKeyRing thirdPartyCert = TestKeys.getCryptiePublicKeyRing();
        Assertions.assertThrows(KeyException.UnacceptableThirdPartyCertificationKeyException.class, () -> PGPainless.certify().certificate(thirdPartyCert).withKey(secretKeys, (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()));
        ByteArrayOutputStream ciphertext = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)ciphertext).withOptions(ProducerOptions.signAndEncrypt((EncryptionOptions)EncryptionOptions.get().addRecipient(cert), (SigningOptions)SigningOptions.get().addInlineSignature((SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys(), secretKeys, DocumentSignatureType.BINARY_DOCUMENT)));
        encryptionStream.write("Hello, World!\n".getBytes(StandardCharsets.UTF_8));
        encryptionStream.close();
        EncryptionResult result = encryptionStream.getResult();
        Assertions.assertTrue((boolean)result.isEncryptedFor(cert));
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(ciphertext.toByteArray())).withOptions(ConsumerOptions.get().addDecryptionKey(secretKeys).addVerificationCert(cert));
        ByteArrayOutputStream plaintext = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)plaintext);
        decryptionStream.close();
        MessageMetadata metadata = decryptionStream.getMetadata();
        Assertions.assertTrue((boolean)metadata.isEncryptedFor((PGPKeyRing)cert));
        Assertions.assertTrue((boolean)metadata.isVerifiedSignedBy((PGPKeyRing)cert));
    }
}

