/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.JUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MessageMetadata;
import org.pgpainless.decryption_verification.SignatureVerification;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionResult;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa_legacy.EdDSALegacyCurve;
import org.pgpainless.key.generation.type.xdh_legacy.XDHLegacySpec;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.timeframe.TestTimeFrameProvider;

public class GenerateKeyWithoutUserIdTest {
    @Test
    public void generateKeyWithoutUserId() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        Date now = new Date();
        Date expirationDate = TestTimeFrameProvider.defaultExpirationForCreationDate(now);
        PGPSecretKeyRing secretKey = ((KeyRingBuilder)((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA_LEGACY((EdDSALegacyCurve)EdDSALegacyCurve._Ed25519), (KeyFlag[])new KeyFlag[]{KeyFlag.CERTIFY_OTHER}).setKeyCreationDate(now))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.EDDSA_LEGACY((EdDSALegacyCurve)EdDSALegacyCurve._Ed25519), (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA}).setKeyCreationDate(now))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.XDH_LEGACY((XDHLegacySpec)XDHLegacySpec._X25519), (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE}).setKeyCreationDate(now))).setExpirationDate(expirationDate).build();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKey);
        Assertions.assertNull((Object)info.getPrimaryUserId());
        Assertions.assertTrue((boolean)info.getUserIds().isEmpty());
        JUtils.assertDateEquals(expirationDate, info.getPrimaryKeyExpirationDate());
        ByteArrayInputStream plaintextIn = new ByteArrayInputStream("Hello, World!\n".getBytes());
        ByteArrayOutputStream ciphertextOut = new ByteArrayOutputStream();
        UnprotectedKeysProtector protector = SecretKeyRingProtector.unprotectedKeys();
        PGPPublicKeyRing certificate = PGPainless.extractCertificate((PGPSecretKeyRing)secretKey);
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)ciphertextOut).withOptions(ProducerOptions.signAndEncrypt((EncryptionOptions)EncryptionOptions.get().addRecipient(certificate), (SigningOptions)SigningOptions.get().addSignature((SecretKeyRingProtector)protector, secretKey)));
        Streams.pipeAll((InputStream)plaintextIn, (OutputStream)encryptionStream);
        encryptionStream.close();
        EncryptionResult result = encryptionStream.getResult();
        Assertions.assertTrue((boolean)result.isEncryptedFor(certificate));
        ByteArrayInputStream ciphertextIn = new ByteArrayInputStream(ciphertextOut.toByteArray());
        ByteArrayOutputStream plaintextOut = new ByteArrayOutputStream();
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)ciphertextIn).withOptions(ConsumerOptions.get().addDecryptionKey(secretKey).addVerificationCert(certificate));
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)plaintextOut);
        decryptionStream.close();
        MessageMetadata metadata = decryptionStream.getMetadata();
        Assertions.assertTrue((boolean)metadata.isVerifiedSignedBy((PGPKeyRing)certificate), (String)GenerateKeyWithoutUserIdTest.failuresToString(metadata.getRejectedInlineSignatures()));
        Assertions.assertTrue((boolean)metadata.isEncrypted());
    }

    private static String failuresToString(List<SignatureVerification.Failure> failureList) {
        StringBuilder sb = new StringBuilder();
        for (SignatureVerification.Failure failure : failureList) {
            sb.append(failure.toString()).append('\n');
        }
        return sb.toString();
    }
}

