/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionResult;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.KeySpecBuilder;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.rsa.RsaLength;

public class StupidAlgorithmPreferenceEncryptionTest {
    private static final String STUPID_KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: 6CA6 C4F3 CF01 CAC9 C954  0BD6 5BDA 78ED C479 A8E9\nComment: This is Stupid\n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\nWFv0UlYdnSNZfY0vroIMxnM1w4XJVg==\n=4plS\n-----END PGP PRIVATE KEY BLOCK-----\n";

    @Test
    public void testPreventUnencryptedAlgorithmPreferenceDuringKeyGeneration() {
        KeySpecBuilder specBuilder = KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._4096), (KeyFlag[])new KeyFlag[]{KeyFlag.CERTIFY_OTHER});
        Assertions.assertThrows(IllegalArgumentException.class, () -> specBuilder.overridePreferredSymmetricKeyAlgorithms(new SymmetricKeyAlgorithm[]{SymmetricKeyAlgorithm.AES_256, SymmetricKeyAlgorithm.AES_192, SymmetricKeyAlgorithm.AES_128, SymmetricKeyAlgorithm.NULL}));
    }

    @Test
    public void testEncryptionIsNotUnencrypted() throws PGPException, IOException {
        PGPSecretKeyRing stupidKey = PGPainless.readKeyRing().secretKeyRing(STUPID_KEY);
        PGPPublicKeyRing certificate = PGPainless.extractCertificate((PGPSecretKeyRing)stupidKey);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.encrypt((EncryptionOptions)new EncryptionOptions().addRecipient(certificate)));
        encryptionStream.write("Hello".getBytes(StandardCharsets.UTF_8));
        encryptionStream.close();
        EncryptionResult metadata = encryptionStream.getResult();
        Assertions.assertTrue((boolean)metadata.isEncryptedFor(certificate));
        Assertions.assertEquals((Object)PGPainless.getPolicy().getSymmetricKeyEncryptionAlgorithmPolicy().getDefaultSymmetricKeyAlgorithm(), (Object)metadata.getEncryptionAlgorithm());
    }
}

