/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;

public class ChangePrimaryUserIdAndExpirationDatesTest {
    private static final long millisInHour = 3600000L;

    @Test
    public void generateA_primaryB_revokeA_cantSecondaryA() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"A");
        UnprotectedKeysProtector protector = SecretKeyRingProtector.unprotectedKeys();
        Date now = new Date();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys, (Date)now);
        Assertions.assertFalse((boolean)info.isHardRevoked((CharSequence)"A"));
        Assertions.assertFalse((boolean)info.isHardRevoked((CharSequence)"B"));
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("A", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsNotValid("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsNotPrimaryUserId("B", info);
        Date oneHourLater = new Date(now.getTime() + 3600000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys, (Date)oneHourLater).addPrimaryUserId((CharSequence)"B", (SecretKeyRingProtector)protector).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys, (Date)oneHourLater);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsNotPrimaryUserId("A", info);
        Date twoHoursLater = new Date(now.getTime() + 0x6DDD00L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys, (Date)twoHoursLater).revokeUserId((CharSequence)"A", (SecretKeyRingProtector)protector).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys, (Date)twoHoursLater);
        Assertions.assertTrue((boolean)info.isHardRevoked((CharSequence)"A"));
        Assertions.assertFalse((boolean)info.isHardRevoked((CharSequence)"B"));
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsNotValid("A", info);
        Date threeHoursLater = new Date(now.getTime() + 10800000L);
        PGPSecretKeyRing finalSecretKeys = secretKeys;
        Assertions.assertThrows(IllegalArgumentException.class, () -> ChangePrimaryUserIdAndExpirationDatesTest.lambda$generateA_primaryB_revokeA_cantSecondaryA$0(finalSecretKeys, threeHoursLater, (SecretKeyRingProtector)protector));
    }

    @Test
    public void generateA_primaryExpire_isExpired() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"A");
        UnprotectedKeysProtector protector = SecretKeyRingProtector.unprotectedKeys();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("A", info);
        Date now = new Date();
        Date later = new Date(now.getTime() + 3600000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys, (Date)now).setExpirationDate(later, (SecretKeyRingProtector)protector).done();
        Date evenLater = new Date(now.getTime() + 0x6DDD00L);
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys, (Date)evenLater);
        Assertions.assertFalse((boolean)info.isUserIdValid((CharSequence)"A"));
    }

    @Test
    public void generateA_primaryB_primaryExpire_bIsStillPrimary() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"A");
        UnprotectedKeysProtector protector = SecretKeyRingProtector.unprotectedKeys();
        Date now = new Date();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("A", info);
        Date t1 = new Date(now.getTime() + 3600000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys, (Date)t1).addPrimaryUserId((CharSequence)"B", (SecretKeyRingProtector)protector).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys, (Date)t1);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsNotPrimaryUserId("A", info);
        Date t2 = new Date(now.getTime() + 0x6DDD00L);
        Date expiration = new Date(now.getTime() + 36000000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys, (Date)t2).setExpirationDate(expiration, (SecretKeyRingProtector)protector).done();
        Date t3 = new Date(now.getTime() + 10800000L);
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys, (Date)t3);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsValid("A", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsValid("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsNotPrimaryUserId("A", info);
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys, (Date)expiration);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("B", info);
        Assertions.assertFalse((boolean)info.isUserIdValid((CharSequence)"A"));
        Assertions.assertFalse((boolean)info.isUserIdValid((CharSequence)"B"));
    }

    @Test
    public void generateA_expire_certify() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"A");
        UnprotectedKeysProtector protector = SecretKeyRingProtector.unprotectedKeys();
        Date now = new Date();
        Date t1 = new Date(now.getTime() + 3600000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys, (Date)now).setExpirationDate(t1, (SecretKeyRingProtector)protector).done();
        Date t2 = new Date(now.getTime() + 0x6DDD00L);
        Date t4 = new Date(now.getTime() + 14400000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys, (Date)t2).setExpirationDate(t4, (SecretKeyRingProtector)protector).done();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsValid("A", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("A", info);
    }

    @Test
    public void generateA_expire_primaryB_expire_isPrimaryB() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"A");
        UnprotectedKeysProtector protector = SecretKeyRingProtector.unprotectedKeys();
        Date now = new Date();
        Date t1 = new Date(now.getTime() + 3600000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys, (Date)t1).setExpirationDate(t1, (SecretKeyRingProtector)protector).done();
        Date t2 = new Date(now.getTime() + 0x6DDD00L);
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys, (Date)t2);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("A", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsNotValid("A", info);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys, (Date)t2).addPrimaryUserId((CharSequence)"B", (SecretKeyRingProtector)protector).done();
        Date t3 = new Date(now.getTime() + 10800000L);
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys, (Date)t3);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsNotValid("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsNotValid("A", info);
        Date t4 = new Date(now.getTime() + 14400000L);
        Date t5 = new Date(now.getTime() + 18000000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys, (Date)t3).setExpirationDate(t5, (SecretKeyRingProtector)protector).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys, (Date)t4);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsValid("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsValid("A", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("B", info);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys, (Date)t4).addUserId((CharSequence)"A", (SecretKeyRingProtector)protector).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys, (Date)t4);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsValid("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsValid("A", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("B", info);
    }

    private static void assertIsPrimaryUserId(String userId, KeyRingInfo info) {
        Assertions.assertEquals((Object)userId, (Object)info.getPrimaryUserId());
    }

    private static void assertIsNotPrimaryUserId(String userId, KeyRingInfo info) {
        PGPSignature signature = info.getLatestUserIdCertification((CharSequence)userId);
        if (signature == null) {
            return;
        }
        Assertions.assertFalse((boolean)signature.getHashedSubPackets().isPrimaryUserID());
    }

    private static void assertIsValid(String userId, KeyRingInfo info) {
        Assertions.assertTrue((boolean)info.isUserIdValid((CharSequence)userId));
    }

    private static void assertIsNotValid(String userId, KeyRingInfo info) {
        Assertions.assertFalse((boolean)info.isUserIdValid((CharSequence)userId));
    }

    private static /* synthetic */ void lambda$generateA_primaryB_revokeA_cantSecondaryA$0(PGPSecretKeyRing finalSecretKeys, Date threeHoursLater, SecretKeyRingProtector protector) throws Throwable {
        PGPainless.modifyKeyRing((PGPSecretKeyRing)finalSecretKeys, (Date)threeHoursLater).addUserId((CharSequence)"A", protector);
    }
}

