/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MessageMetadata;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionResult;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;

public class FixUserIdDoesNotBreakEncryptionCapabilityTest {
    private static final String SECRET_KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\n\nlFgEYsyc4hYJKwYBBAHaRw8BAQdAjm3bQ61H2E6/xzjjHjl6G+mNl72r7fwdux9f\nCXQrCpoAAQDwY5Vblm+7Dq8NfP5gqThyv+23aMBYLr3UgJAZyAgu/RDBtCQoQilv\nYiAoSilvaG5zb24gPGJqQGV2YWx1YXRpb24udGVzdD6IkAQTFggAOBYhBI70BlHo\nXvYV3ufIc8MDl+w8xmx4BQJizJziAhsjBQsJCAcCBhUKCQgLAgQWAgMBAh4BAheA\nAAoJEMMDl+w8xmx4ZAMBAIZsBqoClMlwymvNWIENCAZMQSy9NpBABk3jDyEjbhgs\nAP9sGI7URQNUDXiV+sIzvastNX/nOZ7fkwp6Xrx+74WxC5xdBGLMnOISCisGAQQB\nl1UBBQEBB0CGU2EGdS4mvy0apuPukStWSqEDH16AFSGEeTt2GyN1IQMBCAcAAP9J\nnrIGndqzxxIUHVsoImYIu9SFl9Z1tCSia6mADTtbsA88iHgEGBYIACAWIQSO9AZR\n6F72Fd7nyHPDA5fsPMZseAUCYsyc4gIbDAAKCRDDA5fsPMZseACnAQDIR7QwBTIs\nHfu4XIpZTyipOy6ZOEKlY3akyb9TtOq1wAD8Da+0Insssuf0J5WPqShJ/wMX3+xk\ngqeRV2HyogQ7aAE=\n=6zZo\n-----END PGP PRIVATE KEY BLOCK-----\n";
    private static final String CERTIFICATE = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmDMEYsyc4hYJKwYBBAHaRw8BAQdAjm3bQ61H2E6/xzjjHjl6G+mNl72r7fwdux9f\nCXQrCpq0JChCKW9iIChKKW9obnNvbiA8YmpAZXZhbHVhdGlvbi50ZXN0PoiQBBMW\nCAA4FiEEjvQGUehe9hXe58hzwwOX7DzGbHgFAmLMnOICGyMFCwkIBwIGFQoJCAsC\nBBYCAwECHgECF4AACgkQwwOX7DzGbHhkAwEAhmwGqgKUyXDKa81YgQ0IBkxBLL02\nkEAGTeMPISNuGCwA/2wYjtRFA1QNeJX6wjO9qy01f+c5nt+TCnpevH7vhbELuDgE\nYsyc4hIKKwYBBAGXVQEFAQEHQIZTYQZ1Lia/LRqm4+6RK1ZKoQMfXoAVIYR5O3Yb\nI3UhAwEIB4h4BBgWCAAgFiEEjvQGUehe9hXe58hzwwOX7DzGbHgFAmLMnOICGwwA\nCgkQwwOX7DzGbHgApwEAyEe0MAUyLB37uFyKWU8oqTsumThCpWN2pMm/U7TqtcAA\n/A2vtCJ7LLLn9CeVj6koSf8DF9/sZIKnkVdh8qIEO2gB\n=3sNT\n-----END PGP PUBLIC KEY BLOCK-----";
    private static final String userIdBefore = "(B)ob (J)ohnson <bj@evaluation.test>";
    private static final String userIdAfter = "\"(B)ob (J)ohnson\" <bj@evaluation.test>";

    @Test
    public void manualReplaceUserIdWithFixedVersionDoesNotHinderEncryptionCapability() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(SECRET_KEY);
        UnprotectedKeysProtector protector = SecretKeyRingProtector.unprotectedKeys();
        PGPSecretKeyRing modified = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addUserId((CharSequence)userIdAfter, new SelfSignatureSubpackets.Callback(){

            public void modifyHashedSubpackets(SelfSignatureSubpackets hashedSubpackets) {
                hashedSubpackets.setPrimaryUserId();
            }
        }, (SecretKeyRingProtector)protector).removeUserId((CharSequence)userIdBefore, (SecretKeyRingProtector)protector).done();
        KeyRingInfo before = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        KeyRingInfo after = PGPainless.inspectKeyRing((PGPKeyRing)modified);
        Assertions.assertTrue((boolean)before.isUsableForEncryption());
        Assertions.assertTrue((boolean)before.isUsableForSigning());
        Assertions.assertTrue((boolean)before.isUserIdValid((CharSequence)userIdBefore));
        Assertions.assertFalse((boolean)before.isUserIdValid((CharSequence)userIdAfter));
        Assertions.assertTrue((boolean)after.isUsableForEncryption());
        Assertions.assertTrue((boolean)after.isUsableForSigning());
        Assertions.assertFalse((boolean)after.isUserIdValid((CharSequence)userIdBefore));
        Assertions.assertTrue((boolean)after.isUserIdValid((CharSequence)userIdAfter));
    }

    @Test
    public void testReplaceUserId_missingOldUserIdThrows() throws IOException {
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(SECRET_KEY);
        Assertions.assertThrows(NoSuchElementException.class, () -> PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).replaceUserId((CharSequence)"missing", (CharSequence)userIdAfter, (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()));
    }

    @Test
    public void testReplaceUserId_emptyOldUserIdThrows() throws IOException {
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(SECRET_KEY);
        Assertions.assertThrows(IllegalArgumentException.class, () -> PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).replaceUserId((CharSequence)"     ", (CharSequence)userIdAfter, (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()));
    }

    @Test
    public void testReplaceUserId_emptyNewUserIdThrows() throws IOException {
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(SECRET_KEY);
        Assertions.assertThrows(IllegalArgumentException.class, () -> PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).replaceUserId((CharSequence)userIdBefore, (CharSequence)"     ", (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()));
    }

    @Test
    public void testReplaceImplicitUserIdDoesNotBreakStuff() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(SECRET_KEY);
        PGPSecretKeyRing edited = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).replaceUserId((CharSequence)userIdBefore, (CharSequence)userIdAfter, (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()).done();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)edited);
        Assertions.assertTrue((boolean)info.isUserIdValid((CharSequence)userIdAfter));
        Assertions.assertEquals((Object)userIdAfter, (Object)info.getPrimaryUserId());
        PGPSignature latestCertification = info.getLatestUserIdCertification((CharSequence)userIdAfter);
        Assertions.assertNotNull((Object)latestCertification);
        Assertions.assertTrue((boolean)latestCertification.getHashedSubPackets().isPrimaryUserID());
        PGPPublicKeyRing cert = PGPainless.extractCertificate((PGPSecretKeyRing)edited);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.encrypt((EncryptionOptions)new EncryptionOptions().addRecipient(cert)));
        encryptionStream.write("Hello".getBytes(StandardCharsets.UTF_8));
        encryptionStream.close();
        EncryptionResult result = encryptionStream.getResult();
        Assertions.assertTrue((boolean)result.isEncryptedFor(cert));
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ByteArrayOutputStream plain = new ByteArrayOutputStream();
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)in).withOptions(new ConsumerOptions().addDecryptionKey(edited));
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)plain);
        decryptionStream.close();
        MessageMetadata metadata = decryptionStream.getMetadata();
        Assertions.assertTrue((boolean)metadata.isEncrypted());
    }
}

