/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.EnumMap;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditor;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditorInterface;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.policy.Policy;
import org.pgpainless.util.Passphrase;

public class RefuseToAddWeakSubkeyTest {
    @Test
    public void testEditorRefusesToAddWeakSubkey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPainless.getPolicy().setPublicKeyAlgorithmPolicy(Policy.PublicKeyAlgorithmPolicy.bsi2021PublicKeyAlgorithmPolicy());
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice");
        SecretKeyRingEditor editor = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys);
        KeySpec spec = KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._1024), (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_COMMS}).build();
        Assertions.assertThrows(IllegalArgumentException.class, () -> RefuseToAddWeakSubkeyTest.lambda$testEditorRefusesToAddWeakSubkey$0((SecretKeyRingEditorInterface)editor, spec));
    }

    @Test
    public void testEditorAllowsToAddWeakSubkeyIfCompliesToPublicKeyAlgorithmPolicy() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing((CharSequence)"Alice");
        EnumMap<PublicKeyAlgorithm, Integer> minimalBitStrengths = new EnumMap<PublicKeyAlgorithm, Integer>(PublicKeyAlgorithm.class);
        minimalBitStrengths.put(PublicKeyAlgorithm.RSA_GENERAL, 1024);
        minimalBitStrengths.put(PublicKeyAlgorithm.RSA_SIGN, 1024);
        minimalBitStrengths.put(PublicKeyAlgorithm.RSA_ENCRYPT, 1024);
        minimalBitStrengths.put(PublicKeyAlgorithm.ELGAMAL_ENCRYPT, 2000);
        minimalBitStrengths.put(PublicKeyAlgorithm.ELGAMAL_GENERAL, 2000);
        minimalBitStrengths.put(PublicKeyAlgorithm.DSA, 2000);
        minimalBitStrengths.put(PublicKeyAlgorithm.ECDSA, 250);
        minimalBitStrengths.put(PublicKeyAlgorithm.EDDSA_LEGACY, 250);
        minimalBitStrengths.put(PublicKeyAlgorithm.DIFFIE_HELLMAN, 2000);
        minimalBitStrengths.put(PublicKeyAlgorithm.ECDH, 250);
        PGPainless.getPolicy().setPublicKeyAlgorithmPolicy(new Policy.PublicKeyAlgorithmPolicy(minimalBitStrengths));
        SecretKeyRingEditor editor = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys);
        KeySpec spec = KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._1024), (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_COMMS}).setKeyCreationDate(editor.getReferenceTime()).build();
        secretKeys = editor.addSubKey(spec, Passphrase.emptyPassphrase(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()).done();
        Assertions.assertEquals((int)2, (int)PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getEncryptionSubkeys(EncryptionPurpose.ANY).size());
        PGPainless.getPolicy().setPublicKeyAlgorithmPolicy(Policy.PublicKeyAlgorithmPolicy.bsi2021PublicKeyAlgorithmPolicy());
    }

    private static /* synthetic */ void lambda$testEditorRefusesToAddWeakSubkey$0(SecretKeyRingEditorInterface editor, KeySpec spec) throws Throwable {
        editor.addSubKey(spec, Passphrase.emptyPassphrase(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys());
    }
}

