/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.pgpainless.util.Passphrase;

public class PassphraseTest {
    @Test
    public void testGetAndClear() {
        Passphrase passphrase = new Passphrase("secret".toCharArray());
        Assertions.assertArrayEquals((char[])"secret".toCharArray(), (char[])passphrase.getChars());
        Assertions.assertTrue((boolean)passphrase.isValid());
        passphrase.clear();
        Assertions.assertFalse((boolean)passphrase.isValid());
        Assertions.assertThrows(IllegalStateException.class, () -> ((Passphrase)passphrase).getChars());
    }

    @Test
    public void testTrimming() {
        Passphrase leadingSpace = Passphrase.fromPassword((CharSequence)" space").withTrimmedWhitespace();
        Assertions.assertArrayEquals((char[])"space".toCharArray(), (char[])leadingSpace.getChars());
        Assertions.assertFalse((boolean)leadingSpace.isEmpty());
        Passphrase trailingSpace = Passphrase.fromPassword((CharSequence)"space ").withTrimmedWhitespace();
        Assertions.assertArrayEquals((char[])"space".toCharArray(), (char[])trailingSpace.getChars());
        Assertions.assertFalse((boolean)trailingSpace.isEmpty());
        Passphrase leadingTrailingWhitespace = new Passphrase("\t Such whitespace, much wow\n ".toCharArray()).withTrimmedWhitespace();
        Assertions.assertArrayEquals((char[])"Such whitespace, much wow".toCharArray(), (char[])leadingTrailingWhitespace.getChars());
        Assertions.assertFalse((boolean)leadingTrailingWhitespace.isEmpty());
        Passphrase fromEmptyChars = new Passphrase("     ".toCharArray()).withTrimmedWhitespace();
        Assertions.assertNull((Object)fromEmptyChars.getChars());
        Assertions.assertTrue((boolean)fromEmptyChars.isEmpty());
    }

    @ParameterizedTest
    @ValueSource(strings={"", " ", "  ", "\t", "\t\t"})
    public void testEmptyPassphrases(String empty) {
        Passphrase passphrase = Passphrase.fromPassword((CharSequence)empty).withTrimmedWhitespace();
        Assertions.assertTrue((boolean)passphrase.isEmpty());
        Assertions.assertEquals((Object)Passphrase.emptyPassphrase(), (Object)passphrase);
    }

    @Test
    public void equalsTest() {
        Assertions.assertNotEquals((Object)Passphrase.fromPassword((CharSequence)"passphrase"), (Object)Passphrase.fromPassword((CharSequence)"Password"));
        Assertions.assertNotEquals((Object)Passphrase.fromPassword((CharSequence)"password"), null);
        Assertions.assertNotEquals((Object)Passphrase.fromPassword((CharSequence)"password"), (Object)"password");
        Passphrase passphrase = Passphrase.fromPassword((CharSequence)"passphrase");
        Assertions.assertEquals((Object)passphrase, (Object)passphrase);
    }

    @Test
    public void hashCodeTest() {
        Assertions.assertNotEquals((int)0, (int)Passphrase.fromPassword((CharSequence)"passphrase").hashCode());
        Assertions.assertNotEquals((int)Passphrase.fromPassword((CharSequence)"passphrase").hashCode(), (int)Passphrase.fromPassword((CharSequence)"password").hashCode());
        Assertions.assertEquals((int)0, (int)Passphrase.emptyPassphrase().hashCode());
    }
}

