/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pgpainless.PGPainless;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.CachingSecretKeyRingProtector;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.TestAllImplementations;

public class SecretKeyRingProtectorTest {
    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void testUnlockAllKeysWithSamePassword() throws IOException, PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        SecretKeyRingProtector protector = SecretKeyRingProtector.unlockEachKeyWith((Passphrase)TestKeys.CRYPTIE_PASSPHRASE, (PGPSecretKeyRing)secretKeys);
        for (PGPSecretKey secretKey : secretKeys) {
            PBESecretKeyDecryptor decryptor = protector.getDecryptor(secretKey.getKeyID());
            Assertions.assertNotNull((Object)decryptor);
            secretKey.extractPrivateKey(decryptor);
        }
        PGPSecretKeyRing unrelatedKeys = PGPainless.generateKeyRing().simpleEcKeyRing((CharSequence)"unrelated", "SecurePassword");
        for (PGPSecretKey unrelatedKey : unrelatedKeys) {
            PBESecretKeyDecryptor decryptor = protector.getDecryptor(unrelatedKey.getKeyID());
            Assertions.assertNull((Object)decryptor);
            Assertions.assertThrows(PGPException.class, () -> unrelatedKey.extractPrivateKey(protector.getDecryptor(unrelatedKey.getKeyID())));
        }
    }

    @Test
    public void testUnprotectedKeys() throws PGPException {
        Random random = new Random();
        UnprotectedKeysProtector protector = SecretKeyRingProtector.unprotectedKeys();
        for (int i = 0; i < 10; ++i) {
            Long keyId = random.nextLong();
            Assertions.assertNull((Object)protector.getEncryptor(keyId.longValue()));
            Assertions.assertNull((Object)protector.getDecryptor(keyId.longValue()));
        }
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void testUnlockSingleKeyWithPassphrase() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        Iterator iterator = secretKeys.iterator();
        PGPSecretKey secretKey = (PGPSecretKey)iterator.next();
        PGPSecretKey subKey = (PGPSecretKey)iterator.next();
        SecretKeyRingProtector protector = SecretKeyRingProtector.unlockSingleKeyWith((Passphrase)TestKeys.CRYPTIE_PASSPHRASE, (PGPSecretKey)secretKey);
        Assertions.assertNotNull((Object)protector.getDecryptor(secretKey.getKeyID()));
        Assertions.assertNotNull((Object)protector.getEncryptor(secretKey.getKeyID()));
        Assertions.assertNull((Object)protector.getEncryptor(subKey.getKeyID()));
        Assertions.assertNull((Object)protector.getDecryptor(subKey.getKeyID()));
    }

    @Test
    public void testFromPassphraseMap() {
        ConcurrentHashMap<Long, Passphrase> passphraseMap = new ConcurrentHashMap<Long, Passphrase>();
        passphraseMap.put(1L, Passphrase.emptyPassphrase());
        CachingSecretKeyRingProtector protector = (CachingSecretKeyRingProtector)SecretKeyRingProtector.fromPassphraseMap(passphraseMap);
        Assertions.assertNotNull((Object)protector.getPassphraseFor(Long.valueOf(1L)));
        Assertions.assertNull((Object)protector.getPassphraseFor(Long.valueOf(5L)));
        protector.addPassphrase(5L, Passphrase.fromPassword((CharSequence)"pa55w0rd"));
        protector.forgetPassphrase(1L);
        Assertions.assertNull((Object)protector.getPassphraseFor(Long.valueOf(1L)));
        Assertions.assertNotNull((Object)protector.getPassphraseFor(Long.valueOf(5L)));
    }

    @Test
    public void testMissingPassphraseCallback() {
        ConcurrentHashMap<Long, Passphrase> passphraseMap = new ConcurrentHashMap<Long, Passphrase>();
        passphraseMap.put(1L, Passphrase.emptyPassphrase());
        CachingSecretKeyRingProtector protector = new CachingSecretKeyRingProtector(passphraseMap, KeyRingProtectionSettings.secureDefaultSettings(), new SecretKeyPassphraseProvider(){

            public Passphrase getPassphraseFor(Long keyId) {
                return Passphrase.fromPassword((CharSequence)"missingP455w0rd");
            }

            public boolean hasPassphrase(Long keyId) {
                return true;
            }
        });
        Assertions.assertEquals((Object)Passphrase.emptyPassphrase(), (Object)protector.getPassphraseFor(Long.valueOf(1L)));
        Assertions.assertEquals((Object)Passphrase.fromPassword((CharSequence)"missingP455w0rd"), (Object)protector.getPassphraseFor(Long.valueOf(3L)));
    }
}

