/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.util.KeyRingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BCUtilTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(BCUtilTest.class);

    @Test
    public void keyRingToCollectionTest() throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        PGPSecretKeyRing sec = ((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._3072), (KeyFlag[])new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA}))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._3072), (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_COMMS}))).addUserId((CharSequence)"donald@duck.tails").build();
        PGPPublicKeyRing pub = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)sec);
        Assertions.assertEquals((long)sec.getPublicKey().getKeyID(), (long)pub.getPublicKey().getKeyID());
        int secSize = 1;
        Iterator secPubIt = sec.getPublicKeys();
        while (secPubIt.hasNext()) {
            PGPPublicKey k = (PGPPublicKey)secPubIt.next();
            LOGGER.debug("Index {}, keyId {}, isEncryptionKey={}, isPrimary={}", new Object[]{secSize, k.getKeyID(), k.isEncryptionKey(), k.isMasterKey()});
            ++secSize;
        }
        LOGGER.debug("After BCUtil.publicKeyRingFromSecretKeyRing()");
        int pubSize = 1;
        Iterator pubPubIt = pub.getPublicKeys();
        while (pubPubIt.hasNext()) {
            PGPPublicKey k = (PGPPublicKey)pubPubIt.next();
            LOGGER.debug("Index {}, keyId {}, isEncryptionKey={}, isPrimary={}", new Object[]{pubSize, k.getKeyID(), k.isEncryptionKey(), k.isMasterKey()});
            ++pubSize;
        }
        Assertions.assertEquals((int)secSize, (int)pubSize);
        PGPSecretKeyRingCollection secCol = KeyRingUtils.keyRingsToKeyRingCollection((PGPSecretKeyRing[])new PGPSecretKeyRing[]{sec});
        int secColSize = 0;
        Iterator secColIt = secCol.getKeyRings();
        while (secColIt.hasNext()) {
            PGPSecretKeyRing r = (PGPSecretKeyRing)secColIt.next();
            LOGGER.debug("{}", (Object)r.getPublicKey().getKeyID());
            ++secColSize;
        }
        PGPPublicKeyRingCollection pubCol = KeyRingUtils.keyRingsToKeyRingCollection((PGPPublicKeyRing[])new PGPPublicKeyRing[]{pub});
        int pubColSize = 0;
        Iterator pubColIt = pubCol.getKeyRings();
        while (pubColIt.hasNext()) {
            PGPPublicKeyRing r = (PGPPublicKeyRing)pubColIt.next();
            LOGGER.debug("{}", (Object)r.getPublicKey().getKeyID());
            ++pubColSize;
        }
        Assertions.assertEquals((int)pubColSize, (int)secColSize);
    }

    @Test
    public void constantTimeAreEqualsTest() {
        char[] b = "Hello".toCharArray();
        Assertions.assertTrue((boolean)Arrays.constantTimeAreEqual((char[])b, (char[])b));
        Assertions.assertTrue((boolean)Arrays.constantTimeAreEqual((char[])"Hello".toCharArray(), (char[])"Hello".toCharArray()));
        Assertions.assertTrue((boolean)Arrays.constantTimeAreEqual((char[])new char[0], (char[])new char[0]));
        Assertions.assertTrue((boolean)Arrays.constantTimeAreEqual((char[])new char[]{'H', 'e', 'l', 'l', 'o'}, (char[])"Hello".toCharArray()));
        Assertions.assertFalse((boolean)Arrays.constantTimeAreEqual((char[])"Hello".toCharArray(), (char[])"Hello World".toCharArray()));
        Assertions.assertFalse((boolean)Arrays.constantTimeAreEqual(null, (char[])"Hello".toCharArray()));
        Assertions.assertFalse((boolean)Arrays.constantTimeAreEqual((char[])"Hello".toCharArray(), null));
        Assertions.assertFalse((boolean)Arrays.constantTimeAreEqual((char[])null, null));
    }
}

