/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util.selection.userid;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.UserId;
import org.pgpainless.util.selection.userid.SelectUserId;

public class SelectUserIdTest {
    @Test
    public void testSelectUserIds() throws PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing((CharSequence)"<alice@wonderland.lit>");
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addUserId((CharSequence)UserId.newBuilder().withName("Alice Liddell").noComment().withEmail("crazy@the-rabbit.hole").build(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()).done();
        List userIds = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getValidUserIds();
        List validEmail = userIds.stream().filter(SelectUserId.and((SelectUserId[])new SelectUserId[]{SelectUserId.validUserId((PGPKeyRing)secretKeys), SelectUserId.containsEmailAddress((CharSequence)"alice@wonderland.lit")})).collect(Collectors.toList());
        Assertions.assertEquals(Collections.singletonList("<alice@wonderland.lit>"), validEmail);
        List startsWithAlice = userIds.stream().filter(SelectUserId.startsWith((CharSequence)"Alice")).collect(Collectors.toList());
        Assertions.assertEquals(Collections.singletonList("Alice Liddell <crazy@the-rabbit.hole>"), startsWithAlice);
        List exactMatch = userIds.stream().filter(SelectUserId.or((SelectUserId[])new SelectUserId[]{SelectUserId.exactMatch((CharSequence)"<alice@wonderland.lit>"), SelectUserId.startsWith((CharSequence)"Not Found")})).collect(Collectors.toList());
        Assertions.assertEquals(Collections.singletonList("<alice@wonderland.lit>"), exactMatch);
    }

    @Test
    public void testContainsSubstring() throws PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing((CharSequence)"wine drinker");
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addUserId((CharSequence)"this is not a quine", (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()).addUserId((CharSequence)"this is not a crime", (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()).done();
        List userIds = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getValidUserIds();
        List containSubstring = userIds.stream().filter(SelectUserId.containsSubstring((CharSequence)"ine")).collect(Collectors.toList());
        Assertions.assertEquals(Arrays.asList("wine drinker", "this is not a quine"), containSubstring);
    }

    @Test
    public void testContainsEmailAddress() {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing((CharSequence)"Alice <alice@wonderland.lit>");
        List userIds = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getValidUserIds();
        Assertions.assertEquals((Object)"Alice <alice@wonderland.lit>", userIds.stream().filter(SelectUserId.containsEmailAddress((CharSequence)"alice@wonderland.lit")).findFirst().get());
        Assertions.assertEquals((Object)"Alice <alice@wonderland.lit>", userIds.stream().filter(SelectUserId.containsEmailAddress((CharSequence)"<alice@wonderland.lit>")).findFirst().get());
        Assertions.assertFalse((boolean)userIds.stream().anyMatch(SelectUserId.containsEmailAddress((CharSequence)"mad@hatter.lit")));
    }

    @Test
    public void testAndOrNot() throws PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing((CharSequence)"Alice <alice@wonderland.lit>");
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addUserId((CharSequence)"Alice <another@email.address>", (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()).addUserId((CharSequence)"<crazy@the-rabbit.hole>", (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()).addUserId((CharSequence)"Crazy Girl <alice@wonderland.lit>", (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()).done();
        List userIds = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getValidUserIds();
        List or = userIds.stream().filter(SelectUserId.or((SelectUserId[])new SelectUserId[]{SelectUserId.containsEmailAddress((CharSequence)"alice@wonderland.lit"), SelectUserId.startsWith((CharSequence)"Alice")})).collect(Collectors.toList());
        Assertions.assertEquals(Arrays.asList("Alice <alice@wonderland.lit>", "Alice <another@email.address>", "Crazy Girl <alice@wonderland.lit>"), or);
        List and = userIds.stream().filter(SelectUserId.and((SelectUserId[])new SelectUserId[]{SelectUserId.containsEmailAddress((CharSequence)"alice@wonderland.lit"), SelectUserId.startsWith((CharSequence)"Alice")})).collect(Collectors.toList());
        Assertions.assertEquals(Collections.singletonList("Alice <alice@wonderland.lit>"), and);
        List not = userIds.stream().filter(SelectUserId.not((SelectUserId)SelectUserId.startsWith((CharSequence)"Alice"))).collect(Collectors.toList());
        Assertions.assertEquals(Arrays.asList("<crazy@the-rabbit.hole>", "Crazy Girl <alice@wonderland.lit>"), not);
    }

    @Test
    public void testFirstMatch() throws PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing((CharSequence)"First UserID");
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addUserId((CharSequence)"Second UserID", (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys()).done();
        List userIds = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getValidUserIds();
        Assertions.assertEquals((Object)"First UserID", userIds.stream().filter(SelectUserId.validUserId((PGPKeyRing)secretKeys)).findFirst().get());
        Assertions.assertEquals((Object)"Second UserID", userIds.stream().filter(SelectUserId.containsSubstring((CharSequence)"Second")).findFirst().get());
    }

    @Test
    public void testByEmail() {
        SelectUserId containsEmailAddress = SelectUserId.containsEmailAddress((CharSequence)"alice@pgpainless.org");
        Assertions.assertTrue((boolean)containsEmailAddress.accept("<alice@pgpainless.org>"));
        Assertions.assertTrue((boolean)containsEmailAddress.accept("Alice <alice@pgpainless.org>"));
        SelectUserId byEmail = SelectUserId.byEmail((CharSequence)"alice@pgpainless.org");
        Assertions.assertTrue((boolean)byEmail.accept("alice@pgpainless.org"));
        Assertions.assertTrue((boolean)byEmail.accept("<alice@pgpainless.org>"));
        Assertions.assertTrue((boolean)byEmail.accept("Alice <alice@pgpainless.org>"));
    }
}

