/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.signature.SignatureUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/pgpainless/decryption_verification/SignatureVerification;", "", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "signingKey", "Lorg/pgpainless/key/SubkeyIdentifier;", "(Lorg/bouncycastle/openpgp/PGPSignature;Lorg/pgpainless/key/SubkeyIdentifier;)V", "getSignature", "()Lorg/bouncycastle/openpgp/PGPSignature;", "getSigningKey", "()Lorg/pgpainless/key/SubkeyIdentifier;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Failure", "pgpainless-core"})
public final class SignatureVerification {
    @NotNull
    private final PGPSignature signature;
    @NotNull
    private final SubkeyIdentifier signingKey;

    public SignatureVerification(@NotNull PGPSignature signature, @NotNull SubkeyIdentifier signingKey) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        this.signature = signature;
        this.signingKey = signingKey;
    }

    @NotNull
    public final PGPSignature getSignature() {
        return this.signature;
    }

    @NotNull
    public final SubkeyIdentifier getSigningKey() {
        return this.signingKey;
    }

    @NotNull
    public String toString() {
        return "Signature: " + SignatureUtils.Companion.getSignatureDigestPrefix(this.signature) + "; Key: " + this.signingKey + ";";
    }

    @NotNull
    public final PGPSignature component1() {
        return this.signature;
    }

    @NotNull
    public final SubkeyIdentifier component2() {
        return this.signingKey;
    }

    @NotNull
    public final SignatureVerification copy(@NotNull PGPSignature signature, @NotNull SubkeyIdentifier signingKey) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        return new SignatureVerification(signature, signingKey);
    }

    public static /* synthetic */ SignatureVerification copy$default(SignatureVerification signatureVerification, PGPSignature pGPSignature, SubkeyIdentifier subkeyIdentifier, int n, Object object) {
        if ((n & 1) != 0) {
            pGPSignature = signatureVerification.signature;
        }
        if ((n & 2) != 0) {
            subkeyIdentifier = signatureVerification.signingKey;
        }
        return signatureVerification.copy(pGPSignature, subkeyIdentifier);
    }

    public int hashCode() {
        int result = this.signature.hashCode();
        result = result * 31 + this.signingKey.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SignatureVerification)) {
            return false;
        }
        SignatureVerification signatureVerification = (SignatureVerification)other;
        if (!Intrinsics.areEqual((Object)this.signature, (Object)signatureVerification.signature)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.signingKey, (Object)signatureVerification.signingKey);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J)\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/pgpainless/decryption_verification/SignatureVerification$Failure;", "", "verification", "Lorg/pgpainless/decryption_verification/SignatureVerification;", "validationException", "Lorg/pgpainless/exception/SignatureValidationException;", "(Lorg/pgpainless/decryption_verification/SignatureVerification;Lorg/pgpainless/exception/SignatureValidationException;)V", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "signingKey", "Lorg/pgpainless/key/SubkeyIdentifier;", "(Lorg/bouncycastle/openpgp/PGPSignature;Lorg/pgpainless/key/SubkeyIdentifier;Lorg/pgpainless/exception/SignatureValidationException;)V", "getSignature", "()Lorg/bouncycastle/openpgp/PGPSignature;", "getSigningKey", "()Lorg/pgpainless/key/SubkeyIdentifier;", "getValidationException", "()Lorg/pgpainless/exception/SignatureValidationException;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "pgpainless-core"})
    public static final class Failure {
        @NotNull
        private final PGPSignature signature;
        @Nullable
        private final SubkeyIdentifier signingKey;
        @NotNull
        private final SignatureValidationException validationException;

        public Failure(@NotNull PGPSignature signature, @Nullable SubkeyIdentifier signingKey, @NotNull SignatureValidationException validationException) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)((Object)validationException), (String)"validationException");
            this.signature = signature;
            this.signingKey = signingKey;
            this.validationException = validationException;
        }

        @NotNull
        public final PGPSignature getSignature() {
            return this.signature;
        }

        @Nullable
        public final SubkeyIdentifier getSigningKey() {
            return this.signingKey;
        }

        @NotNull
        public final SignatureValidationException getValidationException() {
            return this.validationException;
        }

        public Failure(@NotNull SignatureVerification verification, @NotNull SignatureValidationException validationException) {
            Intrinsics.checkNotNullParameter((Object)verification, (String)"verification");
            Intrinsics.checkNotNullParameter((Object)((Object)validationException), (String)"validationException");
            this(verification.getSignature(), verification.getSigningKey(), validationException);
        }

        @NotNull
        public String toString() {
            String string = SignatureUtils.Companion.getSignatureDigestPrefix(this.signature);
            Object object = this.signingKey;
            if (object == null || (object = ((SubkeyIdentifier)object).toString()) == null) {
                object = "null";
            }
            return "Signature: " + string + "; Key: " + (String)object + "; Failure: " + this.validationException.getMessage();
        }

        @NotNull
        public final PGPSignature component1() {
            return this.signature;
        }

        @Nullable
        public final SubkeyIdentifier component2() {
            return this.signingKey;
        }

        @NotNull
        public final SignatureValidationException component3() {
            return this.validationException;
        }

        @NotNull
        public final Failure copy(@NotNull PGPSignature signature, @Nullable SubkeyIdentifier signingKey, @NotNull SignatureValidationException validationException) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)((Object)validationException), (String)"validationException");
            return new Failure(signature, signingKey, validationException);
        }

        public static /* synthetic */ Failure copy$default(Failure failure, PGPSignature pGPSignature, SubkeyIdentifier subkeyIdentifier, SignatureValidationException signatureValidationException, int n, Object object) {
            if ((n & 1) != 0) {
                pGPSignature = failure.signature;
            }
            if ((n & 2) != 0) {
                subkeyIdentifier = failure.signingKey;
            }
            if ((n & 4) != 0) {
                signatureValidationException = failure.validationException;
            }
            return failure.copy(pGPSignature, subkeyIdentifier, signatureValidationException);
        }

        public int hashCode() {
            int result = this.signature.hashCode();
            result = result * 31 + (this.signingKey == null ? 0 : this.signingKey.hashCode());
            result = result * 31 + this.validationException.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Failure)) {
                return false;
            }
            Failure failure = (Failure)other;
            if (!Intrinsics.areEqual((Object)this.signature, (Object)failure.signature)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.signingKey, (Object)failure.signingKey)) {
                return false;
            }
            return Intrinsics.areEqual((Object)((Object)this.validationException), (Object)((Object)failure.validationException));
        }
    }
}

