/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.implementation;

import java.io.InputStream;
import java.security.KeyPair;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyPair;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcSessionKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020!H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020!H\u0016J \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0016J \u0010?\u001a\u00020@2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006A"}, d2={"Lorg/pgpainless/implementation/BcImplementationFactory;", "Lorg/pgpainless/implementation/ImplementationFactory;", "()V", "keyFingerprintCalculator", "Lorg/bouncycastle/openpgp/operator/bc/BcKeyFingerprintCalculator;", "getKeyFingerprintCalculator", "()Lorg/bouncycastle/openpgp/operator/bc/BcKeyFingerprintCalculator;", "pgpContentVerifierBuilderProvider", "Lorg/bouncycastle/openpgp/operator/bc/BcPGPContentVerifierBuilderProvider;", "getPgpContentVerifierBuilderProvider", "()Lorg/bouncycastle/openpgp/operator/bc/BcPGPContentVerifierBuilderProvider;", "pgpDigestCalculatorProvider", "Lorg/bouncycastle/openpgp/operator/bc/BcPGPDigestCalculatorProvider;", "getPgpDigestCalculatorProvider", "()Lorg/bouncycastle/openpgp/operator/bc/BcPGPDigestCalculatorProvider;", "getPBEDataDecryptorFactory", "Lorg/bouncycastle/openpgp/operator/PBEDataDecryptorFactory;", "passphrase", "Lorg/pgpainless/util/Passphrase;", "getPBEKeyEncryptionMethodGenerator", "Lorg/bouncycastle/openpgp/operator/PBEKeyEncryptionMethodGenerator;", "getPBESecretKeyDecryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyDecryptor;", "getPBESecretKeyEncryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyEncryptor;", "symmetricKeyAlgorithm", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "digestCalculator", "Lorg/bouncycastle/openpgp/operator/PGPDigestCalculator;", "encryptionAlgorithm", "hashAlgorithm", "Lorg/pgpainless/algorithm/HashAlgorithm;", "s2kCount", "", "getPGPContentSignerBuilder", "Lorg/bouncycastle/openpgp/operator/PGPContentSignerBuilder;", "keyAlgorithm", "getPGPDataEncryptorBuilder", "Lorg/bouncycastle/openpgp/operator/PGPDataEncryptorBuilder;", "getPGPKeyPair", "Lorg/bouncycastle/openpgp/PGPKeyPair;", "publicKeyAlgorithm", "Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "keyPair", "Ljava/security/KeyPair;", "creationDate", "Ljava/util/Date;", "getPGPObjectFactory", "Lorg/bouncycastle/openpgp/PGPObjectFactory;", "inputStream", "Ljava/io/InputStream;", "getPublicKeyDataDecryptorFactory", "Lorg/bouncycastle/openpgp/operator/PublicKeyDataDecryptorFactory;", "privateKey", "Lorg/bouncycastle/openpgp/PGPPrivateKey;", "getPublicKeyKeyEncryptionMethodGenerator", "Lorg/bouncycastle/openpgp/operator/PublicKeyKeyEncryptionMethodGenerator;", "key", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "getSessionKeyDataDecryptorFactory", "Lorg/bouncycastle/openpgp/operator/SessionKeyDataDecryptorFactory;", "sessionKey", "Lorg/bouncycastle/openpgp/PGPSessionKey;", "jceToBcKeyPair", "Lorg/bouncycastle/crypto/AsymmetricCipherKeyPair;", "pgpainless-core"})
public final class BcImplementationFactory
extends ImplementationFactory {
    @NotNull
    private final BcPGPDigestCalculatorProvider pgpDigestCalculatorProvider = new BcPGPDigestCalculatorProvider();
    @NotNull
    private final BcPGPContentVerifierBuilderProvider pgpContentVerifierBuilderProvider = new BcPGPContentVerifierBuilderProvider();
    @NotNull
    private final BcKeyFingerprintCalculator keyFingerprintCalculator = new BcKeyFingerprintCalculator();

    @NotNull
    public BcPGPDigestCalculatorProvider getPgpDigestCalculatorProvider() {
        return this.pgpDigestCalculatorProvider;
    }

    @NotNull
    public BcPGPContentVerifierBuilderProvider getPgpContentVerifierBuilderProvider() {
        return this.pgpContentVerifierBuilderProvider;
    }

    @NotNull
    public BcKeyFingerprintCalculator getKeyFingerprintCalculator() {
        return this.keyFingerprintCalculator;
    }

    @Override
    @NotNull
    public PBESecretKeyEncryptor getPBESecretKeyEncryptor(@NotNull SymmetricKeyAlgorithm symmetricKeyAlgorithm, @NotNull PGPDigestCalculator digestCalculator, @NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter((Object)((Object)symmetricKeyAlgorithm), (String)"symmetricKeyAlgorithm");
        Intrinsics.checkNotNullParameter((Object)digestCalculator, (String)"digestCalculator");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        PBESecretKeyEncryptor pBESecretKeyEncryptor = new BcPBESecretKeyEncryptorBuilder(symmetricKeyAlgorithm.getAlgorithmId(), digestCalculator).build(passphrase.getChars());
        Intrinsics.checkNotNullExpressionValue((Object)pBESecretKeyEncryptor, (String)"BcPBESecretKeyEncryptorB\u2026ld(passphrase.getChars())");
        return pBESecretKeyEncryptor;
    }

    @Override
    @NotNull
    public PBESecretKeyEncryptor getPBESecretKeyEncryptor(@NotNull SymmetricKeyAlgorithm encryptionAlgorithm, @NotNull HashAlgorithm hashAlgorithm, int s2kCount, @NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter((Object)((Object)encryptionAlgorithm), (String)"encryptionAlgorithm");
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        PBESecretKeyEncryptor pBESecretKeyEncryptor = new BcPBESecretKeyEncryptorBuilder(encryptionAlgorithm.getAlgorithmId(), this.getPGPDigestCalculator(hashAlgorithm), s2kCount).build(passphrase.getChars());
        Intrinsics.checkNotNullExpressionValue((Object)pBESecretKeyEncryptor, (String)"BcPBESecretKeyEncryptorB\u2026ld(passphrase.getChars())");
        return pBESecretKeyEncryptor;
    }

    @Override
    @NotNull
    public PBESecretKeyDecryptor getPBESecretKeyDecryptor(@NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        PBESecretKeyDecryptor pBESecretKeyDecryptor = new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)this.getPgpDigestCalculatorProvider()).build(passphrase.getChars());
        Intrinsics.checkNotNullExpressionValue((Object)pBESecretKeyDecryptor, (String)"BcPBESecretKeyDecryptorB\u2026ld(passphrase.getChars())");
        return pBESecretKeyDecryptor;
    }

    @Override
    @NotNull
    public PGPContentSignerBuilder getPGPContentSignerBuilder(int keyAlgorithm, int hashAlgorithm) {
        return (PGPContentSignerBuilder)new BcPGPContentSignerBuilder(keyAlgorithm, hashAlgorithm);
    }

    @Override
    @NotNull
    public PBEDataDecryptorFactory getPBEDataDecryptorFactory(@NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        return (PBEDataDecryptorFactory)new BcPBEDataDecryptorFactory(passphrase.getChars(), (PGPDigestCalculatorProvider)this.getPgpDigestCalculatorProvider());
    }

    @Override
    @NotNull
    public PublicKeyDataDecryptorFactory getPublicKeyDataDecryptorFactory(@NotNull PGPPrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        return (PublicKeyDataDecryptorFactory)new BcPublicKeyDataDecryptorFactory(privateKey);
    }

    @Override
    @NotNull
    public SessionKeyDataDecryptorFactory getSessionKeyDataDecryptorFactory(@NotNull PGPSessionKey sessionKey) {
        Intrinsics.checkNotNullParameter((Object)sessionKey, (String)"sessionKey");
        return (SessionKeyDataDecryptorFactory)new BcSessionKeyDataDecryptorFactory(sessionKey);
    }

    @Override
    @NotNull
    public PublicKeyKeyEncryptionMethodGenerator getPublicKeyKeyEncryptionMethodGenerator(@NotNull PGPPublicKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (PublicKeyKeyEncryptionMethodGenerator)new BcPublicKeyKeyEncryptionMethodGenerator(key);
    }

    @Override
    @NotNull
    public PBEKeyEncryptionMethodGenerator getPBEKeyEncryptionMethodGenerator(@NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        return (PBEKeyEncryptionMethodGenerator)new BcPBEKeyEncryptionMethodGenerator(passphrase.getChars());
    }

    @Override
    @NotNull
    public PGPDataEncryptorBuilder getPGPDataEncryptorBuilder(int symmetricKeyAlgorithm) {
        return (PGPDataEncryptorBuilder)new BcPGPDataEncryptorBuilder(symmetricKeyAlgorithm);
    }

    @Override
    @NotNull
    public PGPKeyPair getPGPKeyPair(@NotNull PublicKeyAlgorithm publicKeyAlgorithm, @NotNull KeyPair keyPair, @NotNull Date creationDate) {
        Intrinsics.checkNotNullParameter((Object)((Object)publicKeyAlgorithm), (String)"publicKeyAlgorithm");
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter((Object)creationDate, (String)"creationDate");
        return (PGPKeyPair)new BcPGPKeyPair(publicKeyAlgorithm.getAlgorithmId(), this.jceToBcKeyPair(publicKeyAlgorithm, keyPair, creationDate), creationDate);
    }

    @Override
    @NotNull
    public PGPObjectFactory getPGPObjectFactory(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return (PGPObjectFactory)new BcPGPObjectFactory(inputStream);
    }

    private final AsymmetricCipherKeyPair jceToBcKeyPair(PublicKeyAlgorithm publicKeyAlgorithm, KeyPair keyPair, Date creationDate) {
        BcPGPKeyConverter converter = new BcPGPKeyConverter();
        boolean bl = false;
        JcaPGPKeyPair pair = new JcaPGPKeyPair(publicKeyAlgorithm.getAlgorithmId(), keyPair, creationDate);
        boolean bl2 = false;
        return new AsymmetricCipherKeyPair(converter.getPublicKey(pair.getPublicKey()), converter.getPrivateKey(pair.getPrivateKey()));
    }
}

