/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.util.Strings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.bouncycastle.extensions.PGPSecretKeyExtensionsKt;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.generation.KeyRingBuilderInterface;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.policy.Policy;
import org.pgpainless.provider.ProviderFactory;
import org.pgpainless.signature.subpackets.BaseSignatureSubpackets;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsHelper;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 42\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00014B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0012H\u0002J\n\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u001a\u001a\u00020\bH\u0002J\u0012\u0010,\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J\u0010\u0010-\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010.\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0018\u0010/\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\b2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\bH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/pgpainless/key/generation/KeyRingBuilder;", "Lorg/pgpainless/key/generation/KeyRingBuilderInterface;", "()V", "expirationDate", "Ljava/util/Date;", "passphrase", "Lorg/pgpainless/util/Passphrase;", "primaryKeySpec", "Lorg/pgpainless/key/generation/KeySpec;", "subKeySpecs", "", "userIds", "", "", "Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets$Callback;", "addPrimaryKeyBindingSignatureIfNecessary", "Lorg/bouncycastle/openpgp/PGPSignatureSubpacketVector;", "primaryKey", "Lorg/bouncycastle/openpgp/PGPKeyPair;", "subKey", "hashedSubpackets", "addSubKeys", "", "ringGenerator", "Lorg/bouncycastle/openpgp/PGPKeyRingGenerator;", "addSubkey", "keySpec", "addUserId", "userId", "", "", "build", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "buildContentSigner", "Lorg/bouncycastle/openpgp/operator/PGPContentSignerBuilder;", "certKey", "buildSecretKeyDecryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyDecryptor;", "buildSecretKeyEncryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyEncryptor;", "keyFingerprintCalculator", "Lorg/bouncycastle/openpgp/operator/PGPDigestCalculator;", "keyIsCertificationCapable", "", "setExpirationDate", "setPassphrase", "setPrimaryKey", "verifyKeySpecCompliesToPolicy", "policy", "Lorg/pgpainless/policy/Policy;", "verifyPrimaryKeyCanCertify", "spec", "Companion", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nKeyRingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyRingBuilder.kt\norg/pgpainless/key/generation/KeyRingBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n1#2:270\n*E\n"})
public final class KeyRingBuilder
implements KeyRingBuilderInterface<KeyRingBuilder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private KeySpec primaryKeySpec;
    @NotNull
    private final List<KeySpec> subKeySpecs = new ArrayList();
    @NotNull
    private final Map<String, SelfSignatureSubpackets.Callback> userIds = new LinkedHashMap();
    @NotNull
    private Passphrase passphrase = Passphrase.Companion.emptyPassphrase();
    @Nullable
    private Date expirationDate = new Date(System.currentTimeMillis() + 157680000000L);
    public static final long MILLIS_IN_YEAR = 31536000000L;

    @Override
    @NotNull
    public KeyRingBuilder setPrimaryKey(@NotNull KeySpec keySpec) {
        KeyRingBuilder keyRingBuilder;
        Intrinsics.checkNotNullParameter((Object)keySpec, (String)"keySpec");
        KeyRingBuilder $this$setPrimaryKey_u24lambda_u240 = keyRingBuilder = this;
        boolean bl = false;
        $this$setPrimaryKey_u24lambda_u240.verifyKeySpecCompliesToPolicy(keySpec, PGPainless.Companion.getPolicy());
        $this$setPrimaryKey_u24lambda_u240.verifyPrimaryKeyCanCertify(keySpec);
        $this$setPrimaryKey_u24lambda_u240.primaryKeySpec = keySpec;
        return keyRingBuilder;
    }

    @Override
    @NotNull
    public KeyRingBuilder addSubkey(@NotNull KeySpec keySpec) {
        KeyRingBuilder keyRingBuilder;
        Intrinsics.checkNotNullParameter((Object)keySpec, (String)"keySpec");
        KeyRingBuilder $this$addSubkey_u24lambda_u241 = keyRingBuilder = this;
        boolean bl = false;
        $this$addSubkey_u24lambda_u241.verifyKeySpecCompliesToPolicy(keySpec, PGPainless.Companion.getPolicy());
        $this$addSubkey_u24lambda_u241.subKeySpecs.add(keySpec);
        return keyRingBuilder;
    }

    @Override
    @NotNull
    public KeyRingBuilder addUserId(@NotNull CharSequence userId) {
        KeyRingBuilder keyRingBuilder;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        KeyRingBuilder $this$addUserId_u24lambda_u242 = keyRingBuilder = this;
        boolean bl = false;
        $this$addUserId_u24lambda_u242.userIds.put(((Object)userId).toString(), null);
        return keyRingBuilder;
    }

    @Override
    @NotNull
    public KeyRingBuilder addUserId(@NotNull byte[] userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        String string = Strings.fromUTF8ByteArray((byte[])userId);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fromUTF8ByteArray(userId)");
        return this.addUserId(string);
    }

    @Override
    @NotNull
    public KeyRingBuilder setExpirationDate(@Nullable Date expirationDate) {
        KeyRingBuilder keyRingBuilder;
        KeyRingBuilder $this$setExpirationDate_u24lambda_u245 = keyRingBuilder = this;
        boolean bl = false;
        if (expirationDate == null) {
            $this$setExpirationDate_u24lambda_u245.expirationDate = null;
        } else {
            Date date = expirationDate;
            KeyRingBuilder keyRingBuilder2 = $this$setExpirationDate_u24lambda_u245;
            boolean bl2 = false;
            if (!(new Date().compareTo(expirationDate) < 0)) {
                boolean bl3 = false;
                String string = "Expiration date must be in the future.";
                throw new IllegalArgumentException(string.toString());
            }
            keyRingBuilder2.expirationDate = expirationDate;
        }
        return keyRingBuilder;
    }

    @Override
    @NotNull
    public KeyRingBuilder setPassphrase(@NotNull Passphrase passphrase) {
        KeyRingBuilder keyRingBuilder;
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        KeyRingBuilder $this$setPassphrase_u24lambda_u246 = keyRingBuilder = this;
        boolean bl = false;
        $this$setPassphrase_u24lambda_u246.passphrase = passphrase;
        return keyRingBuilder;
    }

    private final void verifyKeySpecCompliesToPolicy(KeySpec keySpec, Policy policy) {
        PublicKeyAlgorithm algorithm = keySpec.getKeyType().getAlgorithm();
        int bitStrength = keySpec.getKeyType().getBitStrength();
        if (!policy.getPublicKeyAlgorithmPolicy().isAcceptable(algorithm, bitStrength)) {
            boolean bl = false;
            String string = "Public key algorithm policy violation: " + algorithm + " with bit strength " + bitStrength + " is not acceptable.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void verifyPrimaryKeyCanCertify(KeySpec spec) {
        if (!this.keyIsCertificationCapable(spec)) {
            boolean bl = false;
            String string = "Key algorithm " + spec.getKeyType().getName() + " is not capable of creation certifications.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final boolean keyIsCertificationCapable(KeySpec keySpec) {
        return keySpec.getKeyType().canCertify();
    }

    @Override
    @NotNull
    public PGPSecretKeyRing build() {
        PGPKeyRingGenerator pGPKeyRingGenerator;
        PGPDigestCalculator keyFingerprintCalculator = ImplementationFactory.Companion.getInstance().getV4FingerprintCalculator();
        PBESecretKeyEncryptor secretKeyEncryptor = this.buildSecretKeyEncryptor(keyFingerprintCalculator);
        PBESecretKeyDecryptor secretKeyDecryptor = this.buildSecretKeyDecryptor();
        this.passphrase.clear();
        if (this.primaryKeySpec == null) {
            boolean $i$a$-requireNotNull-KeyRingBuilder$build$22 = false;
            String $i$a$-requireNotNull-KeyRingBuilder$build$22 = "Primary Key spec required.";
            throw new IllegalArgumentException($i$a$-requireNotNull-KeyRingBuilder$build$22.toString());
        }
        KeySpec keySpec = this.primaryKeySpec;
        Intrinsics.checkNotNull((Object)keySpec);
        PGPKeyPair certKey = org.pgpainless.key.generation.KeyRingBuilder$Companion.generateKeyPair$default(Companion, keySpec, null, 2, null);
        PGPContentSignerBuilder signer = this.buildContentSigner(certKey);
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(signer);
        KeySpec keySpec2 = this.primaryKeySpec;
        Intrinsics.checkNotNull((Object)keySpec2);
        SignatureSubpackets hashedSubPacketGenerator = keySpec2.getSubpacketGenerator();
        PGPPublicKey pGPPublicKey = certKey.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"certKey.publicKey");
        hashedSubPacketGenerator.setIssuerFingerprintAndKeyId(pGPPublicKey);
        Date date = this.expirationDate;
        if (date != null) {
            Date it = date;
            boolean bl = false;
            PGPPublicKey pGPPublicKey2 = certKey.getPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey2, (String)"certKey.publicKey");
            hashedSubPacketGenerator.setKeyExpirationTime(pGPPublicKey2, it);
        }
        if (!this.userIds.isEmpty()) {
            hashedSubPacketGenerator.setPrimaryUserId();
        }
        PGPSignatureSubpacketGenerator generator = new PGPSignatureSubpacketGenerator();
        SignatureSubpacketsHelper.Companion.applyTo(hashedSubPacketGenerator, generator);
        PGPSignatureSubpacketVector hashedSubPackets = generator.generate();
        if (this.userIds.isEmpty()) {
            pGPKeyRingGenerator = new PGPKeyRingGenerator(certKey, keyFingerprintCalculator, hashedSubPackets, null, signer, secretKeyEncryptor);
        } else {
            String primaryUserId = (String)CollectionsKt.first((Iterable)this.userIds.keySet());
            boolean bl = false;
            pGPKeyRingGenerator = new PGPKeyRingGenerator(SignatureType.POSITIVE_CERTIFICATION.getCode(), certKey, primaryUserId, keyFingerprintCalculator, hashedSubPackets, null, signer, secretKeyEncryptor);
        }
        PGPKeyRingGenerator ringGenerator = pGPKeyRingGenerator;
        this.addSubKeys(certKey, ringGenerator);
        PGPSecretKeyRing secretKeyRing = ringGenerator.generateSecretKeyRing();
        Iterator secretKeys = secretKeyRing.getSecretKeys();
        PGPPublicKey primaryPubKey = ((PGPSecretKey)secretKeys.next()).getPublicKey();
        PGPSecretKey pGPSecretKey = secretKeyRing.getSecretKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPSecretKey, (String)"secretKeyRing.secretKey");
        PGPPrivateKey privateKey = PGPSecretKeyExtensionsKt.unlock(pGPSecretKey, secretKeyDecryptor);
        Iterator<Map.Entry<String, SelfSignatureSubpackets.Callback>> userIdIterator = this.userIds.entrySet().iterator();
        if (userIdIterator.hasNext()) {
            userIdIterator.next();
        }
        while (userIdIterator.hasNext()) {
            SignatureSubpackets signatureSubpackets;
            SignatureSubpackets it;
            SignatureSubpackets signatureSubpackets2;
            Map.Entry<String, SelfSignatureSubpackets.Callback> additionalUserId = userIdIterator.next();
            String userIdString = additionalUserId.getKey();
            SelfSignatureSubpackets.Callback callback2 = additionalUserId.getValue();
            if (callback2 == null) {
                it = signatureSubpackets2 = hashedSubPacketGenerator;
                boolean bl = false;
                it.setPrimaryUserId(null);
                signatureSubpackets = signatureSubpackets2;
            } else {
                PGPPublicKey pGPPublicKey3 = primaryPubKey;
                Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey3, (String)"primaryPubKey");
                it = signatureSubpackets2 = SignatureSubpackets.Companion.createHashedSubpackets(pGPPublicKey3);
                boolean bl = false;
                callback2.modifyHashedSubpackets((BaseSignatureSubpackets)it);
                signatureSubpackets = signatureSubpackets2;
            }
            SignatureSubpackets subpackets = signatureSubpackets;
            signatureGenerator.init(SignatureType.POSITIVE_CERTIFICATION.getCode(), privateKey);
            signatureGenerator.setHashedSubpackets(SignatureSubpacketsHelper.Companion.toVector(subpackets));
            PGPSignature additionalUserIdSignature = signatureGenerator.generateCertification(userIdString, primaryPubKey);
            primaryPubKey = PGPPublicKey.addCertification((PGPPublicKey)primaryPubKey, (String)userIdString, (PGPSignature)additionalUserIdSignature);
        }
        PGPSecretKey primarySecretKey = new PGPSecretKey(privateKey, primaryPubKey, keyFingerprintCalculator, true, secretKeyEncryptor);
        Object[] objectArray = new PGPSecretKey[]{primarySecretKey};
        List secretKeyList = CollectionsKt.mutableListOf((Object[])objectArray);
        while (secretKeys.hasNext()) {
            Object e = secretKeys.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"secretKeys.next()");
            secretKeyList.add(e);
        }
        return new PGPSecretKeyRing(secretKeyList);
    }

    private final void addSubKeys(PGPKeyPair primaryKey, PGPKeyRingGenerator ringGenerator) {
        for (KeySpec subKeySpec : this.subKeySpecs) {
            PGPKeyPair subKey = org.pgpainless.key.generation.KeyRingBuilder$Companion.generateKeyPair$default(Companion, subKeySpec, null, 2, null);
            if (subKeySpec.isInheritedSubPackets()) {
                ringGenerator.addSubKey(subKey);
                continue;
            }
            PGPSignatureSubpacketVector hashedSubpackets = subKeySpec.getSubpackets();
            try {
                hashedSubpackets = this.addPrimaryKeyBindingSignatureIfNecessary(primaryKey, subKey, hashedSubpackets);
            }
            catch (IOException e) {
                throw new PGPException("Exception while adding primary key binding signature to signing subkey.", (Exception)e);
            }
            ringGenerator.addSubKey(subKey, hashedSubpackets, null);
        }
    }

    private final PGPSignatureSubpacketVector addPrimaryKeyBindingSignatureIfNecessary(PGPKeyPair primaryKey, PGPKeyPair subKey, PGPSignatureSubpacketVector hashedSubpackets) {
        int keyFlagMask = hashedSubpackets.getKeyFlags();
        if (!KeyFlag.Companion.hasKeyFlag(keyFlagMask, KeyFlag.SIGN_DATA) && !KeyFlag.Companion.hasKeyFlag(keyFlagMask, KeyFlag.CERTIFY_OTHER)) {
            return hashedSubpackets;
        }
        PGPSignatureGenerator bindingSignatureGenerator = new PGPSignatureGenerator(this.buildContentSigner(subKey));
        bindingSignatureGenerator.init(SignatureType.PRIMARYKEY_BINDING.getCode(), subKey.getPrivateKey());
        PGPSignature primaryKeyBindingSig = bindingSignatureGenerator.generateCertification(primaryKey.getPublicKey(), subKey.getPublicKey());
        PGPSignatureSubpacketGenerator subpacketGenerator = new PGPSignatureSubpacketGenerator(hashedSubpackets);
        subpacketGenerator.addEmbeddedSignature(false, primaryKeyBindingSig);
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector = subpacketGenerator.generate();
        Intrinsics.checkNotNullExpressionValue((Object)pGPSignatureSubpacketVector, (String)"subpacketGenerator.generate()");
        return pGPSignatureSubpacketVector;
    }

    private final PGPContentSignerBuilder buildContentSigner(PGPKeyPair certKey) {
        HashAlgorithm hashAlgorithm = PGPainless.Companion.getPolicy().getCertificationSignatureHashAlgorithmPolicy().getDefaultHashAlgorithm();
        return ImplementationFactory.Companion.getInstance().getPGPContentSignerBuilder(certKey.getPublicKey().getAlgorithm(), hashAlgorithm.getAlgorithmId());
    }

    private final PBESecretKeyEncryptor buildSecretKeyEncryptor(PGPDigestCalculator keyFingerprintCalculator) {
        SymmetricKeyAlgorithm keyEncryptionAlgorithm = PGPainless.Companion.getPolicy().getSymmetricKeyEncryptionAlgorithmPolicy().getDefaultSymmetricKeyAlgorithm();
        if (!this.passphrase.isValid()) {
            boolean bl = false;
            String string = "Passphrase was cleared.";
            throw new IllegalStateException(string.toString());
        }
        return this.passphrase.isEmpty() ? null : ImplementationFactory.Companion.getInstance().getPBESecretKeyEncryptor(keyEncryptionAlgorithm, keyFingerprintCalculator, this.passphrase);
    }

    private final PBESecretKeyDecryptor buildSecretKeyDecryptor() {
        if (!this.passphrase.isValid()) {
            boolean bl = false;
            String string = "Passphrase was cleared.";
            throw new IllegalStateException(string.toString());
        }
        return this.passphrase.isEmpty() ? null : ImplementationFactory.Companion.getInstance().getPBESecretKeyDecryptor(this.passphrase);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PGPKeyPair generateKeyPair(@NotNull KeySpec spec, @NotNull Date creationTime) {
        return Companion.generateKeyPair(spec, creationTime);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PGPKeyPair generateKeyPair(@NotNull KeySpec spec) {
        return Companion.generateKeyPair(spec);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/pgpainless/key/generation/KeyRingBuilder$Companion;", "", "()V", "MILLIS_IN_YEAR", "", "generateKeyPair", "Lorg/bouncycastle/openpgp/PGPKeyPair;", "spec", "Lorg/pgpainless/key/generation/KeySpec;", "creationTime", "Ljava/util/Date;", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nKeyRingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyRingBuilder.kt\norg/pgpainless/key/generation/KeyRingBuilder$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n1#2:270\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PGPKeyPair generateKeyPair(@NotNull KeySpec spec, @NotNull Date creationTime) {
            KeyPairGenerator keyPairGenerator;
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            Intrinsics.checkNotNullParameter((Object)creationTime, (String)"creationTime");
            KeyType type = spec.getKeyType();
            boolean bl = false;
            KeyPairGenerator it = keyPairGenerator = KeyPairGenerator.getInstance(type.getName(), ProviderFactory.Companion.getProvider());
            boolean bl2 = false;
            it.initialize(type.getAlgorithmSpec());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            ImplementationFactory implementationFactory = ImplementationFactory.Companion.getInstance();
            PublicKeyAlgorithm publicKeyAlgorithm = type.getAlgorithm();
            Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"keyPair");
            return implementationFactory.getPGPKeyPair(publicKeyAlgorithm, keyPair, creationTime);
        }

        public static /* synthetic */ PGPKeyPair generateKeyPair$default(Companion companion, KeySpec keySpec, Date date, int n, Object object) {
            if ((n & 2) != 0) {
                Date date2 = keySpec.getKeyCreationDate();
                if (date2 == null) {
                    date2 = new Date();
                }
                date = date2;
            }
            return companion.generateKeyPair(keySpec, date);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PGPKeyPair generateKeyPair(@NotNull KeySpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            return org.pgpainless.key.generation.KeyRingBuilder$Companion.generateKeyPair$default(this, spec, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

