/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/pgpainless/key/protection/KeyRingProtectionSettings;", "", "encryptionAlgorithm", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "(Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;)V", "hashAlgorithm", "Lorg/pgpainless/algorithm/HashAlgorithm;", "s2kCount", "", "(Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;Lorg/pgpainless/algorithm/HashAlgorithm;I)V", "getEncryptionAlgorithm", "()Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "getHashAlgorithm", "()Lorg/pgpainless/algorithm/HashAlgorithm;", "getS2kCount", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nKeyRingProtectionSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyRingProtectionSettings.kt\norg/pgpainless/key/protection/KeyRingProtectionSettings\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1#2:57\n*E\n"})
public final class KeyRingProtectionSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SymmetricKeyAlgorithm encryptionAlgorithm;
    @NotNull
    private final HashAlgorithm hashAlgorithm;
    private final int s2kCount;

    public KeyRingProtectionSettings(@NotNull SymmetricKeyAlgorithm encryptionAlgorithm, @NotNull HashAlgorithm hashAlgorithm, int s2kCount) {
        Intrinsics.checkNotNullParameter((Object)((Object)encryptionAlgorithm), (String)"encryptionAlgorithm");
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
        this.s2kCount = s2kCount;
        if (!(this.encryptionAlgorithm != SymmetricKeyAlgorithm.NULL)) {
            boolean $i$a$-require-KeyRingProtectionSettings$32 = false;
            String $i$a$-require-KeyRingProtectionSettings$32 = "Unencrypted is not allowed here!";
            throw new IllegalArgumentException($i$a$-require-KeyRingProtectionSettings$32.toString());
        }
        if (!(this.s2kCount > 0)) {
            boolean bl = false;
            String string = "s2kCount cannot be less than 1.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final SymmetricKeyAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @NotNull
    public final HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public final int getS2kCount() {
        return this.s2kCount;
    }

    public KeyRingProtectionSettings(@NotNull SymmetricKeyAlgorithm encryptionAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)((Object)encryptionAlgorithm), (String)"encryptionAlgorithm");
        this(encryptionAlgorithm, HashAlgorithm.SHA1, 96);
    }

    @NotNull
    public final SymmetricKeyAlgorithm component1() {
        return this.encryptionAlgorithm;
    }

    @NotNull
    public final HashAlgorithm component2() {
        return this.hashAlgorithm;
    }

    public final int component3() {
        return this.s2kCount;
    }

    @NotNull
    public final KeyRingProtectionSettings copy(@NotNull SymmetricKeyAlgorithm encryptionAlgorithm, @NotNull HashAlgorithm hashAlgorithm, int s2kCount) {
        Intrinsics.checkNotNullParameter((Object)((Object)encryptionAlgorithm), (String)"encryptionAlgorithm");
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
        return new KeyRingProtectionSettings(encryptionAlgorithm, hashAlgorithm, s2kCount);
    }

    public static /* synthetic */ KeyRingProtectionSettings copy$default(KeyRingProtectionSettings keyRingProtectionSettings, SymmetricKeyAlgorithm symmetricKeyAlgorithm, HashAlgorithm hashAlgorithm, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            symmetricKeyAlgorithm = keyRingProtectionSettings.encryptionAlgorithm;
        }
        if ((n2 & 2) != 0) {
            hashAlgorithm = keyRingProtectionSettings.hashAlgorithm;
        }
        if ((n2 & 4) != 0) {
            n = keyRingProtectionSettings.s2kCount;
        }
        return keyRingProtectionSettings.copy(symmetricKeyAlgorithm, hashAlgorithm, n);
    }

    @NotNull
    public String toString() {
        return "KeyRingProtectionSettings(encryptionAlgorithm=" + this.encryptionAlgorithm + ", hashAlgorithm=" + this.hashAlgorithm + ", s2kCount=" + this.s2kCount + ")";
    }

    public int hashCode() {
        int result = this.encryptionAlgorithm.hashCode();
        result = result * 31 + this.hashAlgorithm.hashCode();
        result = result * 31 + Integer.hashCode(this.s2kCount);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KeyRingProtectionSettings)) {
            return false;
        }
        KeyRingProtectionSettings keyRingProtectionSettings = (KeyRingProtectionSettings)other;
        if (this.encryptionAlgorithm != keyRingProtectionSettings.encryptionAlgorithm) {
            return false;
        }
        if (this.hashAlgorithm != keyRingProtectionSettings.hashAlgorithm) {
            return false;
        }
        return this.s2kCount == keyRingProtectionSettings.s2kCount;
    }

    @JvmStatic
    @NotNull
    public static final KeyRingProtectionSettings secureDefaultSettings() {
        return Companion.secureDefaultSettings();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/pgpainless/key/protection/KeyRingProtectionSettings$Companion;", "", "()V", "secureDefaultSettings", "Lorg/pgpainless/key/protection/KeyRingProtectionSettings;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KeyRingProtectionSettings secureDefaultSettings() {
            return new KeyRingProtectionSettings(SymmetricKeyAlgorithm.AES_256, HashAlgorithm.SHA256, 96);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

