/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bouncycastle.bcpg.MarkerPacket;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.pgpainless.decryption_verification.DecryptionBuilderInterface;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.DecryptionStreamFactory;
import org.pgpainless.decryption_verification.MissingPublicKeyCallback;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.util.Passphrase;

public class DecryptionBuilder
implements DecryptionBuilderInterface {
    private InputStream inputStream;
    private PGPSecretKeyRingCollection decryptionKeys;
    private SecretKeyRingProtector decryptionKeyDecryptor;
    private Passphrase decryptionPassphrase;
    private List<PGPSignature> detachedSignatures;
    private Set<PGPPublicKeyRing> verificationKeys = new HashSet<PGPPublicKeyRing>();
    private MissingPublicKeyCallback missingPublicKeyCallback = null;
    private final KeyFingerPrintCalculator keyFingerPrintCalculator = ImplementationFactory.getInstance().getKeyFingerprintCalculator();

    @Override
    public DecryptionBuilderInterface.DecryptWith onInputStream(@Nonnull InputStream inputStream) {
        this.inputStream = inputStream;
        return new DecryptWithImpl();
    }

    class BuildImpl
    implements DecryptionBuilderInterface.Build {
        BuildImpl() {
        }

        @Override
        public DecryptionStream build() throws IOException, PGPException {
            return DecryptionStreamFactory.create(DecryptionBuilder.this.inputStream, DecryptionBuilder.this.decryptionKeys, DecryptionBuilder.this.decryptionKeyDecryptor, DecryptionBuilder.this.decryptionPassphrase, DecryptionBuilder.this.detachedSignatures, DecryptionBuilder.this.verificationKeys, DecryptionBuilder.this.missingPublicKeyCallback);
        }
    }

    class HandleMissingPublicKeysImpl
    implements DecryptionBuilderInterface.HandleMissingPublicKeys {
        HandleMissingPublicKeysImpl() {
        }

        @Override
        public DecryptionBuilderInterface.Build handleMissingPublicKeysWith(@Nonnull MissingPublicKeyCallback callback) {
            DecryptionBuilder.this.missingPublicKeyCallback = callback;
            return new BuildImpl();
        }

        @Override
        public DecryptionBuilderInterface.Build ignoreMissingPublicKeys() {
            DecryptionBuilder.this.missingPublicKeyCallback = null;
            return new BuildImpl();
        }
    }

    class VerifyWithImpl
    implements DecryptionBuilderInterface.VerifyWith {
        VerifyWithImpl() {
        }

        @Override
        public DecryptionBuilderInterface.HandleMissingPublicKeys verifyWith(@Nonnull PGPPublicKeyRingCollection publicKeyRingCollection) {
            HashSet<PGPPublicKeyRing> publicKeyRings = new HashSet<PGPPublicKeyRing>();
            Iterator<PGPPublicKeyRing> i = publicKeyRingCollection.getKeyRings();
            while (i.hasNext()) {
                publicKeyRings.add(i.next());
            }
            return this.verifyWith(publicKeyRings);
        }

        @Override
        public DecryptionBuilderInterface.HandleMissingPublicKeys verifyWith(@Nonnull Set<OpenPgpV4Fingerprint> trustedKeyIds, @Nonnull PGPPublicKeyRingCollection publicKeyRingCollection) {
            Set<PGPPublicKeyRing> publicKeyRings = this.keyRingCollectionToSet(publicKeyRingCollection);
            this.removeUntrustedPublicKeys(publicKeyRings, trustedKeyIds);
            return this.verifyWith(publicKeyRings);
        }

        private void removeUntrustedPublicKeys(Set<PGPPublicKeyRing> publicKeyRings, Set<OpenPgpV4Fingerprint> trustedKeyIds) {
            for (PGPPublicKeyRing p : new HashSet<PGPPublicKeyRing>(publicKeyRings)) {
                if (trustedKeyIds.contains(new OpenPgpV4Fingerprint(p))) continue;
                publicKeyRings.remove(p);
            }
        }

        private Set<PGPPublicKeyRing> keyRingCollectionToSet(PGPPublicKeyRingCollection publicKeyRingCollection) {
            HashSet<PGPPublicKeyRing> publicKeyRings = new HashSet<PGPPublicKeyRing>();
            Iterator<PGPPublicKeyRing> i = publicKeyRingCollection.getKeyRings();
            while (i.hasNext()) {
                publicKeyRings.add(i.next());
            }
            return publicKeyRings;
        }

        @Override
        public DecryptionBuilderInterface.HandleMissingPublicKeys verifyWith(@Nonnull Set<PGPPublicKeyRing> publicKeyRings) {
            DecryptionBuilder.this.verificationKeys = publicKeyRings;
            return new HandleMissingPublicKeysImpl();
        }
    }

    class VerifyImpl
    implements DecryptionBuilderInterface.Verify {
        VerifyImpl() {
        }

        @Override
        public DecryptionBuilderInterface.VerifyWith verifyDetachedSignature(@Nonnull InputStream inputStream) throws IOException, PGPException {
            ArrayList<PGPSignature> signatures = new ArrayList<PGPSignature>();
            InputStream pgpIn = PGPUtil.getDecoderStream(inputStream);
            PGPObjectFactory objectFactory = new PGPObjectFactory(pgpIn, DecryptionBuilder.this.keyFingerPrintCalculator);
            Object nextObject = objectFactory.nextObject();
            while (nextObject != null) {
                if (nextObject instanceof MarkerPacket) {
                    nextObject = objectFactory.nextObject();
                    continue;
                }
                if (nextObject instanceof PGPCompressedData) {
                    PGPCompressedData compressedData = (PGPCompressedData)nextObject;
                    objectFactory = new PGPObjectFactory(compressedData.getDataStream(), DecryptionBuilder.this.keyFingerPrintCalculator);
                    nextObject = objectFactory.nextObject();
                    continue;
                }
                if (nextObject instanceof PGPSignatureList) {
                    PGPSignatureList signatureList = (PGPSignatureList)nextObject;
                    for (PGPSignature s : signatureList) {
                        signatures.add(s);
                    }
                }
                if (nextObject instanceof PGPSignature) {
                    signatures.add((PGPSignature)nextObject);
                }
                nextObject = objectFactory.nextObject();
            }
            pgpIn.close();
            return this.verifyDetachedSignatures(signatures);
        }

        @Override
        public DecryptionBuilderInterface.VerifyWith verifyDetachedSignatures(@Nonnull List<PGPSignature> signatures) {
            DecryptionBuilder.this.detachedSignatures = signatures;
            return new VerifyWithImpl();
        }

        @Override
        public DecryptionBuilderInterface.HandleMissingPublicKeys verifyWith(@Nonnull PGPPublicKeyRingCollection publicKeyRings) {
            return new VerifyWithImpl().verifyWith(publicKeyRings);
        }

        @Override
        public DecryptionBuilderInterface.HandleMissingPublicKeys verifyWith(@Nonnull Set<OpenPgpV4Fingerprint> trustedFingerprints, @Nonnull PGPPublicKeyRingCollection publicKeyRings) {
            return new VerifyWithImpl().verifyWith(trustedFingerprints, publicKeyRings);
        }

        @Override
        public DecryptionBuilderInterface.HandleMissingPublicKeys verifyWith(@Nonnull Set<PGPPublicKeyRing> publicKeyRings) {
            return new VerifyWithImpl().verifyWith(publicKeyRings);
        }

        @Override
        public DecryptionBuilderInterface.Build doNotVerify() {
            DecryptionBuilder.this.verificationKeys = null;
            return new BuildImpl();
        }
    }

    class DecryptWithImpl
    implements DecryptionBuilderInterface.DecryptWith {
        DecryptWithImpl() {
        }

        @Override
        public DecryptionBuilderInterface.Verify decryptWith(@Nonnull SecretKeyRingProtector decryptor, @Nonnull PGPSecretKeyRingCollection secretKeyRings) {
            DecryptionBuilder.this.decryptionKeys = secretKeyRings;
            DecryptionBuilder.this.decryptionKeyDecryptor = decryptor;
            return new VerifyImpl();
        }

        @Override
        public DecryptionBuilderInterface.Verify decryptWith(@Nonnull SecretKeyRingProtector decryptor, @Nonnull PGPSecretKeyRing secretKeyRing) throws PGPException, IOException {
            DecryptionBuilder.this.decryptionKeys = new PGPSecretKeyRingCollection(Collections.singleton(secretKeyRing));
            DecryptionBuilder.this.decryptionKeyDecryptor = decryptor;
            return new VerifyImpl();
        }

        @Override
        public DecryptionBuilderInterface.Verify decryptWith(@Nonnull Passphrase passphrase) {
            if (passphrase.isEmpty()) {
                throw new IllegalArgumentException("Passphrase MUST NOT be empty.");
            }
            DecryptionBuilder.this.decryptionPassphrase = passphrase;
            return new VerifyImpl();
        }

        @Override
        public DecryptionBuilderInterface.Verify doNotDecrypt() {
            DecryptionBuilder.this.decryptionKeys = null;
            DecryptionBuilder.this.decryptionKeyDecryptor = null;
            return new VerifyImpl();
        }
    }
}

