/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.encryption_signing.EncryptionBuilderInterface;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.key.KeyRingValidator;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.Tuple;
import org.pgpainless.util.selection.key.PublicKeySelectionStrategy;
import org.pgpainless.util.selection.key.SecretKeySelectionStrategy;
import org.pgpainless.util.selection.key.impl.And;
import org.pgpainless.util.selection.key.impl.EncryptionKeySelectionStrategy;
import org.pgpainless.util.selection.key.impl.NoRevocation;
import org.pgpainless.util.selection.key.impl.SignatureKeySelectionStrategy;

public class EncryptionBuilder
implements EncryptionBuilderInterface {
    private final EncryptionStream.Purpose purpose;
    private OutputStream outputStream;
    private final Map<SubkeyIdentifier, PGPPublicKeyRing> encryptionKeys = new ConcurrentHashMap<SubkeyIdentifier, PGPPublicKeyRing>();
    private final Set<Passphrase> encryptionPassphrases = new HashSet<Passphrase>();
    private boolean detachedSignature = false;
    private SignatureType signatureType = SignatureType.BINARY_DOCUMENT;
    private final Map<SubkeyIdentifier, PGPSecretKeyRing> signingKeys = new ConcurrentHashMap<SubkeyIdentifier, PGPSecretKeyRing>();
    private SecretKeyRingProtector signingKeysDecryptor;
    private SymmetricKeyAlgorithm symmetricKeyAlgorithm = SymmetricKeyAlgorithm.AES_128;
    private HashAlgorithm hashAlgorithm = HashAlgorithm.SHA256;
    private CompressionAlgorithm compressionAlgorithm = CompressionAlgorithm.UNCOMPRESSED;
    private boolean asciiArmor = false;
    private OpenPgpMetadata.FileInfo fileInfo;

    public EncryptionBuilder() {
        this.purpose = EncryptionStream.Purpose.COMMUNICATIONS;
    }

    public EncryptionBuilder(@Nonnull EncryptionStream.Purpose purpose) {
        this.purpose = purpose;
    }

    @Override
    public EncryptionBuilderInterface.ToRecipients onOutputStream(@Nonnull OutputStream outputStream, OpenPgpMetadata.FileInfo fileInfo) {
        this.outputStream = outputStream;
        this.fileInfo = fileInfo;
        return new ToRecipientsImpl();
    }

    PublicKeySelectionStrategy encryptionKeySelector() {
        KeyFlag[] flags = EncryptionBuilder.mapPurposeToKeyFlags(this.purpose);
        return new And.PubKeySelectionStrategy(new NoRevocation.PubKeySelectionStrategy(), new EncryptionKeySelectionStrategy(flags));
    }

    SecretKeySelectionStrategy signingKeySelector() {
        return new And.SecKeySelectionStrategy(new NoRevocation.SecKeySelectionStrategy(), new SignatureKeySelectionStrategy());
    }

    private static KeyFlag[] mapPurposeToKeyFlags(EncryptionStream.Purpose purpose) {
        KeyFlag[] flags;
        switch (purpose) {
            case COMMUNICATIONS: {
                flags = new KeyFlag[]{KeyFlag.ENCRYPT_COMMS};
                break;
            }
            case STORAGE: {
                flags = new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE};
                break;
            }
            case STORAGE_AND_COMMUNICATIONS: {
                flags = new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE};
                break;
            }
            default: {
                throw new AssertionError((Object)"Illegal purpose enum value encountered.");
            }
        }
        return flags;
    }

    class ArmorImpl
    implements EncryptionBuilderInterface.Armor {
        ArmorImpl() {
        }

        @Override
        public EncryptionStream asciiArmor() throws IOException, PGPException {
            EncryptionBuilder.this.asciiArmor = true;
            return this.build();
        }

        @Override
        public EncryptionStream noArmor() throws IOException, PGPException {
            EncryptionBuilder.this.asciiArmor = false;
            return this.build();
        }

        private EncryptionStream build() throws IOException, PGPException {
            ConcurrentHashMap<SubkeyIdentifier, Tuple<PGPSecretKeyRing, PGPPrivateKey>> privateKeys = new ConcurrentHashMap<SubkeyIdentifier, Tuple<PGPSecretKeyRing, PGPPrivateKey>>();
            for (SubkeyIdentifier signingKey : EncryptionBuilder.this.signingKeys.keySet()) {
                PGPSecretKeyRing secretKeyRing = (PGPSecretKeyRing)EncryptionBuilder.this.signingKeys.get(signingKey);
                PGPSecretKey secretKey = secretKeyRing.getSecretKey(signingKey.getSubkeyFingerprint().getKeyId());
                PBESecretKeyDecryptor decryptor = EncryptionBuilder.this.signingKeysDecryptor.getDecryptor(secretKey.getKeyID());
                PGPPrivateKey privateKey = secretKey.extractPrivateKey(decryptor);
                privateKeys.put(signingKey, new Tuple<PGPSecretKeyRing, PGPPrivateKey>(secretKeyRing, privateKey));
            }
            return new EncryptionStream(EncryptionBuilder.this.outputStream, EncryptionBuilder.this.encryptionKeys, EncryptionBuilder.this.encryptionPassphrases, EncryptionBuilder.this.detachedSignature, EncryptionBuilder.this.signatureType, privateKeys, EncryptionBuilder.this.symmetricKeyAlgorithm, EncryptionBuilder.this.hashAlgorithm, EncryptionBuilder.this.compressionAlgorithm, EncryptionBuilder.this.asciiArmor, EncryptionBuilder.this.fileInfo);
        }
    }

    class DocumentTypeImpl
    implements EncryptionBuilderInterface.DocumentType {
        DocumentTypeImpl() {
        }

        @Override
        public EncryptionBuilderInterface.Armor signBinaryDocument() {
            EncryptionBuilder.this.signatureType = SignatureType.BINARY_DOCUMENT;
            return new ArmorImpl();
        }

        @Override
        public EncryptionBuilderInterface.Armor signCanonicalText() {
            EncryptionBuilder.this.signatureType = SignatureType.CANONICAL_TEXT_DOCUMENT;
            return new ArmorImpl();
        }
    }

    class SignWithImpl
    implements EncryptionBuilderInterface.SignWith {
        SignWithImpl() {
        }

        @Override
        public EncryptionBuilderInterface.DocumentType signWith(@Nonnull SecretKeyRingProtector decryptor, PGPSecretKeyRing ... keyRings) {
            if (keyRings.length == 0) {
                throw new IllegalArgumentException("Signing key list MUST NOT be empty.");
            }
            for (PGPSecretKeyRing ring : keyRings) {
                ConcurrentHashMap<SubkeyIdentifier, PGPSecretKeyRing> signingKeys = new ConcurrentHashMap<SubkeyIdentifier, PGPSecretKeyRing>();
                Iterator<PGPSecretKey> i = ring.getSecretKeys();
                while (i.hasNext()) {
                    PGPSecretKey s = i.next();
                    if (!EncryptionBuilder.this.signingKeySelector().accept(s)) continue;
                    signingKeys.put(new SubkeyIdentifier(ring, s.getKeyID()), ring);
                }
                if (signingKeys.isEmpty()) {
                    throw new IllegalArgumentException("No suitable signing key found in the key ring " + new OpenPgpV4Fingerprint(ring));
                }
                EncryptionBuilder.this.signingKeys.putAll(signingKeys);
            }
            EncryptionBuilder.this.signingKeysDecryptor = decryptor;
            return new DocumentTypeImpl();
        }

        @Override
        public EncryptionBuilderInterface.DocumentType signWith(@Nonnull SecretKeyRingProtector decryptor, @Nonnull PGPSecretKeyRingCollection keyRings) {
            Iterator<PGPSecretKeyRing> iterator = keyRings.iterator();
            if (!iterator.hasNext()) {
                throw new IllegalArgumentException("Signing key collection MUST NOT be empty.");
            }
            while (iterator.hasNext()) {
                PGPSecretKeyRing ring = iterator.next();
                ConcurrentHashMap<SubkeyIdentifier, PGPSecretKeyRing> signingKeys = new ConcurrentHashMap<SubkeyIdentifier, PGPSecretKeyRing>();
                Iterator<PGPSecretKey> i = ring.getSecretKeys();
                while (i.hasNext()) {
                    PGPSecretKey s = i.next();
                    if (!EncryptionBuilder.this.signingKeySelector().accept(s)) continue;
                    signingKeys.put(new SubkeyIdentifier(ring, s.getKeyID()), ring);
                }
                if (signingKeys.isEmpty()) {
                    throw new IllegalArgumentException("No suitable signing key found in the key ring " + new OpenPgpV4Fingerprint(ring));
                }
                EncryptionBuilder.this.signingKeys.putAll(signingKeys);
            }
            EncryptionBuilder.this.signingKeysDecryptor = decryptor;
            return new DocumentTypeImpl();
        }
    }

    class DetachedSignImpl
    implements EncryptionBuilderInterface.DetachedSign {
        DetachedSignImpl() {
        }

        @Override
        public EncryptionBuilderInterface.SignWith createDetachedSignature() {
            EncryptionBuilder.this.detachedSignature = true;
            return new SignWithImpl();
        }

        @Override
        public EncryptionBuilderInterface.Armor doNotSign() {
            return new ArmorImpl();
        }

        @Override
        public EncryptionBuilderInterface.DocumentType signWith(@Nonnull SecretKeyRingProtector decryptor, PGPSecretKeyRing ... keyRings) {
            return new SignWithImpl().signWith(decryptor, keyRings);
        }

        @Override
        public EncryptionBuilderInterface.DocumentType signWith(@Nonnull SecretKeyRingProtector decryptor, @Nonnull PGPSecretKeyRingCollection keyRings) {
            return new SignWithImpl().signWith(decryptor, keyRings);
        }
    }

    class WithAlgorithmsImpl
    implements EncryptionBuilderInterface.WithAlgorithms {
        WithAlgorithmsImpl() {
        }

        @Override
        public EncryptionBuilderInterface.WithAlgorithms andToSelf(PGPPublicKeyRing ... keys) {
            if (keys.length == 0) {
                throw new IllegalArgumentException("Recipient list MUST NOT be empty.");
            }
            for (PGPPublicKeyRing ring : keys) {
                ConcurrentHashMap<SubkeyIdentifier, PGPPublicKeyRing> encryptionKeys = new ConcurrentHashMap<SubkeyIdentifier, PGPPublicKeyRing>();
                Iterator<PGPPublicKey> i = ring.getPublicKeys();
                while (i.hasNext()) {
                    PGPPublicKey key = i.next();
                    if (!EncryptionBuilder.this.encryptionKeySelector().accept(key)) continue;
                    encryptionKeys.put(new SubkeyIdentifier(ring, key.getKeyID()), ring);
                }
                if (encryptionKeys.isEmpty()) {
                    throw new IllegalArgumentException("No suitable encryption key found in the key ring " + new OpenPgpV4Fingerprint(ring));
                }
                EncryptionBuilder.this.encryptionKeys.putAll(encryptionKeys);
            }
            return this;
        }

        @Override
        public EncryptionBuilderInterface.WithAlgorithms andToSelf(@Nonnull PGPPublicKeyRingCollection keys) {
            for (PGPPublicKeyRing ring : keys) {
                ConcurrentHashMap<SubkeyIdentifier, PGPPublicKeyRing> encryptionKeys = new ConcurrentHashMap<SubkeyIdentifier, PGPPublicKeyRing>();
                Iterator<PGPPublicKey> i = ring.getPublicKeys();
                while (i.hasNext()) {
                    PGPPublicKey key = i.next();
                    if (!EncryptionBuilder.this.encryptionKeySelector().accept(key)) continue;
                    encryptionKeys.put(new SubkeyIdentifier(ring, key.getKeyID()), ring);
                }
                if (encryptionKeys.isEmpty()) {
                    throw new IllegalArgumentException("No suitable encryption key found in the key ring " + new OpenPgpV4Fingerprint(ring));
                }
                EncryptionBuilder.this.encryptionKeys.putAll(encryptionKeys);
            }
            return this;
        }

        @Override
        public EncryptionBuilderInterface.DetachedSign usingAlgorithms(@Nonnull SymmetricKeyAlgorithm symmetricKeyAlgorithm, @Nonnull HashAlgorithm hashAlgorithm, @Nonnull CompressionAlgorithm compressionAlgorithm) {
            EncryptionBuilder.this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
            EncryptionBuilder.this.hashAlgorithm = hashAlgorithm;
            EncryptionBuilder.this.compressionAlgorithm = compressionAlgorithm;
            return new DetachedSignImpl();
        }

        @Override
        public EncryptionBuilderInterface.DetachedSign usingSecureAlgorithms() {
            EncryptionBuilder.this.symmetricKeyAlgorithm = SymmetricKeyAlgorithm.AES_256;
            EncryptionBuilder.this.hashAlgorithm = HashAlgorithm.SHA512;
            EncryptionBuilder.this.compressionAlgorithm = CompressionAlgorithm.UNCOMPRESSED;
            return new DetachedSignImpl();
        }

        @Override
        public EncryptionBuilderInterface.ToRecipients and() {
            return new ToRecipientsImpl();
        }
    }

    class ToRecipientsImpl
    implements EncryptionBuilderInterface.ToRecipients {
        ToRecipientsImpl() {
        }

        @Override
        public EncryptionBuilderInterface.WithAlgorithms toRecipients(PGPPublicKeyRing ... keys) {
            if (keys.length == 0) {
                throw new IllegalArgumentException("No public keys provided.");
            }
            ConcurrentHashMap<SubkeyIdentifier, PGPPublicKeyRing> encryptionKeys = new ConcurrentHashMap<SubkeyIdentifier, PGPPublicKeyRing>();
            for (PGPPublicKeyRing ring : keys) {
                PGPPublicKeyRing validatedKeyRing = KeyRingValidator.validate(ring, PGPainless.getPolicy());
                for (PGPPublicKey k : validatedKeyRing) {
                    if (!EncryptionBuilder.this.encryptionKeySelector().accept(k)) continue;
                    encryptionKeys.put(new SubkeyIdentifier(ring, k.getKeyID()), ring);
                }
            }
            if (encryptionKeys.isEmpty()) {
                throw new IllegalArgumentException("No valid encryption keys found!");
            }
            EncryptionBuilder.this.encryptionKeys.putAll(encryptionKeys);
            return new WithAlgorithmsImpl();
        }

        private String getPrimaryUserId(PGPPublicKey publicKey) {
            return publicKey.getUserIDs().next();
        }

        @Override
        public EncryptionBuilderInterface.WithAlgorithms toRecipients(PGPPublicKeyRingCollection ... keys) {
            if (keys.length == 0) {
                throw new IllegalArgumentException("No key ring collections provided.");
            }
            for (PGPPublicKeyRingCollection collection : keys) {
                for (PGPPublicKeyRing ring : collection) {
                    ConcurrentHashMap<SubkeyIdentifier, PGPPublicKeyRing> encryptionKeys = new ConcurrentHashMap<SubkeyIdentifier, PGPPublicKeyRing>();
                    for (PGPPublicKey k : ring) {
                        if (!EncryptionBuilder.this.encryptionKeySelector().accept(k)) continue;
                        encryptionKeys.put(new SubkeyIdentifier(ring, k.getKeyID()), ring);
                    }
                    if (encryptionKeys.isEmpty()) {
                        throw new IllegalArgumentException("No valid encryption keys found!");
                    }
                    EncryptionBuilder.this.encryptionKeys.putAll(encryptionKeys);
                }
            }
            return new WithAlgorithmsImpl();
        }

        @Override
        public EncryptionBuilderInterface.WithAlgorithms forPassphrases(Passphrase ... passphrases) {
            ArrayList<Passphrase> passphraseList = new ArrayList<Passphrase>();
            for (Passphrase passphrase : passphrases) {
                if (passphrase.isEmpty()) {
                    throw new IllegalArgumentException("Passphrase must not be empty.");
                }
                passphraseList.add(passphrase);
            }
            EncryptionBuilder.this.encryptionPassphrases.addAll(passphraseList);
            return new WithAlgorithmsImpl();
        }

        @Override
        public EncryptionBuilderInterface.DetachedSign doNotEncrypt() {
            return new DetachedSignImpl();
        }
    }
}

