/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.pgpainless.algorithm.AlgorithmSuite;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.Feature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.KeySpecBuilderInterface;
import org.pgpainless.key.generation.type.KeyType;

public class KeySpecBuilder
implements KeySpecBuilderInterface {
    private final KeyType type;
    private final PGPSignatureSubpacketGenerator hashedSubPackets = new PGPSignatureSubpacketGenerator();

    KeySpecBuilder(@Nonnull KeyType type) {
        this.type = type;
    }

    @Override
    public KeySpecBuilderInterface.WithDetailedConfiguration withKeyFlags(KeyFlag ... flags) {
        this.assureKeyCanCarryFlags(flags);
        this.hashedSubPackets.setKeyFlags(false, KeyFlag.toBitmask(flags));
        return new WithDetailedConfigurationImpl();
    }

    private void assureKeyCanCarryFlags(KeyFlag ... flags) {
        int mask = KeyFlag.toBitmask(flags);
        if (!this.type.canCertify() && KeyFlag.hasKeyFlag(mask, KeyFlag.CERTIFY_OTHER)) {
            throw new IllegalArgumentException("KeyType " + this.type.getName() + " cannot carry key flag CERTIFY_OTHER.");
        }
        if (!this.type.canSign() && KeyFlag.hasKeyFlag(mask, KeyFlag.SIGN_DATA)) {
            throw new IllegalArgumentException("KeyType " + this.type.getName() + " cannot carry key flag SIGN_DATA.");
        }
        if (!this.type.canEncryptCommunication() && KeyFlag.hasKeyFlag(mask, KeyFlag.ENCRYPT_COMMS)) {
            throw new IllegalArgumentException("KeyType " + this.type.getName() + " cannot carry key flag ENCRYPT_COMMS.");
        }
        if (!this.type.canEncryptStorage() && KeyFlag.hasKeyFlag(mask, KeyFlag.ENCRYPT_STORAGE)) {
            throw new IllegalArgumentException("KeyType " + this.type.getName() + " cannot carry key flag ENCRYPT_STORAGE.");
        }
        if (!this.type.canAuthenticate() && KeyFlag.hasKeyFlag(mask, KeyFlag.AUTHENTICATION)) {
            throw new IllegalArgumentException("KeyType " + this.type.getName() + " cannot carry key flag AUTHENTIACTION.");
        }
    }

    @Override
    public KeySpec withInheritedSubPackets() {
        return new KeySpec(this.type, null, true);
    }

    class WithFeaturesImpl
    implements KeySpecBuilderInterface.WithFeatures {
        WithFeaturesImpl() {
        }

        @Override
        public KeySpecBuilderInterface.WithFeatures withFeature(@Nonnull Feature feature) {
            KeySpecBuilder.this.hashedSubPackets.setFeature(false, feature.getFeatureId());
            return this;
        }

        @Override
        public KeySpec done() {
            return new KeySpec(KeySpecBuilder.this.type, KeySpecBuilder.this.hashedSubPackets, false);
        }
    }

    class WithPreferredCompressionAlgorithmsImpl
    implements KeySpecBuilderInterface.WithPreferredCompressionAlgorithms {
        WithPreferredCompressionAlgorithmsImpl() {
        }

        @Override
        public KeySpecBuilderInterface.WithFeatures withPreferredCompressionAlgorithms(CompressionAlgorithm ... algorithms) {
            int[] ids = new int[algorithms.length];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = algorithms[i].getAlgorithmId();
            }
            KeySpecBuilder.this.hashedSubPackets.setPreferredCompressionAlgorithms(false, ids);
            return new WithFeaturesImpl();
        }

        @Override
        public KeySpecBuilderInterface.WithFeatures withDefaultCompressionAlgorithms() {
            KeySpecBuilder.this.hashedSubPackets.setPreferredCompressionAlgorithms(false, AlgorithmSuite.getDefaultAlgorithmSuite().getCompressionAlgorithmIds());
            return new WithFeaturesImpl();
        }
    }

    class WithPreferredHashAlgorithmsImpl
    implements KeySpecBuilderInterface.WithPreferredHashAlgorithms {
        WithPreferredHashAlgorithmsImpl() {
        }

        @Override
        public KeySpecBuilderInterface.WithPreferredCompressionAlgorithms withPreferredHashAlgorithms(HashAlgorithm ... algorithms) {
            int[] ids = new int[algorithms.length];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = algorithms[i].getAlgorithmId();
            }
            KeySpecBuilder.this.hashedSubPackets.setPreferredHashAlgorithms(false, ids);
            return new WithPreferredCompressionAlgorithmsImpl();
        }

        @Override
        public KeySpecBuilderInterface.WithPreferredCompressionAlgorithms withDefaultHashAlgorithms() {
            KeySpecBuilder.this.hashedSubPackets.setPreferredHashAlgorithms(false, AlgorithmSuite.getDefaultAlgorithmSuite().getHashAlgorithmIds());
            return new WithPreferredCompressionAlgorithmsImpl();
        }
    }

    class WithPreferredSymmetricAlgorithmsImpl
    implements KeySpecBuilderInterface.WithPreferredSymmetricAlgorithms {
        WithPreferredSymmetricAlgorithmsImpl() {
        }

        @Override
        public KeySpecBuilderInterface.WithPreferredHashAlgorithms withPreferredSymmetricAlgorithms(SymmetricKeyAlgorithm ... algorithms) {
            int[] ids = new int[algorithms.length];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = algorithms[i].getAlgorithmId();
            }
            KeySpecBuilder.this.hashedSubPackets.setPreferredSymmetricAlgorithms(false, ids);
            return new WithPreferredHashAlgorithmsImpl();
        }

        @Override
        public KeySpecBuilderInterface.WithPreferredHashAlgorithms withDefaultSymmetricAlgorithms() {
            KeySpecBuilder.this.hashedSubPackets.setPreferredSymmetricAlgorithms(false, AlgorithmSuite.getDefaultAlgorithmSuite().getSymmetricKeyAlgorithmIds());
            return new WithPreferredHashAlgorithmsImpl();
        }

        @Override
        public KeySpecBuilderInterface.WithFeatures withDefaultAlgorithms() {
            KeySpecBuilder.this.hashedSubPackets.setPreferredSymmetricAlgorithms(false, AlgorithmSuite.getDefaultAlgorithmSuite().getSymmetricKeyAlgorithmIds());
            KeySpecBuilder.this.hashedSubPackets.setPreferredCompressionAlgorithms(false, AlgorithmSuite.getDefaultAlgorithmSuite().getCompressionAlgorithmIds());
            KeySpecBuilder.this.hashedSubPackets.setPreferredHashAlgorithms(false, AlgorithmSuite.getDefaultAlgorithmSuite().getHashAlgorithmIds());
            return new WithFeaturesImpl();
        }
    }

    class WithDetailedConfigurationImpl
    implements KeySpecBuilderInterface.WithDetailedConfiguration {
        WithDetailedConfigurationImpl() {
        }

        @Override
        @Deprecated
        public KeySpecBuilderInterface.WithPreferredSymmetricAlgorithms withDetailedConfiguration() {
            return new WithPreferredSymmetricAlgorithmsImpl();
        }

        @Override
        public KeySpec withDefaultAlgorithms() {
            AlgorithmSuite defaultSuite = AlgorithmSuite.getDefaultAlgorithmSuite();
            KeySpecBuilder.this.hashedSubPackets.setPreferredCompressionAlgorithms(false, defaultSuite.getCompressionAlgorithmIds());
            KeySpecBuilder.this.hashedSubPackets.setPreferredSymmetricAlgorithms(false, defaultSuite.getSymmetricKeyAlgorithmIds());
            KeySpecBuilder.this.hashedSubPackets.setPreferredHashAlgorithms(false, defaultSuite.getHashAlgorithmIds());
            KeySpecBuilder.this.hashedSubPackets.setFeature(false, (byte)1);
            return new KeySpec(KeySpecBuilder.this.type, KeySpecBuilder.this.hashedSubPackets, false);
        }
    }
}

