/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class RevocationAttributes {
    private final Reason reason;
    private final String description;

    private RevocationAttributes(Reason reason, String description) {
        this.reason = reason;
        this.description = description;
    }

    public Reason getReason() {
        return this.reason;
    }

    public String getDescription() {
        return this.description;
    }

    public static WithReason createKeyRevocation() {
        return new WithReason(RevocationType.KEY_REVOCATION);
    }

    public static WithReason createCertificateRevocation() {
        return new WithReason(RevocationType.CERT_REVOCATION);
    }

    public static final class WithDescription {
        private final Reason reason;

        private WithDescription(Reason reason) {
            this.reason = reason;
        }

        public RevocationAttributes withDescription(String description) {
            return new RevocationAttributes(this.reason, description);
        }
    }

    public static final class WithReason {
        private final RevocationType type;

        private WithReason(RevocationType type) {
            this.type = type;
        }

        public WithDescription withReason(Reason reason) {
            this.throwIfReasonTypeMismatch(reason, this.type);
            return new WithDescription(reason);
        }

        private void throwIfReasonTypeMismatch(Reason reason, RevocationType type) {
            if (type == RevocationType.KEY_REVOCATION) {
                if (reason == Reason.USER_ID_NO_LONGER_VALID) {
                    throw new IllegalArgumentException("Reason " + (Object)((Object)reason) + " can only be used for certificate revocations, not to revoke keys.");
                }
            } else if (type == RevocationType.CERT_REVOCATION) {
                switch (reason) {
                    case KEY_SUPERSEDED: 
                    case KEY_COMPROMISED: 
                    case KEY_RETIRED: {
                        throw new IllegalArgumentException("Reason " + (Object)((Object)reason) + " can only be used for key revocations, not to revoke certificates.");
                    }
                }
            }
        }
    }

    public static enum RevocationType {
        KEY_REVOCATION,
        CERT_REVOCATION;

    }

    public static enum Reason {
        NO_REASON(0),
        KEY_SUPERSEDED(1),
        KEY_COMPROMISED(2),
        KEY_RETIRED(3),
        USER_ID_NO_LONGER_VALID(32);

        private static final Map<Byte, Reason> MAP;
        private final byte reasonCode;

        public static Reason fromCode(byte code) {
            Reason reason = MAP.get(code);
            if (reason == null) {
                throw new IllegalArgumentException("Invalid revocation reason: " + code);
            }
            return reason;
        }

        public static boolean isHardRevocation(byte code) {
            Reason reason = MAP.get(code);
            return reason != KEY_SUPERSEDED && reason != KEY_RETIRED && reason != USER_ID_NO_LONGER_VALID;
        }

        private Reason(byte reasonCode) {
            this.reasonCode = reasonCode;
        }

        public byte code() {
            return this.reasonCode;
        }

        public String toString() {
            return this.code() + " - " + this.name();
        }

        static {
            MAP = new ConcurrentHashMap<Byte, Reason>();
            for (Reason r : Reason.values()) {
                MAP.put(r.reasonCode, r);
            }
        }
    }
}

