/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;

public abstract class SelectSignatureFromKey {
    private static final Logger LOGGER = Logger.getLogger(SelectSignatureFromKey.class.getName());

    public abstract boolean accept(PGPSignature var1, PGPPublicKey var2, PGPKeyRing var3);

    public List<PGPSignature> select(List<PGPSignature> signatures, PGPPublicKey key, PGPKeyRing keyRing) {
        ArrayList<PGPSignature> selected = new ArrayList<PGPSignature>();
        for (PGPSignature signature : signatures) {
            if (!this.accept(signature, key, keyRing)) continue;
            selected.add(signature);
        }
        return selected;
    }

    public static SelectSignatureFromKey isValidAt(final Date validationDate) {
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                Date expirationDate = SignatureUtils.getSignatureExpirationDate(signature);
                return !signature.getCreationTime().after(validationDate) && (expirationDate == null || expirationDate.after(validationDate));
            }
        };
    }

    public static SelectSignatureFromKey isValidSubkeyBindingSignature(final PGPPublicKey primaryKey, final PGPPublicKey subkey) {
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                boolean isSigningKey;
                if (!2.isOfType(SignatureType.SUBKEY_BINDING).accept(signature, key, keyRing)) {
                    return false;
                }
                if (signature.getKeyID() != primaryKey.getKeyID()) {
                    return false;
                }
                if (!2.isSigNotExpired().accept(signature, subkey, keyRing)) {
                    LOGGER.log(Level.INFO, "Subkey binding signature expired.");
                    return false;
                }
                try {
                    signature.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), primaryKey);
                    boolean subkeyBindingSigValid = signature.verifyCertification(primaryKey, subkey);
                    if (!subkeyBindingSigValid) {
                        return false;
                    }
                }
                catch (PGPException e) {
                    LOGGER.log(Level.INFO, "Verification of subkey binding signature failed.", e);
                    return false;
                }
                List<KeyFlag> flags = KeyFlag.fromBitmask(signature.getHashedSubPackets().getKeyFlags());
                boolean bl = isSigningKey = flags.contains((Object)KeyFlag.SIGN_DATA) || flags.contains((Object)KeyFlag.CERTIFY_OTHER);
                if (isSigningKey && !2.hasValidPrimaryKeyBindingSignatureSubpacket(subkey, primaryKey).accept(signature, subkey, keyRing)) {
                    LOGGER.log(Level.INFO, "Subkey binding signature on signing key does not carry valid primary key binding signature.");
                    return false;
                }
                return true;
            }
        };
    }

    public static SelectSignatureFromKey isValidPrimaryKeyBindingSignature(final PGPPublicKey subkey, final PGPPublicKey primaryKey) {
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                if (!3.isVersion4Signature().accept(signature, key, keyRing)) {
                    return false;
                }
                if (!3.isOfType(SignatureType.PRIMARYKEY_BINDING).accept(signature, key, keyRing)) {
                    return false;
                }
                if (signature.getKeyID() != subkey.getKeyID()) {
                    return false;
                }
                if (!3.isSigNotExpired().accept(signature, primaryKey, keyRing)) {
                    LOGGER.log(Level.INFO, "Primary key binding signature expired.");
                    return false;
                }
                try {
                    signature.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), subkey);
                    return signature.verifyCertification(primaryKey, subkey);
                }
                catch (PGPException e) {
                    return false;
                }
            }
        };
    }

    public static SelectSignatureFromKey hasValidPrimaryKeyBindingSignatureSubpacket(final PGPPublicKey subkey, final PGPPublicKey primaryKey) {
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                try {
                    PGPSignatureList embeddedSignatures = SignatureSubpacketsUtil.getEmbeddedSignature(signature);
                    if (embeddedSignatures != null) {
                        for (PGPSignature embeddedSignature : embeddedSignatures) {
                            if (!4.isValidPrimaryKeyBindingSignature(subkey, primaryKey).accept(embeddedSignature, subkey, keyRing)) continue;
                            return true;
                        }
                    }
                }
                catch (PGPException e) {
                    LOGGER.log(Level.WARNING, "Cannot parse embedded signatures:", e);
                }
                return false;
            }
        };
    }

    public static SelectSignatureFromKey isValidDirectKeySignature(final PGPPublicKey signer, final PGPPublicKey signee) {
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                if (!5.isVersion4Signature().accept(signature, key, keyRing)) {
                    return false;
                }
                if (!5.isOfType(SignatureType.DIRECT_KEY).accept(signature, key, keyRing)) {
                    return false;
                }
                try {
                    signature.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), signer);
                    return signature.verifyCertification(signee);
                }
                catch (PGPException e) {
                    return false;
                }
            }
        };
    }

    public static SelectSignatureFromKey isValidKeyRevocationSignature(PGPPublicKey key) {
        return SelectSignatureFromKey.and(SelectSignatureFromKey.isVersion4Signature(), SelectSignatureFromKey.isOfType(SignatureType.KEY_REVOCATION), SelectSignatureFromKey.isCreatedBy(key), SelectSignatureFromKey.isWellFormed(), SelectSignatureFromKey.doesNotPredateKeyCreationDate(key), SelectSignatureFromKey.isVerifyingSignatureOnKey(key, key));
    }

    public static SelectSignatureFromKey isValidSubkeyRevocationSignature() {
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                return 6.isValidSubkeyRevocationSignature(key, keyRing.getPublicKey()).accept(signature, key, keyRing);
            }
        };
    }

    public static SelectSignatureFromKey isValidSubkeyRevocationSignature(PGPPublicKey subkey, PGPPublicKey primaryKey) {
        return SelectSignatureFromKey.and(SelectSignatureFromKey.isVersion4Signature(), SelectSignatureFromKey.isOfType(SignatureType.SUBKEY_REVOCATION), SelectSignatureFromKey.isCreatedBy(primaryKey), SelectSignatureFromKey.isVerifyingSignatureOnKeys(primaryKey, subkey, primaryKey));
    }

    public static SelectSignatureFromKey isValidCertificationRevocationSignature(PGPPublicKey revoker, String userId) {
        return SelectSignatureFromKey.and(SelectSignatureFromKey.isVersion4Signature(), SelectSignatureFromKey.isCreatedBy(revoker), SelectSignatureFromKey.isOfType(SignatureType.CERTIFICATION_REVOCATION), SelectSignatureFromKey.isValidSignatureOnUserId(userId, revoker));
    }

    public static SelectSignatureFromKey isValidSignatureOnUserId(final String userId, final PGPPublicKey signingKey) {
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                try {
                    signature.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), signingKey);
                    return signature.verifyCertification(userId, key);
                }
                catch (PGPException e) {
                    LOGGER.log(Level.INFO, "Verification of signature on userID " + userId + " failed.", e);
                    return false;
                }
            }
        };
    }

    public static SelectSignatureFromKey isVerifyingSignatureOnKey(final PGPPublicKey target, final PGPPublicKey signer) {
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                try {
                    signature.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), signer);
                    boolean valid = signature.verifyCertification(target);
                    return valid;
                }
                catch (PGPException e) {
                    LOGGER.log(Level.INFO, "Signature verification failed.", e);
                    return false;
                }
            }
        };
    }

    public static SelectSignatureFromKey isVerifyingSignatureOnKeys(final PGPPublicKey primaryKey, final PGPPublicKey subkey, final PGPPublicKey signingKey) {
        if (signingKey.getKeyID() != primaryKey.getKeyID() && signingKey.getKeyID() != subkey.getKeyID()) {
            throw new IllegalArgumentException("Signing key MUST be either the primary or subkey.");
        }
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                try {
                    signature.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), signingKey);
                    return signature.verifyCertification(primaryKey, subkey);
                }
                catch (PGPException e) {
                    LOGGER.log(Level.INFO, "Verification of " + (Object)((Object)SignatureType.valueOf(signature.getSignatureType())) + " signature failed.", e);
                    return false;
                }
            }
        };
    }

    public static SelectSignatureFromKey isCertification() {
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                return signature.isCertification();
            }
        };
    }

    public static SelectSignatureFromKey isWellFormed() {
        return SelectSignatureFromKey.and(SelectSignatureFromKey.hasCreationTimeSubpacket(), SelectSignatureFromKey.doesNotPredateKeyCreationDate());
    }

    public static SelectSignatureFromKey isVersion4Signature() {
        return SelectSignatureFromKey.isVersion(4);
    }

    public static SelectSignatureFromKey hasCreationTimeSubpacket() {
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                return signature.getHashedSubPackets().getSignatureCreationTime() != null;
            }
        };
    }

    public static SelectSignatureFromKey isCreatedBy(PGPPublicKey publicKey) {
        return SelectSignatureFromKey.isCreatedBy(publicKey.getKeyID());
    }

    public static SelectSignatureFromKey isCreatedBy(final long keyId) {
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                return signature.getKeyID() == keyId;
            }
        };
    }

    public static SelectSignatureFromKey isSigNotExpired() {
        return SelectSignatureFromKey.isSigNotExpired(new Date());
    }

    public static SelectSignatureFromKey isSigNotExpired(final Date comparisonDate) {
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                return !SignatureUtils.isSignatureExpired(signature, comparisonDate);
            }
        };
    }

    public static SelectSignatureFromKey doesNotPredateKeyCreationDate() {
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                PGPPublicKey creator = keyRing.getPublicKey(signature.getKeyID());
                if (creator == null) {
                    return false;
                }
                return 14.doesNotPredateKeyCreationDate(creator).accept(signature, key, keyRing);
            }
        };
    }

    public static SelectSignatureFromKey doesNotPredateKeyCreationDate(final PGPPublicKey creator) {
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                return !signature.getCreationTime().before(creator.getCreationTime());
            }
        };
    }

    public static SelectSignatureFromKey isVersion(final int version) {
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                return signature.getVersion() == version;
            }
        };
    }

    public static SelectSignatureFromKey isOfType(final SignatureType signatureType) {
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                return signature.getSignatureType() == signatureType.getCode();
            }
        };
    }

    public static SelectSignatureFromKey and(final SelectSignatureFromKey ... selectors) {
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                for (SelectSignatureFromKey selector : selectors) {
                    if (selector.accept(signature, key, keyRing)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static SelectSignatureFromKey or(final SelectSignatureFromKey ... selectors) {
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                boolean accept = false;
                for (SelectSignatureFromKey selector : selectors) {
                    accept |= selector.accept(signature, key, keyRing);
                }
                return accept;
            }
        };
    }

    public static SelectSignatureFromKey not(final SelectSignatureFromKey selector) {
        return new SelectSignatureFromKey(){

            @Override
            public boolean accept(PGPSignature signature, PGPPublicKey key, PGPKeyRing keyRing) {
                return !selector.accept(signature, key, keyRing);
            }
        };
    }
}

